function rankImage = computePriorRankImage(locations, strength, imH, imW)
    %David Fouhey, Abhinav Gupta, Martial Hebert
    %Data-Driven 3D Primitives For Single Image Understanding 
    %ICCV 2013
    %
    %Inference-only code

    %Take an isotropic Gaussian mixture model with means at locations specified
    %in relative (i.e., [0,1]) image coordinates, a common spatial bandwidth
    %parameter, and return a rank image from [0, 1] indicating the ranked
    %likelihood of each point under the GMM.
    [X,Y] = meshgrid(1:imW,1:imH);
    Lx = locations(:,1); Ly = locations(:,2);
    %X distances, Y distances
    XProbs = normpdf(pdist2(X(:)/imW, Lx),0,strength);
    YProbs = normpdf(pdist2(Y(:)/imH, Ly),0,strength);
    %the probabilities for each mixture component
    mixtureProbs = XProbs .* YProbs;
    p = sum(mixtureProbs,2) / size(locations,1);
    ranks = tiedrank(p);
    rankImage = reshape(ranks ./ numel(ranks),[imH,imW]);

end
