function alreadyLocked = isLocked(lockName)
    %David Fouhey, Abhinav Gupta, Martial Hebert
    %Data-Driven 3D Primitives For Single Image Understanding 
    %ICCV 2013
    %
    %Inference-only code

    %return false only if a lock can be successfully created
    %i.e., return true if locked. 
    %if not, attempt to lock, return true if lock was already created.
    if exist(lockName)
        alreadyLocked = true;
        return;
    end
    %ok - assume it's ok
    alreadyLocked = false;
    [s, mess, messid] = mkdir(lockName);
    %check to make sure we don't get any error messages
    if numel(mess) > 0
        alreadyLocked = true;
    end 
end
