% Author: saurabh.me@gmail.com (Saurabh Singh)

numTop = 50;

all = [testSetPos testSetNeg];

condMaxImgs = zeros(length(all));
baseMaxImgs = zeros(length(all));

for i  = 1 : length(all)
  cboxes = boxes1Cond{i};
  bboxes = boxes1Base{i};
  condMaxImgs(i) = max(cboxes(:, end));
  baseMaxImgs(i) = max(bboxes(:, end));
end

[dummy cmaxInds] = sort(condMaxImgs, 'descend');
[dummy bmaxInds] = sort(baseMaxImgs, 'descend');

selCondInds = cmaxInds(1:numTop);
selCond = all(selCondInds);
selBaseInds = bmaxInds(1:numTop);
selBase = all(selBaseInds);

for i = 1 : length(selCond)
  img1Path = [HOMEIMAGES selCond(i).annotation.folder '/' ...
      selCond(i).annotation.filename];
  img2Path = [HOMEIMAGES selBase(i).annotation.folder '/' ...
      selBase(i).annotation.filename];
  imCond = imread(img1Path);  
  imBase = imread(img2Path);  
    
  fig1 = figure(1); clf;
  myshowboxes(imCond, boxes1Cond{selCondInds(i)}, 5);
  fig2 = figure(2); clf;
  myshowboxes(imBase, boxes1Base{selBaseInds(i)}, 5);
  fig3 = figure(3); clf;
  LMplot(selCond(i), 1, HOMEIMAGES); title('Ground Truth');
  fig4 = figure(4); clf;
  LMplot(selBase(i), 1, HOMEIMAGES); title('Ground Truth');
  
  print(fig1, '-djpeg', '-r0', ...
      sprintf('top100/cond/%d_cond.jpg', i));
  print(fig3, '-djpeg', '-r0', ...
      sprintf('top100/cond/%d_gtht.jpg', i));
  
  print(fig2, '-djpeg', '-r0', ...
      sprintf('top100/base/%d_base.jpg', i));
  print(fig4, '-djpeg', '-r0', ...
      sprintf('top100/base/%d_gtht.jpg', i));
  
end
