function data = getDataSet(name, mode, CONFIG)
% Gets the appropriate data set.
%
% Author: saurabh.me@gmail.com (Saurabh Singh).
switch(name)
  case 'NYU'
    data.imgsHome = CONFIG.NYUDir;
    if(strcmp(mode, 'train'))
      data.data = getNYUShortData(data.imgsHome);
     end
  case 'NYUShort'
    data.imgsHome = CONFIG.NYUShortDir;
    if(strcmp(mode, 'train'))
      data.data = getNYUShortData(data.imgsHome);
     end
  case 'TempDistractors'
    data.imgsHome = CONFIG.TempDistractorsDir;
    if(strcmp(mode,'train'))
      data.data = getNYUShortData(data.imgsHome);
    end
  case 'suns'
    data.imgsHome = CONFIG.sunsImgHome;
    if strcmp(mode, 'test')
      load([CONFIG.sunsDataDir 'data.mat'], 'sunsTesting');
      data.data = sunsTesting;
    elseif strcmp(mode, 'train')
      load([CONFIG.sunsDataDir 'data.mat'], 'sunsTraining');
      data.data = sunsTraining;
    else
      error('Mode %s not supported, {test, train}', mode);
    end
  case 'pascal2007'
    data.imgsHome = CONFIG.pascalImgHome;
    if strcmp(mode, 'test')
      load([CONFIG.pascalDataDir 'test.mat'], 'pascalTestData');
      data.data = pascalTestData;
    elseif strcmp(mode, 'train')
      load([CONFIG.pascalDataDir 'train.mat'], 'pascalTrainData');
      data.data = pascalTrainData;
    else
      error('Mode %s not supported, {test, train}', mode);
    end
  case 'indoor67'
    data.imgsHome = CONFIG.indoor67ImgHome;
    if strcmp(mode, 'test')
      load([CONFIG.indoor67DataDir 'test.mat'], 'indoor67TestData');
      data.data = indoor67TestData;
    elseif strcmp(mode, 'train')
      load([CONFIG.indoor67DataDir 'train.mat'], 'indoor67TrainData');
      data.data = indoor67TrainData;
    else
      error('Mode %s not supported, {test, train}', mode);
    end
  case 'hayes6Million'
    data.imgsHome = CONFIG.hayes6MillImgHome;
    if strcmp(mode, 'test')
      load([CONFIG.hayes6MillDataDir 'test.mat'], 'hayes6MillTestData');
      data.data = hayes6MillTestData;
    elseif strcmp(mode, 'train')
      load([CONFIG.hayes6MillDataDir 'train.mat'], 'hayes6MillTrainData');
      data.data = hayes6MillTrainData;
    else
      error('Mode %s not supported, {test, train}', mode);
    end
  case 'paris1'
    data.imgsHome = CONFIG.paris1ImgHome;
    if strcmp(mode, 'test')
      load([CONFIG.paris1DataDir 'test.mat'], 'paris1TestData');
      data.data = paris1TestData;
    elseif strcmp(mode, 'train')
      load([CONFIG.paris1DataDir 'train.mat'], 'paris1TrainData');
      data.data = paris1TrainData;
    else
      error('Mode %s not supported, {test, train}', mode);
    end
  case 'pascal2010Action'
    data.imgsHome = CONFIG.pascal2010ImgHome;
    if strcmp(mode, 'test')
      load([CONFIG.pascalDataDir 'actionTest.mat'], 'actionData', ...
        'actionClasses');
      data.data = actionData;
      data.actionClasses = actionClasses;
    elseif strcmp(mode, 'train')
      load([CONFIG.pascalDataDir 'actionTrain.mat'], 'actionData', ...
        'actionClasses');
      data.data = actionData;
      data.actionClasses = actionClasses;
    else
      error('Mode %s not supported, {test, train}', mode);
    end
  case 'msrcV2'
    data.imgsHome = CONFIG.msrcV2ImgHome;
    if strcmp(mode, 'train')
      load([CONFIG.msrcV2DataDir 'train.mat'], 'msrcTrainData');
      data.data = msrcTrainData;
    else
      error('Mode %s not supported, {train}', mode);
    end
  case 'trecvidBbn'
    data.imgsHome = CONFIG.trecvidBbnImgHome;
    if strcmp(mode, 'train')
      load([CONFIG.trecvidBbnDataDir 'train.mat'], 'trecvidBbnTrainData');
      data.data = trecvidBbnTrainData;
    else
      error('Mode %s not supported, {train}', mode);
    end
  otherwise
    error('Unrecognized dataset %s', name);
end
end
