function [locInfo] = getLocationInfo(primaryCat, patches, imgInds, anno,...
  homeImgs)
% Gets the location information of each patch.
%
% primaryCat: (string) the category against which the location information
%   is to be calculated.
% patches: (cell) Per image patches.
% meta: (struct) Annotation structures for the images.
%
% Author: saurabh.me@gmail.com (Saurabh Singh).

pedPos = cell(size(anno));
for i = 1 : length(anno)
  pedPos{i} = convertDataSun09ToPedro(primaryCat, anno(i), [], ...
    false, homeImgs);
end

locInfo = struct('xy', {}, 'scale', {}, 'aspect', {});
locInfo(length(patches), 1).xy = [];
for i = 1 : length(patches)
  xyLoc = zeros(1, 2 * length(pedPos{imgInds(i)}));
  scLoc = zeros(1, length(pedPos{imgInds(i)}));
  aspLoc = zeros(1, length(pedPos{imgInds(i)}));
  
  
  [cx cy] = getPatchCenter(patches(i));
  cVertExt = getPatchVerticalExtent(patches(i));
  imgPedPos = pedPos{imgInds(i)};
  for m = 1 : length(imgPedPos)
    [px py] = getPatchCenter(imgPedPos(m));
    pVertExt = getPatchVerticalExtent(imgPedPos(m));
    xyLoc(2*m-1:2*m) = ([px py] - [cx cy]) / cVertExt;
    scLoc(m) = pVertExt / cVertExt;
    aspLoc(m) = getPatchAspectRatio(imgPedPos(m));
  end
  
  locInfo(i).xy = xyLoc;
  locInfo(i).scale = scLoc;
  locInfo(i).aspect = aspLoc;
end
end
