function visualizeDetectionVotings(testSet, imageIds, clusters, ...
  results, detectors, selectedClusters, logRegWt, outDir, thresh, ...
  instanceId)
if length(imageIds) ~=length(testSet) || ...
    length(imageIds) ~= length(results)
  error('Incorrect data passed as argument');
end

% Turn off the detectors logistic parameters.
detectors.logisParams = {};
detectors.firstLevMmhtWts = {};

primaryCat = detectors.params.category;
% clustInd = find(selectedClusters==clusters);
% Order the images by detection scores, so that we see the best detection
% first.
% [inds, scores] = getScoreOrdered(results, clustInd);
inds = randperm(length(testSet));
testSet = testSet(inds);
results = results(inds);
imageIds = imageIds(inds);

for i = 1 : length(testSet)
  uniqueId = sprintf('%d_img', imageIds(i));
  if isStillUnprocessed(instanceId, uniqueId, outDir, '', '.jpg')
  
  %   if isempty(results{i}.firstLevel.detections(clustInd).metadata)
  %     continue;
  %   end
    I = im2double(imread(results{i}.firstLevel.imagePath));
    img = testSet(i);
    locSpace = detectors.getLocationSpaceForImage(img);
    [pedPos unused] = convertDataSun09ToPedro(primaryCat, img, ...
        [], false);
    posPoints = convertPatchToLocationSpaceCoods(pedPos);
    dist = getEmptyDistribution(locSpace, true);
    % Reduce the prior belief, this would not be required once the vote
    % normalizations are fixed.
    dist = dist ./ 10;

    figure(1); clf;
    fig1 = imagesc(I);
    axis equal;

    oneFound = false;
    usedClusts = [];

    for cl = 1 : length(clusters)
      clustInd = find(selectedClusters == clusters(cl));
      clustMeta = results{i}.firstLevel.detections(clustInd).metadata;
      clustScore = results{i}.firstLevel.detections(clustInd).decision;
      if isempty(clustMeta)
        disp('No detection');
        continue;
      end

      detVotes = getDetectionVoteLocations(clustMeta, ...
        detectors.mixModel{clustInd});

      for j = 1 : length(detVotes)
        piped = valLogReg(logRegWt{clustInd}, clustScore(j));
        fprintf('Score %f->%f ', clustScore(j), piped);
        if piped < thresh
          disp('dropped');
          continue;
        else
          oneFound = true;
          usedClusts = [usedClusts; clusters(cl)];
          disp('computing');
        end
        wt = piped;

        res = results{i};
        res.firstLevel.detections(clustInd).metadata = clustMeta(j);
        res.firstLevel.detections(clustInd).decision = clustScore(j);

        [distribution, dist2L] = detectors.doVotingForResult2( ...
            res, clustInd, locSpace);

        dist = dist + distribution * wt;
    %     dr = sum(sum(distribution, 3), 4);
    %     imagesc(dr);
    %     pause;

        [votePos, voteNeg] = eliminatePointsNearPositives( ...
          detVotes{j}, posPoints, locSpace);

        detPoints = convertPatchToLocationSpaceCoods(clustMeta(j));
        tmpbox = getBoxesForPedro(clustMeta(j), clustScore(j));
        picks = nms(tmpbox, 0.5);
        boxes = tmpbox(picks, :);

        % display
        displayPatchBox(boxes);
        drawlocationSpacePoints(posPoints, 'og');
        drawlocationSpacePoints(detPoints, 'oc');
        drawlocationSpacePoints(voteNeg, 'xr');
        drawlocationSpacePoints(votePos, 'xg');
        title(sprintf('%.3f', max(boxes(:, 5))));
%         keyboard;
      end
    end
    saveas(fig1, sprintf('%s/%d_img.jpg', outDir, imageIds(i)), 'jpg');
    distribution = dist;
    dist2L = [];
    save([outDir sprintf('%d_distrib.mat', imageIds(i))], 'locSpace', ...
      'distribution', 'dist2L');
    
    if oneFound
      dr = sum(sum(dist, 3), 4);
      [rows, cols, dims] = size(I);
      dr = imresize(dr, [rows, cols]);
      figure(2);
      fig3 = imagesc(dr);

      dr = dr - min(dr(:));
      dr = dr ./ max(dr(:));
      I1 = I;
      I1(:, :, 1) = I1(:, :, 1) .* dr;
      I1(:, :, 2) = I1(:, :, 2) .* dr;
      figure(3); clf;
      fig2 = imagesc(I1);
      colorbar;

      saveas(fig2, sprintf('%s/%d_vot.jpg', outDir, imageIds(i)), 'jpg');
      saveas(fig3, sprintf('%s/%d_scl.jpg', outDir, imageIds(i)), 'jpg');
%       keyboard;
    end
    doneProcessing(uniqueId, outDir);
  end
end
end


  
