function patchWeights = getPatchWeights(logisParams, decision)
if ~isempty(logisParams)
  decision = reshape(decision, length(decision), []);
  patchWeights = valLogReg(logisParams, decision);
  % Some threshold to make computations faster. These would ensure that we
  % do not calculate votes for patches, for which the score is too low
  % anyway.
  patchWeights(decision <= -1) = 0;
  patchWeights(patchWeights < 0.05) = 0;
else
  % Have equal weights for all the patches.
  patchWeights = ones(size(decision));
end
end
