function scoreCutoff = computePrecisionCutoff(scoreAndPrecision, cutoff)
    %David Fouhey, Abhinav Gupta, Martial Hebert
    %Data-Driven 3D Primitives For Single Image Understanding 
    %ICCV 2013
    %
    %Inference-only code
    %takes a Nx2 matrix of [scores, cumulative precisions] and finds the 
    %lowest score such that the cumulative precision is at least cutoff
    %Assuming SVM scores, 1e10 should never fire
    if max(scoreAndPrecision(:,2)) < cutoff
        scoreCutoff = 1e10;
        return;
    end
    maxIndex = max(find(scoreAndPrecision(:,2) >= cutoff));
    scoreCutoff = scoreAndPrecision(maxIndex,1); 
end
