//
//  Real/Expr Package Ver. 1.0
//    Copywrite (c) 1995, 1996 Exact Computation Project
//    written by Koji Ouchi (ouchi@simulation.nyu.edu)
//
//  File: ExprUtil.h
//    class ExprDict
//

#ifndef _EXPRUTIL_H
#define _EXPRUTIL_H

//  forward reference

class ExprRep;
class ExprDict;

//  class ExprDictItem
//    dictionary item

class ExprDictItem
{
friend class ExprDict;
  
  ExprRep* key;
  ExprRep* inf;
  
  ExprDictItem* next;
  
public:
  
  //  constructor
  
  ExprDictItem(ExprRep*, ExprRep*);
  
  //  the destructor
  
  ~ExprDictItem();
  
  //  bultin-functions
  
  ExprRep* getKey();
  ExprRep* getInf();
};

//  class ExprDict
//    dictionary

class ExprDict
{
  ExprDictItem* dict;
  
public:
  
  //  constructor
  
  ExprDict();
  
  //  the destructor
  
  ~ExprDict();
  
  //  bultin-functions
  
  ExprDictItem* insert(ExprDictItem*);
  ExprDictItem* lookUp(ExprRep*);
  void deleteKey(ExprRep*);
};

#endif

