//
//  Real/Expr Package Ver. 1.0
//    Copywrite (c) 1995, 1996 Exact Computation Project
//    written by Koji Ouchi (ouchi@simulation.nyu.edu)
//
//  File: ExprUtil.cc
//    class ExprDict
//

#include "ExprUtil.h"

//  class ExprDictItem

//  constructor

ExprDictItem :: ExprDictItem(ExprRep* k, ExprRep* i)
{
  key = k;
  inf = i;
  
  next = 0;
}

//  the destructor

ExprDictItem :: ~ExprDictItem()
{}

//  bultin-functions

ExprRep* ExprDictItem :: getKey()
{
  return key;
}

ExprRep* ExprDictItem :: getInf()
{
  return inf;
}

//  class ExprDict

//  constructor

ExprDict :: ExprDict()
{
  dict = 0;
}

//  the destructor

ExprDict :: ~ExprDict()
{
  ExprDictItem* curr = dict;
  ExprDictItem* prev;
  
  while (curr)
  {
    prev = curr;
    curr = curr->next;
    delete prev;
  }
}

//  bultin-functions

ExprDictItem* ExprDict :: insert(ExprDictItem* i)
{
  ExprDictItem* curr = dict;
  dict = i;
  i->next = curr;
}

ExprDictItem* ExprDict :: lookUp(ExprRep* k)
{
  ExprDictItem* curr = dict;
  
  while (curr && curr->getKey() != k)
    curr = curr->next;
  
  return curr;
}

void ExprDict :: deleteKey(ExprRep* k)
{
  ExprDictItem* curr = dict;
  ExprDictItem* prev;
  
  while (curr && curr->getKey() != k)
  {
    prev = curr;
    curr = curr->next;
  }
  
  if (curr)
  {
    prev->next = curr->next;
    delete curr;
  }
}

