//
//  Real/Expr Package Ver. 1.0
//    Copywrite (c) 1995, 1996 Exact Computation Project
//    written by Koji Ouchi (ouchi@simulation.nyu.edu)
//
//  File: det.cc
//

#include "Expr.h"

class Matrix
{
  int   dimension;
//  Real* element;
  Expr* element;
  
public:
  
  Matrix(int d)
  {
    dimension = d;
    element   = new Expr [d*d];
  }
  
  ~Matrix()
  {
    delete [] element;
  }
  
  void putElement(int r, int c, Real v)
  {
    *(element + (r * dimension + c)) = v;
  }
  
  Expr getElement(int r, int c) const
  {
    return *(element + (r * dimension + c));
  }
  
  Expr getDeterminantExpr() const;
};

Expr Matrix :: getDeterminantExpr() const
{
  int   sign = 1;
  int*  trial  = new int [dimension];
  int*  column = new int [dimension];
//  Expr* elementExpr = new Expr [dimension * dimension];
  Expr  determinant;
  
  int i, r, rr, c;
  
  for (i = 0; i < dimension; i++)
  {
    trial[i]  = 0;
    column[i] = dimension;
  }
  
//  for (i = 0; i < dimension; i++)
//    for (int j = 0; j < dimension; j++)
//      *(elementExpr + (i * dimension + j)) = getElement(i, j);
  
  r = 0;
  determinant = 0;
  
  while (r >= 0)
  {
    while (r < dimension)
    {
      int t = trial[r];
      if (t & 1)
	sign *= -1;
      
      c = 0;
      while (c < dimension && t >= 0)
	if (column[c++] == dimension)
	  t--;
      
      column[c - 1] = r++;
    }
    
    Expr p;
//    p = *(elementExpr + column[0]);
    p = *(element + column[0]);
    for (i = 1; i < dimension; i++)
//      p.reset(p * *(elementExpr + (i * dimension + column[i])));
      p.reset(p * *(element + (i * dimension + column[i])));
    
    if (sign > 0)
      determinant.reset(determinant + p);
    else
      determinant.reset(determinant - p);
    
    r = dimension;
    while (trial[--r] == dimension - 1 - r)
      ;
    
    if (r >= 0)
    {
      if (trial[r] & 1)
	sign *= -1;
      
      trial[r]++;
      
      rr = r + 1;
      while (rr < dimension)
      {
	if (trial[rr] & 1)
	  sign *= -1;
	
	trial[rr++] = 0;
      }
      
      for (c = 0; c < dimension; c++)
	if (column[c] >= r)
	  column[c] = dimension;
    }
  }
  
  delete trial;
  delete column;
//  delete elementExpr;
  
  return determinant;
}

int main()
{
  int    i, j;
  int    d = 4;
  Matrix m(d);
  Expr   e = m.getDeterminantExpr();
  
  //  the next example shows that Real/Expr is overflow-free
  
  m.putElement(0, 0, 512); m.putElement(0, 1, 512); m.putElement(0, 2, 512); m.putElement(0, 3, 1);
  
  m.putElement(1, 0, 512); m.putElement(1, 1, -512); m.putElement(1, 2, -512); m.putElement(1, 3, 1);
  
  m.putElement(2, 0, -512); m.putElement(2, 1, 512); m.putElement(2, 2, -512); m.putElement(2, 3, 1);
  
  m.putElement(3, 0, -512); m.putElement(3, 1, -512); m.putElement(3, 2, 512); m.putElement(3, 3, 1);
  
  for (i = 0; i < d; i++)
  {
    for (j = 0; j < d; j++)
      cout << m.getElement(i, j) << " ";
    
    cout << endl;
  }
  
  cout << " e : " << e << endl;
  
  //  the example shows that Real/Expr ensures EXACTNESS
  
  m.putElement(0, 0, 60003); m.putElement(0, 1, 0); m.putElement(0, 2, 0); m.putElement(0, 3, 1);
  
  m.putElement(1, 0, 0); m.putElement(1, 1, 60003); m.putElement(1, 2, 0); m.putElement(1, 3, 1);
  
  m.putElement(2, 0, 0); m.putElement(2, 1, 0); m.putElement(2, 2, 60003); m.putElement(2, 3, 1);
  
  m.putElement(3, 0, 20001); m.putElement(3, 1, 20001); m.putElement(3, 2, 20001); m.putElement(3, 3, 1);
  
  for (i = 0; i < d; i++)
  {
    for (j = 0; j < d; j++)
      cout << m.getElement(i, j) << " ";
    
    cout << endl;
  }
  
  cout << " e : " << e << endl;
  
  if (e > 0) cout << " positive " << endl;
  else if (e == 0) cout << " zero " << endl;
  else cout << " negative " << endl;
  
  return 0;
}

