//
//  Real/Expr Package Ver. 1.0
//    Copywrite (c) 1995, 1996 Exact Computation Project
//    written by Koji Ouchi (ouchi@simulation.nyu.edu)
//
//  File: extLong.h
//    class extLong
//

#ifndef _extLong_H
#define _extLong_H

#include <iostream.h>
#include "Defs.h"

extern long inftyLong;
extern long tinyLong;

//  class extLong
//    extened long integer

class extLong
{
protected:
  
  long val;
  int  isOverFlow;
  
  //  comparison
  
  int compare(const extLong&) const;
  
public:
  
  //  constructors
  
  extLong();
  extLong(int);
  extLong(long);
  extLong(unsigned long);
  
  extLong(const extLong&);
  
  //  the destructor
  
  virtual ~extLong();
  
  //  assigment operator
  
  extLong operator =(const extLong&);
  
  //  comparison operators
  
  int operator ==(const extLong&) const;
  friend int operator ==(long, const extLong&);
  
  int operator !=(const extLong&) const;
  friend int operator !=(long, const extLong&);
  
  int operator <(const extLong&) const;
  friend int operator <(long, const extLong&);
  
  int operator <=(const extLong&) const;
  friend int operator <=(long, const extLong&);
  
  int operator >(const extLong&) const;
  friend int operator >(long, const extLong&);
  
  int operator >=(const extLong&) const;
  friend int operator >=(long, const extLong&);
  
  //  arithmetic operators
  
  extLong operator +(const extLong&) const;
  friend extLong operator +(long, const extLong&);
  
  extLong operator -(const extLong&) const;
  friend extLong operator -(long, const extLong&);
  
  //  arithmetic and assignment operators
  
  extLong operator +=(const extLong&);
  
  extLong operator -=(const extLong&);
  
  //  unary minus
  
  extLong operator -() const;
  
  //  builtin functions
  
  long asLong() const;
  int  isInfty() const;
  int  isTiny() const;
  
  //  stream operators
  
  ostream& operator <<(ostream&) const;
  friend ostream& operator <<(ostream&, const extLong&);
};

//  class extULong

class extULong : public extLong
{
public:
  
  //  constructors
  
  extULong();
  extULong(int);
  extULong(long);
  extULong(unsigned long);
  
  extULong(const extLong&);
  
  //  assignment operator
  
  extULong operator =(const extLong&);
};

#endif

