function result = funeps(f,df,B,epsilon)
%Computes a superset of the interval f(B) with at most epsilon Hausdorff distance
%scalar function f, gradient df, box B, epsilon > 0
%assumes that both f and df are bounded within B

%Work on a regular box copy of B
B0 = box(B.boxdimensions,B.length0);

result = interval(0);

Q = B0;
while ~isempty(Q) %&&
    B = Q(1);
    Q(1) = [];
    m = B.center;
    r = B.radius;
    %Compute a Lipschitz constant of f within B
    dfB0 = df(B0);
    L = norm(dfB0);
    %Check if the approximation is good enough
    if L*r < epsilon %Instead it would also be possible to compute f(B) and compare with f(m)
        fm = f(m);
        fB = interval(fm-L*r,fm+L*r);
        result = result.cup(fB);
    else
        [children,~] = B.split;
        Q = [Q,children]; %#ok<AGROW> 
    end
end
end