function [cycle,foundcycle] = findcycle(G)
    if nargin < 1
        s = [1 1 2 3 3 4 4 6 6 7 8 7 5];
        t = [2 3 4 4 5 5 6 1 8 1 3 2 8];
        G = digraph(s,t);
        plot(G);
        hold on;
    end
    %We use node 1 or any of its neighbors as start vertex

    edges = table2array(G.Edges);
    n = size(G.Nodes,1);
    neighbors = (edges(:,1) == 1) | (edges(:,2) == 1); %any(edges == 1,2);
    neighbors = unique(edges(neighbors,:));
    foundcycle = false;
    cycle = [];
    i = 1;
    while ~foundcycle && i <= length(neighbors)
        s = neighbors(i);
        [~,D] = shortestpathtree(G,'all',s);
        maxdist = max(D(~isinf(D)));
        
        farthestnodesbool = D >= maxdist-2 & ~isinf(D) & D>1;
        farthestnodes = 1:n;
        farthestnodes = farthestnodes(farthestnodesbool);
        j = 1;
        while maxdist < inf && ~foundcycle && j <= length(farthestnodes)
            if findedge(G,farthestnodes(j),s) || findedge(G,s,farthestnodes(j))
                foundcycle = true;
                t = farthestnodes(j);
                TR = shortestpathtree(G,t,s,'OutputForm','cell');
                cycle = [TR{1},t];
            end
            j = j+1;
        end
        i = i+1;
    end
end