/**
 * Test program #11: Using objects
 *  
 * @author:      Joanna Klukowska
 * @since:       Nov. 4, 2013
 * 
 * Objects that need to draw themselves on the canvas, 
 * need to be given direct access to the canvas. The Disk class
 * has its own data field of type PApplet that is initialized to 
 * the canvas used by the current application in the constructor
 * call. This way each disk object can draw itself onto the common
 * canvas.  
 * 
 *  For more details see http://processing.org/reference/ 
 */
package lecture11_processing;

import processing.core.PApplet;

public class ProcessingExample11 extends PApplet 
{	
	//dimensions of the canvas
		int xMax = 600;
		int yMax = 400;
		Disk [] myDisks = new Disk[15];
		
		
		int counter;
		
		public void setup() 
		{
			size(xMax,yMax);
			
			//create all the disks once
			for (int i = 0; i < myDisks.length; i++)
				myDisks[i] = new Disk(this);
						
		}
		
		public void draw()
		{

			background (188, 188, 188);
			//let the disks move according to their own rules
			for (int i = 0; i < myDisks.length; i++)
				myDisks[i].move();
		}
		
}