module memory/checkFixedSize [Addr, Data]

open memory/fixedSizeMemory_H [Addr, Data] as fmemory
open memory/abstractMemory [Addr, Data] as amemory

// define abstraction function from history-extended concrete state 
// to abstract state
pred alpha [fm: FixMemory_H, am: AbsMemory] {
	am.data = fm.data - (fm.unwritten -> Data)
	}

// This check should not find a counterexample
initOk: check {
	all fm: FixMemory_H, am: AbsMemory |
		fmemory/init [fm] and alpha [fm, am] => amemory/init [am]
	}

// This check should not find a counterexample
readOk: check {
	all fm: FixMemory_H, a: Addr, d: Data, am: AbsMemory |
		fmemory/read [fm, a, d] and alpha [fm, am] => 
			amemory/read [am, a, d]
	}

// This check should not find a counterexample
writeOk: check {
	all fm, fm': FixMemory_H, a: Addr, d: Data, am, am': AbsMemory |
		fmemory/write [fm, fm', a, d] 
		and alpha [fm, am] and alpha [fm', am'] =>
 			amemory/write [am, am', a, d]
	}
