public class LockTest2 {
  volatile static int counter;
  static Lock mutex;
  
  public static class Counter implements Runnable {
    private int id;
    Counter(int id) {
      this.id = id;
    }
    
    public void run() {
      for (int n = 0; n < 1000000; n++) {
        try {
          mutex.lock(id);
          counter++;
        } finally { mutex.unlock(id); }
      }
      System.out.flush();
    }
  }

  public static void usage() {
    System.out.println("Usage: java LockTest2 <number of threads>");
  }

  public static void main(String[] args) throws InterruptedException {
    if (args.length == 0) {
      usage();
      return;
    }

    int n;
    try {
      n = Integer.parseInt(args[0]);
    } catch (NumberFormatException e) {
      usage();
      return;
    }

    mutex = new FilterLock(n);
    Thread[] thread = new Thread[n];

    for (int i = 0; i < n; i++) {
      thread[i] = new Thread(new Counter(i));
    }

    counter = 0;

    for (Thread t : thread) { t.start(); }
    
    for (Thread t : thread) { t.join(); }
    
    System.out.println("The final value of 'counter' is: " + counter);
  }
  

}