/*
 * Object-Oriented Programming
 * Copyright (C) 2012 Robert Grimm
 * Modifications copyright (C) 2013 Thomas Wies
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301,
 * USA.
 */

#include <stdint.h>
#include <iostream>

class Shape {
public:
  virtual ~Shape() {}
};

class Circle : public Shape {
};

class Rectangle : public Shape {
};

class Window {
};

using namespace std;

int main() {
  // Implicit upcast. Always safe,
  // but may be problematic due to non-virtual methods.
  Shape* s = new Circle();
  cout << s << endl;

  // Static downcast. Not safe.
  Circle* c1 = static_cast<Circle*>(s);
  cout << c1 << endl;

  // Static downcast. Not safe and incorrect.
  Rectangle* r1 = static_cast<Rectangle*>(s);
  cout << r1 << endl;

  // Doesn't work, unrelated classes.
  // Window* w1 = static_cast<Window*>(s);

  // Treat something as const. Always safe,
  // but object may still change through c1.
  const Circle* c2 = c1;
  cout << c2 << endl;

  // Cast const-ness away again. Dangerous.
  Circle* c3 = const_cast<Circle*>(c2);
  cout << c3 << endl;

  // Treat bits completely differently. Pretty bad.
  intptr_t i = reinterpret_cast<intptr_t>(c3);
  cout << i << endl;

  // Treat bits completely differently. Super bad.
  Window* w1 = reinterpret_cast<Window*>(c3);
  cout << w1 << endl;

  // Dynamic downcast. Guaranteed to be safe.
  Circle* c4 = dynamic_cast<Circle*>(s);
  cout << c4 << endl;

  // Dynamic downcast. Guaranteed to be safe.
  Rectangle* r2 = dynamic_cast<Rectangle*>(s);
  cout << r2 << endl;

  // Dynamic downcast. Guaranteed to be safe.
  Rectangle& r3 = dynamic_cast<Rectangle&>(*s);
  cout << &r3 << endl;

  delete s;

  return 0;
}
