/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar;

import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinVar;
import java.math.BigInteger;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinTerm {
    Map<LinVar, BigInteger> mCoeffs;

    LinTerm(Map<LinVar, BigInteger> coeffmap) {
        this.mCoeffs = coeffmap;
    }

    public String toString() {
        if (this.mCoeffs.isEmpty()) {
            return "0";
        }
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (Map.Entry<LinVar, BigInteger> entry : this.mCoeffs.entrySet()) {
            LinVar var = entry.getKey();
            BigInteger fact = entry.getValue();
            if (fact.signum() == -1) {
                sb.append(isFirst ? "-" : " - ");
            } else {
                sb.append(isFirst ? "" : " + ");
            }
            fact = fact.abs();
            if (!fact.equals(BigInteger.ONE)) {
                sb.append(fact).append('*');
            }
            sb.append(var);
            isFirst = false;
        }
        return sb.toString();
    }

    public int hashCode() {
        return this.mCoeffs.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof LinTerm) {
            return this.mCoeffs.equals(((LinTerm)o).mCoeffs);
        }
        return false;
    }
}

