/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.model;

import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.IRAConstantFormatter;
import de.uni_freiburg.informatik.ultimate.logic.PrintTerm;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.FunctionValue;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.Model;
import de.uni_freiburg.informatik.ultimate.smtinterpol.model.SortInterpretation;
import java.util.Map;

public class ModelFormatter {
    private final String mLineSep = System.getProperty("line.separator");
    private final StringBuilder mString = new StringBuilder("(model ");
    private int mIndent = 0;
    private final Theory mTheory;
    private final Model mModel;
    private final IRAConstantFormatter mFormatter;

    private void newline() {
        this.mString.append(this.mLineSep);
        for (int i = 0; i < this.mIndent; ++i) {
            this.mString.append(' ');
        }
    }

    public ModelFormatter(Theory t, Model model) {
        this.mTheory = t;
        this.mModel = model;
        this.mFormatter = t.getLogic().isIRA() ? new IRAConstantFormatter() : null;
    }

    public void appendComment(String comment) {
        this.mIndent += 2;
        this.newline();
        this.mString.append(";; ").append(comment);
        this.mIndent -= 2;
    }

    public void appendSortInterpretation(SortInterpretation si, Sort sort) {
        Term t = si.toSMTLIB(this.mTheory, sort);
        if (t != null) {
            this.mIndent += 2;
            this.newline();
            this.mString.append(t);
            this.mIndent -= 2;
        }
    }

    public void appendValue(FunctionSymbol f, FunctionValue value, Theory t) {
        int i;
        this.mIndent += 2;
        this.newline();
        Sort[] paramSorts = f.getParameterSorts();
        TermVariable[] vars = new TermVariable[paramSorts.length];
        for (i = 0; i < vars.length; ++i) {
            vars[i] = t.createTermVariable("@p" + i, paramSorts[i]);
        }
        this.mString.append("(define-fun ").append(PrintTerm.quoteIdentifier(f.getName())).append(" (");
        for (i = 0; i < vars.length; ++i) {
            this.mString.append('(').append(vars[i]).append(' ').append(paramSorts[i]).append(')');
        }
        this.mString.append(") ").append(f.getReturnSort());
        this.mIndent += 2;
        this.appendFunctionValue(value, vars, f.getReturnSort());
        this.mString.append(')');
        this.mIndent -= 2;
        this.mIndent -= 2;
    }

    private Term index2Term(FunctionValue.Index index, TermVariable[] vars) {
        int[] idx = index.getArray();
        assert (vars.length == idx.length);
        Term[] conj = new Term[vars.length];
        for (int i = 0; i < vars.length; ++i) {
            conj[i] = this.mTheory.equals(vars[i], this.mModel.toModelTerm(idx[i], vars[i].getSort()));
        }
        return this.mTheory.and(conj);
    }

    private void appendFunctionValue(FunctionValue value, TermVariable[] vars, Sort resultSort) {
        if (vars.length == 0) {
            this.newline();
            this.mString.append(this.format(this.mModel.toModelTerm(value.getDefault(), resultSort)).toStringDirect());
        } else {
            int defaultVal = value.getDefault();
            int closing = 0;
            for (Map.Entry<FunctionValue.Index, Integer> me : value.values().entrySet()) {
                if (me.getValue() == defaultVal) continue;
                this.newline();
                this.mString.append("(ite ").append(this.format(this.index2Term(me.getKey(), vars)).toStringDirect()).append(' ').append(this.format(this.mModel.toModelTerm(me.getValue(), resultSort)).toStringDirect());
                ++closing;
            }
            this.mIndent += 2;
            this.newline();
            this.mString.append(this.format(this.mModel.toModelTerm(defaultVal, resultSort)).toStringDirect());
            for (int i = 0; i < closing; ++i) {
                this.mString.append(')');
            }
            this.mIndent -= 2;
        }
    }

    private Term format(Term input) {
        return this.mFormatter == null ? input : this.mFormatter.transform(input);
    }

    public String finish() {
        return this.mString.append(')').toString();
    }
}

