/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.model;

import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import java.math.BigDecimal;
import java.math.BigInteger;

public class ConstantTermNormalizer
extends TermTransformer {
    protected void convert(Term term) {
        if (term instanceof ConstantTerm) {
            ConstantTerm ct = (ConstantTerm)term;
            if (ct.getValue() instanceof BigInteger) {
                Rational rat = Rational.valueOf((BigInteger)ct.getValue(), BigInteger.ONE);
                this.setResult(rat.toTerm(term.getSort()));
            } else if (ct.getValue() instanceof BigDecimal) {
                Rational rat;
                BigDecimal decimal = (BigDecimal)ct.getValue();
                if (decimal.scale() <= 0) {
                    BigInteger num = decimal.toBigInteger();
                    rat = Rational.valueOf(num, BigInteger.ONE);
                } else {
                    BigInteger num = decimal.unscaledValue();
                    BigInteger denom = BigInteger.TEN.pow(decimal.scale());
                    rat = Rational.valueOf(num, denom);
                }
                this.setResult(rat.toTerm(term.getSort()));
            } else if (ct.getValue() instanceof Rational) {
                this.setResult(ct);
            } else {
                this.setResult(term);
            }
        } else {
            super.convert(term);
        }
    }
}

