function A = makeA(AA,blk,spblocks)
% MAKEA  given a cell array AA of nxn matrices A1,...,Am, with block
%        structure blk, construct a matrix A of size m by n(n+1)/2
%        whose rows are the vector representations of the Ak's;
%
% A = makeA(AA,blk,spblocks)     (spblocks is optional)
%
% input variables:
%    - AA         the cell array of the Ak's
%    - blk        block structure vector
%    - spblocks   flag: 0 ==> the matrix A will be full (default)
%                       1 ==> the matrix A will be sparse
%
% output variables:
%    - A          the matrix of constraints in vector representation

% SDPPACK Version 0.9 BETA
% Copyright (c) 1997 by
% F. Alizadeh, J.-P. Haeberly, M. Nayakkankuppam, M.L. Overton, S. Schmieta
% Last modified: 5/24/97
%
 sumblk2 = sum(blk .* (1+blk))/2;
 m = length(AA);
 if nargin < 3
    spblocks = 0;
 end
 if spblocks
    A = sparse(m,sumblk2);
 else
    A = zeros(m,sumblk2);
 end
 for k = 1:m
    if AA{k} ~= AA{k}',
       fprintf('%3.0d - th component matrix not symmetric:  symmetrized\n');
       AA{k} = 0.5*(AA{k} + AA{k}');
    end;
    A(k,:) = svec(AA{k},blk)';
 end
