function xstep = lpbound(x,dx);
% LPBOUND   computes the stepsize from the vector x to the boundary
%           of the positive orthant in the direction dx
%
% xstep = lpbound(x,dx)
%
% input variables:
%     - x         vector in the positive orthant
%     - dx        direction
%
% output variables:
%     - xstep     stepsize to the boundary of the positive orthant

% SDPPACK Version 0.9 BETA
% Copyright (c) 1997 by
% F. Alizadeh, J.-P. Haeberly, M. Nayakkankuppam, M.L. Overton, S. Schmieta
% Last modified: 4/21/97
%
 ratio = dx ./ x;
 t = max(-ratio);
 if t <= 0.0,
    xstep = Inf;
 else
    xstep = 1/t;
 end;
%
% END function

