import time, sys

# Sink is just that - a sink for the C++ parser to dump parsed RCS data into.
# When tparser finds various RCS structures, it calls the methods in an
# instance of the Sink class. Here, we just print the data out. Later we can do
# more interesting stuff.

class Sink:
    def __init__(self, cursor):
        # cursor is just MySQLdb.connect('localhost','root','').cursor()
        self.cursor = cursor
        self.file = ''

    # These are no-ops that must exist. The C++ module calls them even though
    # they do nothing. If we decide to use the info later we can.
    def set_head_revision(self, revision):
        pass

    def set_principal_branch(self, branch_name):
        pass

    def define_tag(self, name, revision):
        pass

    def set_access(self, accessors):
        pass

    def set_expansion(self, mode):
        pass

    def set_locking(self, mode):
        pass

    def set_locker(self, revision, locker):
        pass

    def set_comment(self, comment):
        pass

    def set_description(self, description):
        pass

    def define_revision(self, revision, timestamp, author, state,
                      branches, next):

        # This gets called a bunch of times before the revision_info stuff gets
        # called. So, we insert an incomplete row. Later when we get the other
        # info, we insert that too.

        # Also, at this time we're going to ignore the everything except
        # (revision, timestamp, author)

        if self.path.endswith('Attic'):
            path = self.path[:-len('Attic')-1]
        else:
            path = self.path

        # 5 seconds is an arbitrary value that seems to give good results.
        # if we do a case sensitive match, things don't always work nice.
        sql = """
        SELECT tid
        FROM transactions
        WHERE -- date     < (FROM_UNIXTIME(%(date)s+5)) AND 
              -- date     > (FROM_UNIXTIME(%(date)s-5)) AND 
              type IN ('M', 'A', 'R', 'I') AND
              login    = %(author)s AND
              file     = %(file)s AND
              path     = %(path)s AND
              revision = %(revision)s""" 
        mapping = {'revision'  : revision,
                   'date'      : timestamp,
                   'author'    : author,
                   'path'      : path,
                   'file'      : self.file}

        self.cursor.execute(sql, mapping)

        # this should always match. if not, we want to see the exception
        all = self.cursor.fetchall()
        try:
            tid = all[0][0]
        except IndexError:

            # Ok, if it doesn't exist in the transactions table, then it must
            # be from an import. We need to build the transaction here.

            # Unless it's 1.1.1.1.
            if revision == '1.1.1.1':
                return
            sql = """
            INSERT INTO transactions
            SET login    = %(author)s,
                file     = %(file)s,
                path     = %(path)s,
                revision = %(revision)s,
                date     = FROM_UNIXTIME(%(date)s),
                type     = 'I' -- We know it's an add because it came from an import""" 
            self.cursor.execute(sql, mapping)
            # This is just dirty. Oh well.
            self.define_revision(revision, timestamp, author, state,
                                 branches, next)
            return

        # Update the revisions table
        sql = """
        INSERT INTO revisions
        SET tid = %s""" 
        self.cursor.execute(sql, (tid,))

    # These happen after the define_revision step. Not immediately after, but
    # waaay afte all the revisions have been defined.
    def set_revision_info(self, revision, log, text):

        # We bail if it's 1.1.1.1 --- this is a throwback to RCS. The revision
        # will already be recorded as 1.1 elsewhere.
        if revision == '1.1.1.1':
            return

        sql = """
        SELECT tid
        FROM transactions
        WHERE type IN ('M', 'A', 'R', 'I') AND
              file     = %(file)s AND
              revision = %(revision)s""" 
        mapping = {'revision'  : revision,
                   'file'      : self.file}
        self.cursor.execute(sql, mapping)

        # it's possible to not have a match here. If not, then it's for an
        # instructor or somesuch. hence, we bail.
        try:
            tid = self.cursor.fetchall()[0][0]
        except IndexError:
            print 'Trouble finding:', mapping
            raise

        # Yes, this is a hack, but it stops mysql from complaining. Basicaly I
        # have the comment field as a varchar(255), and if log is > 255 chars,
        # then mysql pukes. So, I trim it.
        if len(log) > 255:
            log = log[:255]

        sql = """
            UPDATE revisions
            SET comment = %(log)s
            WHERE tid = %(tid)s""" 
        mapping = {'log'  : log,
                   'tid'  : tid}

        self.cursor.execute(sql, mapping)

    def admin_completed(self):
        pass

    def tree_completed(self):
        pass

    def parse_completed(self):
        pass

# Exceptions used by tparse. If these are not defined, tparse will segfault
# Python. Currently they don't do much.
class RCSParseError(Exception):
    pass

class RCSIllegalCharacter(RCSParseError):
    pass

class RCSExpected(RCSParseError):
    def __init__(self, got, wanted):
        RCSParseError.__init__(self, got, wanted)

class RCSStopParser(Exception):
    pass

