import os, os.path, glob, sets, re
import tparse, common, Slurp

class Slurp:
    def __init__(self, sink, repo):
        self.sink = sink
        self.repo = repo

        sink.slurp = self
        sink.invalid = 0
        sink.invalid_mappings = []
        sink.invalid_multiple = 0
        sink.invalid_multiple_mappings = []

    def parse_history(self):
        os.chdir(self.repo)
        history = open("CVSROOT/history",'U').readlines()
        for line in history:
            type = line[0]
            line = line[1:-1]
            date, user, curdir, special, rev, file = line.split('|')
            
            # FIXME beware GMT issues
            date = int(date, 16)

            sql = """
            INSERT INTO transactions
            SET revision = %(rev)s,
                login    = %(login)s,
                date     = FROM_UNIXTIME(%(date)s),
                file     = %(file)s,
                path     = %(path)s,
                curdir   = %(curdir)s,
                type     = %(type)s"""
            mapping = dict(rev=rev, login=user, date=date, file=file,
                           path=special, curdir=curdir, type=type)
            self.sink.cursor.execute(sql, mapping)
    
    # Parse the contents of the repository
    def parse_revisions(self):
        # Hack so that the sink can get access to our variables.
        self.sink.slurp = self
        os.chdir(self.repo)
        os.path.walk(".", self.visit, None)

    # This function gets called for every directory inside a students repository.
    # It's passed the directory in question, and a list of all the files in said
    # directory.
    def visit(self, ignored, dirname, names):

        # We do want the path inside the repository
        self.sink.path = dirname[2:]

        for f in names:
            if f[-2:] != ',v' or f.startswith('CVSROOT'):
                # Not an RCS file, or part of CVS admin files
                continue

            # We don't want the trailing ',v'
            self.sink.file = f[:-2]

            # Pay a visit to our favorite C++ RCS parser. FIXME use os.path.join
            tparse.parse(dirname + '/' + f, self.sink)
