CREATE TABLE transactions (
	-- we can uniquely match CVSROOT/history to the ,v revisions by
	-- (login,date,file,revision)
	tid int NOT NULL AUTO_INCREMENT,
	revision varchar(55),
	login varchar(55) NOT NULL DEFAULT '',
	date datetime NOT NULL DEFAULT '0000-00-00',
	-- file is located in:
	-- <repos>/<login>/<path>/<file>,v
	-- We do not store the ,v, just the original filename.
	-- This is basically the same as 'argument'
	-- argument: The module (for [TOEF]) or file (for [WUPGCMAR]) affected.
	-- see the cvs sourcecode history.c for more details
	file varchar(100) NOT NULL DEFAULT '',
	path varchar(100),
	curdir varchar(255) NOT NULL DEFAULT '',
	type enum('T', 'O', 'E', 'F', 'W', 'U',
		  'P', 'G', 'C', 'M', 'A', 'R', 'I') NOT NULL,
	-- 'I' is for Import. Not officially in the CVS history; we fake having the
	-- info.

	PRIMARY KEY (tid),
	INDEX date (date),
	INDEX login (login),
	INDEX curdir (curdir),
);

CREATE TABLE revisions (
	tid int NOT NULL,
	aid int DEFAULT NULL,
	commit_id int,
	comment varchar(255) NOT NULL DEFAULT '',

	PRIMARY KEY (tid),
	INDEX comment (comment)
);

-- This table is computed from the revisions table. it is just groupings of
-- revisions into larger commits.
CREATE TABLE commits (
	commit_id int NOT NULL,

	PRIMARY KEY (commit_id)
);
