/*
 * Decompiled with CFR 0.152.
 */
package Jet.Zoner;

import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import Jet.Tipster.DocumentCollection;
import Jet.Tipster.ExternalDocument;
import Jet.Tipster.Span;
import java.util.Vector;

public class SpeechSplitter {
    static final double SENTENCE_GAP = 0.25;
    static boolean trace = true;
    static final String ACEdir = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/";
    static final String collectionFile = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/asr pilot sgm.txt";

    public static void split(Document document, Span span) {
        int n = span.start();
        int n2 = span.end();
        double d = -1.0;
        Vector vector = document.annotationsOfType("W");
        for (int i = 0; i < vector.size(); ++i) {
            double d2;
            double d3;
            Annotation annotation = (Annotation)vector.get(i);
            String string = (String)annotation.get("Bsec");
            String string2 = (String)annotation.get("Dur");
            try {
                d3 = Double.parseDouble(string);
                d2 = Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("Speech splitter:  ill-formed W annotation " + annotation);
                return;
            }
            if (d >= 0.0 && d3 > d + 0.25) {
                int n3 = annotation.start();
                Span span2 = new Span(n, n3);
                document.annotate("sentence", span2, null);
                if (trace) {
                    System.out.println("Sentence: " + document.text(span2).replace('\n', ' '));
                }
                n = n3;
            }
            d = d3 + d2;
        }
        if (d >= 0.0) {
            Span span3 = new Span(n, n2);
            document.annotate("sentence", span3, null);
            if (trace) {
                System.out.println("Sentence: " + document.text(span3).replace('\n', ' '));
            }
        }
    }

    public static void main(String[] stringArray) {
        DocumentCollection documentCollection = new DocumentCollection(collectionFile);
        documentCollection.open();
        for (int i = 0; i < documentCollection.size(); ++i) {
            ExternalDocument externalDocument = documentCollection.get(i);
            System.out.println("Processing document " + externalDocument.fileName());
            externalDocument.setAllTags(true);
            externalDocument.setEmptyTags(new String[]{"W"});
            externalDocument.open();
            externalDocument.annotateWithTag("text");
            Span span = ((Annotation)externalDocument.annotationsOfType("TEXT").get(0)).span();
            SpeechSplitter.split(externalDocument, span);
        }
    }
}

