/*
 * Decompiled with CFR 0.152.
 */
package Jet.Parser;

import AceJet.Ace;
import Jet.Chunk.Chunker;
import Jet.Control;
import Jet.HMM.BigramHMMemitter;
import Jet.HMM.HMMstate;
import Jet.HMM.Retagger;
import Jet.JetTest;
import Jet.Lex.Tokenizer;
import Jet.Lisp.FeatureSet;
import Jet.Parser.ParseTreeNode;
import Jet.Pat.Pat;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import Jet.Tipster.DocumentCollection;
import Jet.Tipster.ExternalDocument;
import Jet.Tipster.Span;
import danbikel.lisp.Sexp;
import danbikel.lisp.SexpList;
import danbikel.lisp.Symbol;
import danbikel.parser.Parser;
import danbikel.parser.Settings;
import danbikel.parser.english.HeadFinder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;

public class StatParser {
    static int nextToken = 0;
    static ArrayList words;
    static ArrayList spans;
    static ArrayList wordDefns;
    static ArrayList pennPOS;
    static Parser parser;
    static boolean initialized;
    static final boolean findHeads = true;
    static HeadFinder headFinder;

    public static void main(String[] stringArray) throws IOException {
        String string = "C:/Documents and Settings/Ralph Grishman/My Documents/";
        String string2 = string + "ACE/";
        String string3 = string2 + "eval04 bnews sgm.txt";
        String string4 = string2 + "parses/eval04 bnews parses.txt";
        JetTest.initializeFromConfig("props/ace just parser.properties");
        Document document = new Document("<TEXT>According to Al Gore ( the former vice president ) asbestos kills people. </TEXT>");
        Control.processDocument(document, null, false, 1);
        document.setSGMLindent(4);
        StringBuffer stringBuffer = document.writeSGML("constit");
        System.out.println("\n" + stringBuffer);
    }

    public static void initialize(String string, Properties properties) {
        String string2 = properties.getProperty("StatParser.properties.fileName");
        String string3 = properties.getProperty("StatParser.grammar.fileName");
        if (string2 == null && string3 == null) {
            return;
        }
        if (string2 == null || string3 == null) {
            System.err.println("Error in properties file:  for StatParser, both");
            System.err.println("properties.Filename and grammar.fileName must be specified");
            return;
        }
        StatParser.initialize(string + File.separatorChar + string2, string + File.separatorChar + string3);
    }

    public static void initialize(String string, String string2) {
        try {
            Settings.load((String)string);
            parser = new Parser(string2);
            initialized = true;
        }
        catch (Exception exception) {
            System.out.println(exception);
            System.out.println("Unable to initialize parser.");
        }
    }

    public static boolean isInitialized() {
        return initialized;
    }

    public static ParseTreeNode parse(Document document, Span span) {
        SexpList sexpList;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        JetTest.tagger.annotate(document, span, "tagger");
        int n = span.start();
        int n2 = span.end();
        StatParser.buildParserInput(document, n, n2);
        StatParser.fixHyphenatedItems(document);
        if (wordDefns.size() == 0) {
            System.out.println("StatParse:  no tokens in span");
            return null;
        }
        SexpList sexpList2 = new SexpList();
        for (int i = 0; i < words.size(); ++i) {
            object4 = (String)words.get(i);
            object3 = (String)pennPOS.get(i);
            object2 = new SexpList();
            object2.add((Sexp)Symbol.get((String)object3));
            object = new SexpList();
            object.add((Sexp)Symbol.get((String)object4));
            object.add((Sexp)object2);
            sexpList2.add((Sexp)object);
        }
        System.out.println("Sentence = " + sexpList2.toString());
        try {
            sexpList = (SexpList)parser.parse(sexpList2);
        }
        catch (Exception exception) {
            System.out.println(exception);
            System.out.println("No parse possible.");
            return null;
        }
        if (sexpList == null) {
            System.out.println("No parse possible.");
            return null;
        }
        System.out.println("Parse = " + sexpList);
        if (headFinder == null) {
            try {
                headFinder = new HeadFinder();
            }
            catch (IOException iOException) {
                System.out.println("StatParser: " + iOException);
                System.out.println("Unable to generate heads.");
            }
        }
        nextToken = 0;
        object4 = StatParser.makeParseTree(document, (Sexp)sexpList);
        object3 = ParseTreeNode.makeParseAnnotations(document, (ParseTreeNode)object4);
        StatParser.deleteUnusedConstits(document, span, (Annotation)object3);
        object2 = document.annotationsAt(n, "sentence");
        if (object2 != null && ((Vector)object2).size() > 0) {
            object = (Annotation)((Vector)object2).get(0);
            ((Annotation)object).put("parse", object3);
        }
        return object4;
    }

    private static void deleteUnusedConstits(Document document, Span span, Annotation annotation) {
        Set set = StatParser.descendants(annotation);
        Vector vector = document.annotationsOfType("constit", span);
        for (int i = 0; i < vector.size(); ++i) {
            Annotation annotation2 = (Annotation)vector.get(i);
            if (set.contains(annotation2)) continue;
            document.removeAnnotation(annotation2);
        }
    }

    private static void buildParserInput(Document document, int n, int n2) {
        wordDefns = new ArrayList();
        pennPOS = new ArrayList();
        words = new ArrayList();
        spans = new ArrayList();
        int n3 = Tokenizer.skipWSX(document, n, n2);
        while (n3 < n2) {
            Object object;
            Object object2;
            Vector vector = document.annotationsAt(n3, "constit");
            Annotation annotation = null;
            String string = null;
            if (vector != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    object2 = (Annotation)vector.get(i);
                    if (((Annotation)object2).get("hidden") != null) continue;
                    annotation = object2;
                    string = (String)annotation.get("cat");
                    break;
                }
            }
            wordDefns.add(annotation);
            String string2 = StatParser.ptbPOS(document, n3, annotation, string);
            pennPOS.add(string2);
            if (annotation != null) {
                object2 = annotation.span();
            } else {
                object = document.tokenAt(n3);
                if (object == null) break;
                object2 = ((Annotation)object).span();
            }
            spans.add(object2);
            object = document.text((Span)object2).trim();
            if (((String)object).equals("_")) {
                object = "--";
            } else if (((String)object).equals("(")) {
                object = "-LRB-";
            } else if (((String)object).equals(")")) {
                object = "-RRB-";
            }
            words.add(object);
            n3 = ((Span)object2).end();
        }
    }

    private static String ptbPOS(Document document, int n, Annotation annotation, String string) {
        String string2;
        if (string == "name") {
            return "NNP";
        }
        Vector vector = document.annotationsAt(n, "tagger");
        Annotation annotation2 = (Annotation)vector.get(0);
        String string3 = (String)annotation2.get("cat");
        String string4 = document.text(annotation2).trim().toLowerCase();
        Vector vector2 = document.annotationsAt(n, "constit");
        if (vector2 == null || vector2.size() == 0) {
            return string3;
        }
        for (int i = 0; i < vector2.size(); ++i) {
            Annotation annotation3 = (Annotation)vector2.get(i);
            if (!annotation2.span().equals(annotation3.span())) continue;
            FeatureSet[] featureSetArray = Retagger.ptbToJetFS(string4, string3);
            for (int j = 0; j < featureSetArray.length; ++j) {
                if (!featureSetArray[j].subsetOf(annotation3.attributes())) continue;
                return string3;
            }
        }
        if (annotation != null && (string2 = Retagger.jetToPtbPos(annotation.attributes())) != null) {
            return string2;
        }
        return string3;
    }

    private static void fixHyphenatedItems(Document document) {
        for (int i = 1; i < words.size() - 1; ++i) {
            if (!words.get(i).equals("-") || ((Span)spans.get(i - 1)).end() != ((Span)spans.get(i)).start() || ((Span)spans.get(i)).end() != ((Span)spans.get(i + 1)).start()) continue;
            Annotation annotation = new Annotation("constit", (Span)spans.get(i), new FeatureSet("cat", "-"));
            document.addAnnotation(annotation);
            wordDefns.set(i, annotation);
            Span span = new Span(((Span)spans.get(i - 1)).start(), ((Span)spans.get(i + 1)).end());
            Annotation[] annotationArray = new Annotation[3];
            annotationArray[0] = (Annotation)wordDefns.get(i - 1);
            if (annotationArray[0] == null) {
                annotationArray[0] = new Annotation("constit", (Span)spans.get(i - 1), new FeatureSet("cat", "?"));
            }
            annotationArray[1] = (Annotation)wordDefns.get(i);
            annotationArray[2] = (Annotation)wordDefns.get(i + 1);
            if (annotationArray[2] == null) {
                annotationArray[2] = new Annotation("constit", (Span)spans.get(i + 1), new FeatureSet("cat", "?"));
            }
            Annotation annotation2 = new Annotation("constit", span, new FeatureSet("cat", "hyphword", "children", annotationArray));
            document.addAnnotation(annotation2);
            spans.set(i - 1, span);
            spans.remove(i + 1);
            spans.remove(i);
            words.set(i - 1, document.text(span).trim());
            words.remove(i + 1);
            words.remove(i);
            pennPOS.set(i - 1, "JJ");
            pennPOS.remove(i + 1);
            pennPOS.remove(i);
            wordDefns.set(i - 1, annotation2);
            wordDefns.remove(i + 1);
            wordDefns.remove(i);
        }
    }

    private static ParseTreeNode makeParseTree(Document document, Sexp sexp) {
        int n;
        if (!sexp.isList()) {
            System.out.println("StatParse:  invalid Sexp for parse node " + sexp.toString());
            return null;
        }
        SexpList sexpList = (SexpList)sexp;
        if (sexpList.length() < 2) {
            System.out.println("StatParse:  invalid Sexp for parse node " + sexpList.toString());
            return null;
        }
        Sexp sexp2 = sexpList.get(0);
        if (!sexp2.isSymbol()) {
            System.out.println("StatParse:  invalid Sexp for parse node " + sexpList.toString());
            return null;
        }
        String string = ((Symbol)sexp2).toString().intern();
        String string2 = string.toLowerCase().intern();
        Sexp sexp3 = sexpList.get(1);
        if (sexp3.isSymbol()) {
            String string3 = ((Symbol)sexp3).toString();
            String string4 = (String)words.get(nextToken);
            while (!string4.equals(string3)) {
                System.out.println("StatParser:  parse skips " + string4 + " in sentence.");
                if (++nextToken >= words.size()) {
                    System.out.println("*** Unable to align sentence and parse tree.");
                    return null;
                }
                string4 = (String)words.get(nextToken);
            }
            Annotation annotation = StatParser.buildWordDefn(document, nextToken, string);
            ++nextToken;
            return new ParseTreeNode(string2, null, annotation.start(), annotation.end(), annotation, string4);
        }
        int n2 = 0;
        n2 = headFinder.findHead(sexp);
        int n3 = sexpList.length() - 1;
        int n4 = nextToken;
        int n5 = ((Span)spans.get(n4)).start();
        ParseTreeNode[] parseTreeNodeArray = new ParseTreeNode[n3];
        for (n = 0; n < n3; ++n) {
            parseTreeNodeArray[n] = StatParser.makeParseTree(document, sexpList.get(n + 1));
        }
        n = n5;
        if (nextToken > n4) {
            n = ((Span)spans.get(nextToken - 1)).end();
        }
        return new ParseTreeNode(string2, parseTreeNodeArray, n5, n, n2);
    }

    private static Annotation buildWordDefn(Document document, int n, String string) {
        Object object;
        String string2;
        Annotation annotation = (Annotation)wordDefns.get(n);
        if (annotation != null && ((string2 = (String)annotation.get("cat")) == "name" || string2 == "hyphword")) {
            return annotation;
        }
        string2 = (String)words.get(n);
        Span span = (Span)spans.get(n);
        Vector vector = document.annotationsAt(span.start(), "constit");
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                object = (Annotation)vector.get(i);
                if (((Annotation)object).get("hidden") != null || !Retagger.compatible(string2, string, (Annotation)object)) continue;
                return object;
            }
        }
        if (string != "POS" && annotation != null) {
            return annotation;
        }
        FeatureSet[] featureSetArray = Retagger.ptbToJetFS(string2, string);
        if (featureSetArray.length > 0) {
            object = new FeatureSet(featureSetArray[0]);
            String string3 = (String)((FeatureSet)object).get("cat");
            if (string3 == "n" || string3 == "v" || string3 == "tv" || string3 == "ving" || string3 == "ven") {
                ((FeatureSet)object).put("pa", new FeatureSet("head", string2.toLowerCase().intern()));
            }
            annotation = new Annotation("constit", span, (FeatureSet)object);
            document.addAnnotation(annotation);
            return annotation;
        }
        annotation = new Annotation("constit", span, new FeatureSet("cat", string.toLowerCase().intern()));
        document.addAnnotation(annotation);
        return annotation;
    }

    public static Annotation[] children(Annotation annotation) {
        Object object = annotation.get("children");
        if (object == null) {
            return null;
        }
        if (!(object instanceof Annotation[])) {
            System.out.println("StatParser.children:  invalid children attribute:  " + annotation);
            return null;
        }
        return (Annotation[])object;
    }

    public static Set descendants(Annotation annotation) {
        HashSet<Annotation> hashSet = new HashSet<Annotation>();
        hashSet.add(annotation);
        Annotation[] annotationArray = StatParser.children(annotation);
        if (annotationArray != null) {
            for (int i = 0; i < annotationArray.length; ++i) {
                hashSet.addAll(StatParser.descendants(annotationArray[i]));
            }
        }
        return hashSet;
    }

    private static void parseCollection(String string, String string2) throws IOException {
        System.out.println("Starting ACE Jet...");
        JetTest.initializeFromConfig("props/ace just parser.properties");
        Chunker.loadModel();
        Pat.trace = false;
        DocumentCollection documentCollection = new DocumentCollection(string);
        documentCollection.open();
        for (int i = 0; i < documentCollection.size(); ++i) {
            ExternalDocument externalDocument = documentCollection.get(i);
            System.out.println("\nProcessing document " + i + ": " + externalDocument.fileName());
            externalDocument.setAllTags(true);
            externalDocument.open();
            Ace.monocase = Ace.allLowerCase(externalDocument);
            System.out.println(">>> Monocase is " + Ace.monocase);
            BigramHMMemitter.useBigrams = Ace.monocase;
            HMMstate.otherPreference = Ace.monocase ? 1.0 : 0.0;
            Control.processDocument(externalDocument, null, i == -1, i);
            externalDocument.removeAnnotationsOfType("ENAMEX");
            StatParser.clearInputAnnotations(externalDocument);
            externalDocument.removeAnnotationsOfType("tagger");
        }
        documentCollection.saveAs(string2);
    }

    public static void clearInputAnnotations(Document document) {
        Vector vector = document.annotationsOfType("ANNOTATION");
        if (vector == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            Annotation annotation = (Annotation)vector.get(i);
            int n = annotation.span().start();
            int n2 = annotation.span().end();
            for (int j = n; j < n2; ++j) {
                if (Character.isWhitespace(document.charAt(i))) continue;
                document.setCharAt(i, ' ');
            }
        }
        document.removeAnnotationsOfType("ANNOTATION");
    }

    static {
        initialized = false;
        headFinder = null;
    }
}

