/*
 * Decompiled with CFR 0.152.
 */
package AceJet;

import AceJet.AceDocument;
import AceJet.AceEntity;
import AceJet.AceEntityMention;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import Jet.Tipster.Span;
import Jet.Zoner.SentenceSplitter;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Vector;

public class CoherenceAnalyzer {
    static final String ACEdir = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/";
    static final String fileList = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/training nwire.txt";
    static final int NSENT = 50;
    static int[] mentionCount = new int[50];
    static int[] mentionWithAnaphorCount = new int[50];
    static int[] mentionWithAntecedentCount = new int[50];
    private static int[] sentenceBoundaries;
    private static String firstSentence;
    static ArrayList spans;

    public static void main(String[] stringArray) throws Exception {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(fileList));
        int n = 0;
        while ((string = bufferedReader.readLine()) != null) {
            System.out.println("\nProcessing document " + ++n + ": " + string);
            String string2 = ACEdir + string + ".sgm";
            boolean bl = fileList.indexOf("03") > 0;
            String string3 = ACEdir + string + (bl ? ".apf.xml" : ".sgm.tmx.rdc.xml");
            CoherenceAnalyzer.reset();
            CoherenceAnalyzer.analyzeDocument(string2, string3);
            CoherenceAnalyzer.report(sentenceBoundaries.length);
        }
        CoherenceAnalyzer.report(50);
    }

    private static void analyzeDocument(String string, String string2) {
        AceDocument aceDocument = new AceDocument(string, string2);
        Document document = aceDocument.JetDocument();
        CoherenceAnalyzer.collectSentenceBoundaries(document);
        CoherenceAnalyzer.collectMentionSpans(aceDocument);
        CoherenceAnalyzer.findEntityMentions(aceDocument);
    }

    static void findEntityMentions(AceDocument aceDocument) {
        ArrayList arrayList = aceDocument.entities;
        for (int i = 0; i < arrayList.size(); ++i) {
            AceEntity aceEntity = (AceEntity)arrayList.get(i);
            ArrayList arrayList2 = aceEntity.mentions;
            CoherenceAnalyzer.analyzeMentions(arrayList2);
        }
    }

    private static void analyzeMentions(ArrayList arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            AceEntityMention aceEntityMention = (AceEntityMention)arrayList.get(i);
            Span span = aceEntityMention.head;
            int n = CoherenceAnalyzer.sentenceNumber(span);
            if (n >= 50) continue;
            boolean bl = i > 0;
            boolean bl2 = i < arrayList.size() - 1;
            int n2 = n;
            mentionCount[n2] = mentionCount[n2] + 1;
            if (bl2) {
                int n3 = n;
                mentionWithAnaphorCount[n3] = mentionWithAnaphorCount[n3] + 1;
            }
            if (!bl) continue;
            int n4 = n;
            mentionWithAntecedentCount[n4] = mentionWithAntecedentCount[n4] + 1;
        }
    }

    private static void reset() {
        mentionCount = new int[50];
        mentionWithAnaphorCount = new int[50];
        mentionWithAntecedentCount = new int[50];
    }

    private static void report(int n) {
        for (int i = 0; i < n && i < 50; ++i) {
            System.out.print("Sentence " + i + ": ");
            System.out.print(mentionCount[i] + " mentions, ");
            System.out.print(mentionWithAnaphorCount[i] + " with anaphors, ");
            System.out.println(mentionWithAntecedentCount[i] + " with antecedents");
        }
        if (mentionCount[1] > 0 && mentionWithAnaphorCount[1] == 0) {
            System.out.println("**** Isolated first sentence:");
            System.out.println("     " + firstSentence);
        }
    }

    private static void collectSentenceBoundaries(Document document) {
        Vector vector = document.annotationsOfType("TEXT");
        Annotation annotation = (Annotation)vector.get(0);
        Span span = annotation.span();
        SentenceSplitter.split(document, span);
        Vector vector2 = document.annotationsOfType("sentence");
        Span span2 = ((Annotation)vector2.get(0)).span();
        firstSentence = document.text(span2);
        int n = firstSentence.indexOf(95) + span2.start();
        sentenceBoundaries = new int[vector2.size() + 1];
        CoherenceAnalyzer.sentenceBoundaries[0] = n;
        for (int i = 0; i < vector2.size(); ++i) {
            CoherenceAnalyzer.sentenceBoundaries[i + 1] = ((Annotation)vector2.get(i)).span().end();
        }
    }

    private static int sentenceNumber(Span span) {
        int n = span.start();
        for (int i = 0; i < sentenceBoundaries.length; ++i) {
            if (n >= sentenceBoundaries[i]) continue;
            return i;
        }
        return -1;
    }

    private static void collectMentionSpans(AceDocument aceDocument) {
        spans = new ArrayList();
        ArrayList arrayList = aceDocument.entities;
        for (int i = 0; i < arrayList.size(); ++i) {
            AceEntity aceEntity = (AceEntity)arrayList.get(i);
            if (aceEntity.generic) continue;
            ArrayList arrayList2 = aceEntity.mentions;
            for (int j = 0; j < arrayList2.size(); ++j) {
                AceEntityMention aceEntityMention = (AceEntityMention)arrayList2.get(j);
                spans.add(aceEntityMention.extent);
            }
        }
    }

    private static boolean embedded(AceEntityMention aceEntityMention) {
        Span span = aceEntityMention.extent;
        for (int i = 0; i < spans.size(); ++i) {
            Span span2 = (Span)spans.get(i);
            if (!span.within(span2) || span.equals(span2)) continue;
            return true;
        }
        return false;
    }

    static {
        spans = new ArrayList();
    }
}

