/*
 * Decompiled with CFR 0.152.
 */
package Jet.Refres;

import AceJet.Ace;
import AceJet.AceDocument;
import AceJet.PerfectAce;
import Jet.Concepts.ConceptHierarchy;
import Jet.Console;
import Jet.JetTest;
import Jet.Lex.Tokenizer;
import Jet.Lisp.FeatureSet;
import Jet.Parser.StatParser;
import Jet.Parser.SynFun;
import Jet.Refres.Hobbs;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import Jet.Tipster.Span;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;

public class Resolve {
    static Vector clauses;
    static Vector entities;
    static HashMap mentionToEntity;
    static HashMap syntacticAntecedent;
    public static boolean trace;
    private static final boolean ACE = true;
    private static final String[] definiteDets;
    private static final String[] indefiniteDets;
    private static final String[] genericPersonTerms;
    private static final String[] genericOrganizationTerms;
    private static final String[] genericCountryTerms;
    private static final String[] genericStateTerms;
    private static final String[] genericGpeTerms;
    private static final String[] genericLocationTerms;
    private static final String[] genericFacilityTerms;
    private static HashMap nominative;
    private static int[] sentenceBoundaries;
    private static Vector sentences;

    public static void references(Document document, Span span) {
        Vector vector = Resolve.gatherMentions(document, span);
        Resolve.references(document, span, vector);
    }

    public static void references(Document document, Span span, Vector vector) {
        entities = document.annotationsOfType("entity");
        if (entities == null) {
            entities = new Vector();
        }
        mentionToEntity = new HashMap();
        if (trace) {
            Console.println("Resolving references");
        }
        Resolve.collectSentenceBoundaries(document);
        Resolve.markMentions(vector);
        Resolve.gatherSyntacticCoref(document, vector);
        for (int i = 0; i < vector.size(); ++i) {
            Annotation annotation = (Annotation)vector.get(i);
            Resolve.resolveMention(document, annotation);
        }
        Resolve.updateEvents(document, span);
    }

    public static Vector gatherMentions(Document document, Span span) {
        clauses = new Vector();
        Vector<Annotation> vector = new Vector<Annotation>();
        Vector<Object> vector2 = new Vector<Object>();
        for (int i = span.start(); i < span.end(); ++i) {
            Vector vector3 = document.annotationsAt(i, "constit");
            if (vector3 == null) continue;
            for (int j = 0; j < vector3.size(); ++j) {
                Annotation annotation = (Annotation)vector3.elementAt(j);
                String string = (String)annotation.get("cat");
                if (string.equals("ngroup") || string.equals("np") && !Resolve.conjoinedNP(document, annotation) || string.equals("det") && annotation.get("tposs") == "t" || string.equals("name") || AceDocument.ace2004 && string.equals("title") && annotation.get("hidden") == null || AceDocument.ace2004 && (string.equals("n") || string.equals("nnp") || string.equals("nnps")) && (annotation.get("preName-1") != null || Ace.perfectMentions && annotation.get("id") != null) || Ace.perfectMentions && (string.equals("whnp") || string.equals("adj") || string.equals("adv"))) {
                    Object object;
                    Annotation annotation2 = Resolve.getHeadC(annotation);
                    if (annotation2.get("cat") == "timex" || annotation2.get("cat") == "ordinal" || !Ace.perfectMentions && (annotation2.get("cat") == "adv" || "there".equalsIgnoreCase((String)(object = SynFun.getHead(document, annotation)))) || annotation2.get("cat") == "ving" || Ace.perfectMentions && (annotation.get("id") == null || !PerfectAce.validMention(document, annotation2, string))) continue;
                    vector.add(annotation);
                    object = (Annotation)annotation.get("headC");
                    if (object == null) continue;
                    vector2.add(object);
                    continue;
                }
                if (!string.equals("s") && !string.equals("rn-wh") && !string.equals("rn-vingo")) continue;
                clauses.add(annotation);
            }
        }
        vector.removeAll(vector2);
        return vector;
    }

    private static boolean conjoinedNP(Document document, Annotation annotation) {
        Annotation[] annotationArray = StatParser.children(annotation);
        if (annotationArray == null || annotationArray.length != 3) {
            return false;
        }
        boolean bl = annotationArray[0].get("cat") == "np" && annotationArray[1].get("cat") == "cconj" && annotationArray[2].get("cat") == "np";
        return bl;
    }

    private static void markMentions(Vector vector) {
        if (vector == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            Annotation annotation = (Annotation)vector.get(i);
            annotation.put("mention", "true");
        }
    }

    public static HashMap gatherSyntacticCoref(Document document, Vector vector) {
        Annotation annotation;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Annotation annotation2;
        int n;
        syntacticAntecedent = new HashMap();
        for (n = 0; n < vector.size(); ++n) {
            annotation2 = (Annotation)vector.get(n);
            object4 = Resolve.getHeadC(annotation2);
            object3 = SynFun.getHead(document, annotation2);
            object2 = Resolve.getNgHead(annotation2);
            if (object3 == null) {
                System.out.println("No head for annotation " + annotation2 + " over " + document.text(annotation2));
                continue;
            }
            if (annotation2.get("preName") != null) {
                object = (Annotation)annotation2.get("preName");
                Resolve.recordSyntacticCoref((Annotation)object, annotation2, document, vector);
            }
            object = SynFun.getNumber(annotation2);
            if (object3 != null && (((String)object3).equals("city") || ((String)object3).equals("state") || ((String)object3).equals("county") || ((String)object3).equals("village") || ((String)object3).equals("town") || ((String)object3).equals("island") || ((String)object3).equals("port") || ((String)object3).equals("province")) && (object == null || !((String)object).equals("plural")) && (annotation = (Annotation)annotation2.get("of")) != null && Resolve.isName(Resolve.getHeadC(annotation))) {
                Resolve.recordSyntacticCoref(annotation, annotation2, document, vector);
                if (trace) {
                    System.out.println("Found X of Y coref pair: " + document.text(annotation2));
                }
            }
            if (object3 != null && (((String)object3).equals("all") || ((String)object3).equals("both")) && (annotation = (Annotation)annotation2.get("of")) != null) {
                Resolve.recordSyntacticCoref(annotation, annotation2, document, vector);
                if (trace) {
                    System.out.println("Found X of Y coref pair: " + document.text(annotation2));
                }
            }
            if (annotation2.get("apposite") != null) {
                annotation = (Annotation)annotation2.get("apposite");
                Resolve.recordSyntacticCoref(annotation, annotation2, document, vector);
                if (trace) {
                    System.out.println("Refres: found apposition coref pair: " + document.text(annotation2));
                }
            }
            if (annotation2.get("predComp") != null) {
                annotation = (Annotation)annotation2.get("predComp");
                Resolve.recordSyntacticCoref(annotation, annotation2, document, vector);
                if (trace) {
                    System.out.println("Refres: found predComp coref pair: " + document.text(annotation2) + " = " + document.text(annotation));
                }
            }
            if (annotation2.get("host") == null) continue;
            annotation = (Annotation)annotation2.get("host");
            Resolve.recordSyntacticCoref(annotation2, annotation, document, vector);
        }
        for (n = 0; n < clauses.size(); ++n) {
            annotation2 = (Annotation)clauses.get(n);
            object4 = SynFun.getHead(document, annotation2);
            if (object4 == null) {
                System.out.println("No head for annotation " + annotation2 + " over " + document.text(annotation2));
                continue;
            }
            if (annotation2.get("subject") == null || "there".equalsIgnoreCase((String)(object2 = SynFun.getHead(document, (Annotation)(object3 = (Annotation)annotation2.get("subject"))))) || "it".equalsIgnoreCase((String)object2) || (object = (Annotation)annotation2.get("headC")) == null || ((Annotation)object).get("object") == null) continue;
            annotation = (Annotation)((Annotation)object).get("object");
            if (!((String)object4).equals("be") && !((String)object4).equals("become")) continue;
            Resolve.recordSyntacticCoref(annotation, (Annotation)object3, document, vector);
            if (!trace) continue;
            System.out.println("Found copula relation: " + document.text(annotation2));
        }
        return syntacticAntecedent;
    }

    private static void recordSyntacticCoref(Annotation annotation, Annotation annotation2, Document document, Vector vector) {
        Annotation annotation3;
        int n = vector.indexOf(annotation2);
        if (n < 0) {
            System.out.println("Antecedent not in mentions: " + document.text(annotation2));
            return;
        }
        int n2 = vector.indexOf(annotation);
        if (n2 < 0) {
            System.out.println("Anaphor not in mentions: " + document.text(annotation));
            return;
        }
        if (n > n2) {
            vector.set(n, annotation);
            vector.set(n2, annotation2);
        }
        if ((annotation3 = (Annotation)syntacticAntecedent.get(annotation)) != null) {
            int n3;
            n = vector.indexOf(annotation2);
            if (n < (n3 = vector.indexOf(annotation3))) {
                syntacticAntecedent.put(annotation3, annotation2);
            } else {
                syntacticAntecedent.put(annotation, annotation2);
                syntacticAntecedent.put(annotation2, annotation3);
            }
        } else {
            syntacticAntecedent.put(annotation, annotation2);
        }
    }

    public static void updateEvents(Document document, Span span) {
        for (int i = span.start(); i < span.end(); ++i) {
            Vector vector = document.annotationsAt(i, "event");
            if (vector == null) continue;
            Annotation annotation = (Annotation)vector.elementAt(0);
            FeatureSet featureSet = new FeatureSet(annotation.attributes());
            Enumeration enumeration = featureSet.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Object object = featureSet.get(string);
                if (!mentionToEntity.containsKey(object)) continue;
                featureSet.put(string, mentionToEntity.get(object));
            }
            document.annotate("r-event", annotation.span(), featureSet);
        }
    }

    private static void resolveMention(Document document, Annotation annotation) {
        String string;
        Object object;
        boolean bl;
        String[] stringArray;
        Annotation annotation2 = Resolve.getHeadC(annotation);
        String string2 = (String)annotation2.get("cat");
        int n = annotation.span().start();
        String string3 = SynFun.getHead(document, annotation);
        if (string3 == null) {
            return;
        }
        String string4 = SynFun.getNumber(annotation);
        if (string4 == null) {
            string4 = "singular";
        }
        boolean bl2 = (stringArray = Resolve.getNameTokens(document, annotation)) != null;
        boolean bl3 = false;
        if (bl2) {
            boolean bl4 = bl = annotation.get("cat") != "np";
            if (bl && Ace.gazetteer.isNationality(stringArray)) {
                bl3 = true;
            }
            stringArray = Resolve.normalizeGazName(stringArray, bl, trace);
        }
        bl = string3 == "person";
        int n2 = 9999;
        int n3 = 999;
        Annotation annotation3 = null;
        if (syntacticAntecedent.containsKey(annotation) && !Ace.perfectEntities) {
            if (trace) {
                System.out.println("Using syntactically-determined antecedent.");
            }
            if ((annotation3 = (Annotation)mentionToEntity.get(object = (Annotation)syntacticAntecedent.get(annotation))) == null) {
                System.out.println("Resolve:  syntactic antecedent not in entity");
            }
        } else {
            for (int i = 0; i < entities.size(); ++i) {
                Object object2;
                int n4 = 0;
                Annotation annotation4 = (Annotation)entities.elementAt(i);
                boolean bl5 = false;
                if (Ace.perfectMentions & !Ace.perfectEntities) {
                    object2 = (String)annotation4.get("typeSubtype");
                    String string5 = PerfectAce.getTypeSubtype(annotation2);
                    if (object2 != null && string5 != null && !string5.equals("") && !string5.equals(object2)) continue;
                }
                if (Ace.perfectEntities) {
                    object2 = PerfectAce.getEntityID(annotation2);
                    bl5 = annotation4.get("entityID") != null && annotation4.get("entityID").equals(object2);
                } else if (bl2) {
                    n4 = Resolve.matchName(stringArray, string3, annotation4);
                    bl5 = n4 >= 0;
                } else if (string2 == "pro" || string2 == "det" || string2 == "np") {
                    bl5 = Resolve.matchPronoun(document, annotation, string3, annotation4);
                } else if (string2 == "n" || string2 == "adj" || string2 == "ven" || string2 == "v" || string2 == "tv" || string2 == "hyphword" || string2 == "title" || string2 == "nnp" || string2 == "nnps" || string2 == "adv") {
                    bl5 = Resolve.matchNom(document, annotation, annotation4);
                } else if (string2 == "$") {
                    bl5 = false;
                } else if (string2 == "q") {
                    bl5 = false;
                } else {
                    System.out.println("Unexpected head cat " + string2 + " for " + document.text(annotation));
                    bl5 = false;
                    break;
                }
                if (!bl5) continue;
                object2 = (Annotation)annotation4.get("lastMention");
                int n5 = (Integer)annotation4.get("position");
                int n6 = Hobbs.distance((Annotation)object2, annotation, sentences);
                if (n4 >= n3 && (n4 != n3 || n6 >= n2)) continue;
                n2 = n6;
                n3 = n4;
                annotation3 = annotation4;
            }
        }
        if (annotation3 == null) {
            annotation3 = document.annotate("entity", annotation.span(), new FeatureSet("mentions", new Vector()));
            annotation3.put("number", string4);
            if (bl) {
                annotation3.put("human", "t");
            }
            entities.addElement(annotation3);
            if (bl3) {
                annotation3.put("properAdjective", "true");
            }
            if (Ace.perfectEntities) {
                annotation3.put("entityID", PerfectAce.getEntityID(annotation2));
            }
            if (trace) {
                Console.println("Creating new entity for " + document.text(annotation));
            }
        } else {
            if (annotation3.get("properAdjective") != null && !bl3) {
                annotation3.put("properAdjective", null);
            }
            if (trace) {
                Console.println("Resolving " + document.text(annotation) + " to " + document.text(annotation3));
            }
        }
        annotation3.put("lastMention", annotation);
        annotation3.put("position", new Integer(annotation.span().start()));
        if (bl2) {
            if (annotation3.get("name") == null) {
                annotation3.put("name", stringArray);
                object = Resolve.getNgHead(annotation);
                String[] stringArray2 = Tokenizer.gatherTokenStrings(document, ((Annotation)object).span());
                annotation3.put("nameWithMods", stringArray2);
                annotation3.put("nameType", string3);
            }
        } else if (annotation3.get("head") == null) {
            annotation3.put("head", Resolve.nominativeFormOf(string3));
        }
        object = (Vector)annotation3.get("mentions");
        ((Vector)object).addElement(annotation);
        mentionToEntity.put(annotation, annotation3);
        if (Ace.perfectMentions && annotation3.get("typeSubtype") == null && (string = PerfectAce.getTypeSubtype(annotation2)) != null && !string.equals("")) {
            annotation3.put("typeSubtype", string);
        }
    }

    public static String[] normalizeGazName(String[] stringArray, boolean bl, boolean bl2) {
        String[] stringArray2;
        if (Ace.gazetteer == null) {
            return stringArray;
        }
        if (bl && Ace.gazetteer.isNationality(stringArray)) {
            stringArray2 = stringArray;
            stringArray = Ace.gazetteer.nationalityToCountry(stringArray);
            if (bl2) {
                System.out.println("Refres: using country " + Resolve.concat(stringArray) + " for nationality " + Resolve.concat(stringArray2));
            }
        }
        if (Ace.gazetteer.isCountryAlias(stringArray)) {
            stringArray2 = stringArray;
            stringArray = Ace.gazetteer.canonicalCountryName(stringArray);
            if (bl2) {
                System.out.println("Refres: using country " + Resolve.concat(stringArray) + " for alias " + Resolve.concat(stringArray2));
            }
        }
        return stringArray;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean matchNom(Document var0, Annotation var1_1, Annotation var2_2) {
        var3_3 = (Integer)var2_2.get("position");
        var4_4 = var1_1.span().start();
        var5_5 = ((Vector)var2_2.get("mentions")).size();
        var6_6 = SynFun.getHead(var0, var1_1);
        if (var6_6 == null) {
            return false;
        }
        var7_7 = SynFun.getDet(var1_1);
        var8_8 = SynFun.getNumber(var1_1);
        if (var8_8 == null) {
            var8_8 = "singular";
        }
        var9_9 = Resolve.getNgHead(var1_1);
        var10_10 = null;
        if (JetTest.conceptHierarchy != null) {
            var10_10 = JetTest.conceptHierarchy.getConceptFor(var6_6);
        }
        var11_11 = (String)var2_2.get("number");
        if (Resolve.in(var7_7, Resolve.indefiniteDets)) {
            return false;
        }
        if (var9_9.get("quant") != null || var7_7 == "q") {
            return false;
        }
        if (var9_9.get("poss") != null) {
            return false;
        }
        if (var8_8 != null && var11_11 != null && !var8_8.equals(var11_11)) {
            return false;
        }
        if (Resolve.nameNomCoref(var0, var7_7, var6_6, var1_1, var2_2)) {
            return true;
        }
        var12_12 = Resolve.getNgTokens(var0, var1_1);
        var13_13 = Resolve.getLeftModifierTokens(var0, var1_1);
        var14_14 = Resolve.getRightModifierTokens(var0, var1_1);
        var15_15 = Resolve.concat((String[])var13_13, (String[])var14_14);
        var16_16 = (Vector)var2_2.get("mentions");
        for (var17_17 = 0; var17_17 < var16_16.size(); ++var17_17) {
            block18: {
                var18_18 = (Annotation)var16_16.get(var17_17);
                var19_19 = Resolve.getHeadC(var18_18);
                var20_20 = (String)var19_19.get("cat");
                if (var20_20 == "pro" || var20_20 == "det") continue;
                var21_21 = SynFun.getDet(var18_18);
                var22_22 = SynFun.getHead(var0, var18_18);
                if (var22_22 == null) continue;
                var23_23 = null;
                if (JetTest.conceptHierarchy != null) {
                    var23_23 = JetTest.conceptHierarchy.getConceptFor(var22_22);
                }
                var24_24 = false;
                if (var10_10 == null || var23_23 == null) break block18;
                if (ConceptHierarchy.isaStar(var23_23, var10_10)) ** GOTO lbl-1000
            }
            if (var6_6.equals(var22_22) || var24_24) lbl-1000:
            // 2 sources

            {
                v0 = true;
            } else {
                v0 = var25_25 = false;
            }
            if (!var25_25) continue;
            if (var21_21 == null && (var15_15.length > 0 || var7_7 != null)) {
                return false;
            }
            var26_26 = Resolve.getNgTokens(var0, var18_18);
            var27_27 = Resolve.getLeftModifierTokens(var0, var18_18);
            var28_28 = Resolve.getRightModifierTokens(var0, var18_18);
            var29_29 = Resolve.concat((String[])var27_27, (String[])var28_28);
            var30_30 = Resolve.intersect(var13_13, var27_27);
            var31_31 = Resolve.intersect(var14_14, var28_28);
            var32_32 = Resolve.intersect(var15_15, var29_29);
            if (!var30_30 || !var31_31) {
                if (Resolve.trace) {
                    System.out.println("Refres: modifier compability rejects merge of");
                    System.out.println("        " + var0.text(var18_18) + " and " + var0.text(var1_1));
                }
                return false;
            }
            if (Resolve.equalArray(var12_12, var26_26) && Resolve.equalArray(var14_14, var28_28)) {
                return true;
            }
            if (var5_5 == 1 && Resolve.sentencesBetween(var3_3, var4_4) > 4) {
                return false;
            }
            if (var24_24) {
                System.out.println("******* WordNet allowed merge of ");
                System.out.println("        " + var0.text(var18_18) + " and " + var0.text(var1_1));
            }
            return true;
        }
        return false;
    }

    private static String[] getNgTokens(Document document, Annotation annotation) {
        Annotation annotation2 = Resolve.getNgHead(annotation);
        return Tokenizer.gatherTokenStrings(document, annotation2.span());
    }

    private static String[] getLeftModifierTokens(Document document, Annotation annotation) {
        Annotation annotation2 = Resolve.getNgHead(annotation);
        int n = annotation2.start();
        Annotation annotation3 = Resolve.getHeadC(annotation);
        int n2 = annotation3.start();
        int n3 = n;
        ArrayList<String> arrayList = new ArrayList<String>();
        block0: while (n3 < n2) {
            Vector vector = document.annotationsAt(n3, "constit");
            if (vector != null) {
                for (int i = 0; i < vector.size(); ++i) {
                    Annotation annotation4 = (Annotation)vector.get(i);
                    String string = (String)annotation4.get("cat");
                    if (string != "det" && string != "ving" && string != "ven") continue;
                    n3 = annotation4.span().end();
                    continue block0;
                }
            }
            Annotation annotation5 = document.tokenAt(n3);
            String string = document.text(annotation5).trim();
            arrayList.add(string);
            n3 = annotation5.span().end();
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    private static String[] getRightModifierTokens(Document document, Annotation annotation) {
        int n;
        Annotation annotation2 = Resolve.getHeadC(annotation);
        int n2 = annotation2.end();
        if (n2 == (n = annotation.end())) {
            return new String[0];
        }
        String[] stringArray = Tokenizer.gatherTokenStrings(document, new Span(n2, n));
        if (stringArray.length > 0 && stringArray[0] == ",") {
            return new String[0];
        }
        return stringArray;
    }

    public static Annotation getNgHead(Annotation annotation) {
        Annotation annotation2 = annotation;
        while ((annotation = (Annotation)annotation2.get("headC")) != null) {
            if (annotation.get("cat") != "np") {
                return annotation2;
            }
            annotation2 = annotation;
        }
        return annotation2;
    }

    private static String[] getOfModifierTokens(Document document, Annotation annotation) {
        Annotation annotation2 = (Annotation)annotation.get("of");
        if (annotation2 == null) {
            return new String[0];
        }
        return Tokenizer.gatherTokenStrings(document, annotation2.span());
    }

    private static String[] concat(String[] stringArray, String[] stringArray2) {
        int n;
        if (stringArray.length == 0) {
            return stringArray2;
        }
        if (stringArray2.length == 0) {
            return stringArray;
        }
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray3[n] = stringArray[n];
        }
        for (n = 0; n < stringArray2.length; ++n) {
            stringArray3[n + stringArray.length] = stringArray2[n];
        }
        return stringArray3;
    }

    public static boolean nameNomCoref(Document document, String string, String string2, Annotation annotation, Annotation annotation2) {
        if (string == null) {
            return false;
        }
        if (!(string.equals("the") || string.equals("this") || string.equals("that"))) {
            return false;
        }
        String[] stringArray = (String[])annotation2.get("name");
        if (stringArray == null) {
            return false;
        }
        if (stringArray[0].equals("AP")) {
            return false;
        }
        if (Resolve.nomInName(document, annotation, annotation2)) {
            return true;
        }
        String string3 = (String)annotation2.get("nameType");
        if (string3.equals("person")) {
            return Resolve.in(string2, genericPersonTerms);
        }
        if (string3.equals("organization")) {
            return Resolve.in(string2, genericOrganizationTerms);
        }
        if (string3.equals("gpe")) {
            if (Ace.gazetteer.isNationality(stringArray) || Ace.gazetteer.isCountry(stringArray)) {
                return Resolve.in(string2, genericCountryTerms);
            }
            if (Ace.gazetteer.isState(stringArray)) {
                return Resolve.in(string2, genericStateTerms);
            }
            if (Ace.gazetteer.isRegionOrContinent(stringArray)) {
                return false;
            }
            return Resolve.in(string2, genericGpeTerms);
        }
        if (string3.equals("location")) {
            return Resolve.in(string2, genericLocationTerms);
        }
        if (string3.equals("facility")) {
            return Resolve.in(string2, genericFacilityTerms);
        }
        return false;
    }

    public static boolean nomInName(Document document, Annotation annotation, Annotation annotation2) {
        String[] stringArray = (String[])annotation2.get("nameWithMods");
        if (stringArray == null) {
            return false;
        }
        Annotation annotation3 = Resolve.getNgHead(annotation);
        String[] stringArray2 = Tokenizer.gatherTokenStrings(document, annotation3.span());
        for (int i = 0; i < stringArray2.length; ++i) {
            if (stringArray2[i].equalsIgnoreCase("the")) continue;
            boolean bl = false;
            for (int j = 0; j < stringArray.length; ++j) {
                if (!stringArray2[i].equalsIgnoreCase(stringArray[j])) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    private static int matchName(String[] stringArray, String string, Annotation annotation) {
        String[] stringArray2 = (String[])annotation.get("name");
        if (stringArray2 == null) {
            return -1;
        }
        String string2 = (String)annotation.get("nameType");
        int n = Resolve.matchFullName(stringArray, string, stringArray2, string2);
        if (n >= 0) {
            return n;
        }
        n = Resolve.matchFullName(stringArray2, string2, stringArray, string);
        if (n >= 0) {
            return n;
        }
        if (stringArray.length == 1) {
            n = Resolve.isAcronym(stringArray2, stringArray[0]);
            if (n >= 0) {
                return n;
            }
            n = Resolve.isAbbreviation(stringArray2, stringArray[0]);
            if (n >= 0) {
                return n;
            }
        }
        if (stringArray2.length == 1) {
            n = Resolve.isAcronym(stringArray, stringArray2[0]);
            if (n >= 0) {
                return n;
            }
            n = Resolve.isAbbreviation(stringArray, stringArray2[0]);
            if (n >= 0) {
                return n;
            }
        }
        return -1;
    }

    public static int matchFullName(String[] stringArray, String string, String[] stringArray2, String string2) {
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            while (n < stringArray2.length && !stringArray[i].equalsIgnoreCase(stringArray2[n])) {
                ++n;
            }
            if (n >= stringArray2.length) {
                return -1;
            }
            ++n;
        }
        if (stringArray.length < stringArray2.length) {
            if ((Ace.gazetteer.isNationality(stringArray) || Ace.gazetteer.isLocation(stringArray) || string == "gpe") && string2 != "person") {
                if (trace) {
                    System.out.println("Refres: rejecting (location) " + Resolve.concat(stringArray) + " as alias of " + Resolve.concat(stringArray2));
                }
                return -1;
            }
            if (trace) {
                System.out.println("Refres: recognizing " + Resolve.concat(stringArray) + " as alias of " + Resolve.concat(stringArray2));
            }
        }
        return stringArray2.length - stringArray.length;
    }

    public static int isAcronym(String[] stringArray, String string) {
        if (stringArray.length < 2 || string.length() < 2) {
            return -1;
        }
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            while (n < stringArray.length && stringArray[n].charAt(0) != string.charAt(i)) {
                ++n;
            }
            if (n >= stringArray.length) {
                return -1;
            }
            ++n;
        }
        if (trace) {
            System.out.println("Refres: recognizing " + string + " as acronym of " + Resolve.concat(stringArray));
        }
        return stringArray.length - string.length();
    }

    public static int isAbbreviation(String[] stringArray, String string) {
        if (stringArray.length < 2 || string.length() < 4 || string.length() % 2 == 1) {
            return -1;
        }
        int n = 0;
        for (int i = 0; i < string.length() / 2; ++i) {
            if (string.charAt(2 * i + 1) != '.') {
                return -1;
            }
            while (n < stringArray.length && stringArray[n].charAt(0) != string.charAt(2 * i)) {
                ++n;
            }
            if (n >= stringArray.length) {
                return -1;
            }
            ++n;
        }
        if (trace) {
            System.out.println("Refres: recognizing " + string + " as abbreviation of " + Resolve.concat(stringArray));
        }
        return stringArray.length - (string.length() - 2);
    }

    private static String nominativeFormOf(String string) {
        if (nominative.containsKey(string)) {
            return (String)nominative.get(string);
        }
        return string;
    }

    public static boolean matchPronoun(Document document, Annotation annotation, String string, Annotation annotation2) {
        boolean bl;
        if (annotation2.get("properAdjective") != null) {
            return false;
        }
        int n = (Integer)annotation2.get("position");
        int n2 = annotation.span().start();
        String string2 = (String)annotation2.get("head");
        String string3 = Resolve.nominativeFormOf(string);
        if (string3 == "he" || string3 == "she") {
            bl = annotation2.get("human") != null && annotation2.get("number") == "singular";
        } else if (string3 == "it") {
            bl = annotation2.get("human") == null && annotation2.get("number") == "singular";
        } else if (string3 == "they") {
            bl = annotation2.get("number") == "plural" || annotation2.get("nameType") == "organization";
        } else if (string3 == "I" || string3 == "i" || string3 == "we" || string3 == "you") {
            bl = annotation2.get("human") != null;
        } else if (string == "some" || string == "either" || string == "neither" || string == "any" || string == "each" || string == "all" || string == "both" || string == "none" || string == "many" || string == "afew" || string == "most" || string == "q" || string == "one") {
            bl = false;
        } else if (string == "everyone" || string == "everything" || string == "everybody" || string == "nobody" || string == "noone" || string == "nothing" || string == "anyone" || string == "anything" || string == "anybody" || string == "someone" || string == "somebody" || string == "something" || string == "another") {
            bl = false;
        } else if (string == "this" || string == "these" || string == "that" || string == "those") {
            bl = false;
        } else {
            System.out.println("Pronoun not being handled:  " + string);
            bl = false;
        }
        return bl;
    }

    public static String normalizeName(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreTokens()) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" ");
            }
            stringBuffer.append(stringTokenizer.nextToken());
        }
        return stringBuffer.toString();
    }

    public static String concat(String[] stringArray) {
        if (stringArray.length == 0) {
            return "";
        }
        String string = stringArray[0];
        for (int i = 1; i < stringArray.length; ++i) {
            string = string + " " + stringArray[i];
        }
        return string;
    }

    public static boolean isName(Annotation annotation) {
        return annotation != null && annotation.get("cat") == "name";
    }

    public static Annotation getHeadC(Annotation annotation) {
        while (annotation.get("headC") != null) {
            annotation = (Annotation)annotation.get("headC");
        }
        return annotation;
    }

    public static String[] getNameTokens(Document document, Annotation annotation) {
        Annotation annotation2 = Resolve.getHeadC(annotation);
        if (annotation2.get("cat") != "name") {
            return null;
        }
        return Tokenizer.gatherTokenStrings(document, annotation2.span());
    }

    public static String[] getHeadTokens(Document document, Annotation annotation) {
        Annotation annotation2 = Resolve.getHeadC(annotation);
        return Tokenizer.gatherTokenStrings(document, annotation2.span());
    }

    public static boolean in(Object object, Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null || !objectArray[i].equals(object)) continue;
            return true;
        }
        return false;
    }

    public static boolean intersect(Object[] objectArray, Object[] objectArray2) {
        if (objectArray.length == 0) {
            return true;
        }
        if (objectArray2.length == 0) {
            return true;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (!Resolve.in(objectArray[i], objectArray2)) continue;
            return true;
        }
        return false;
    }

    public static boolean equalArray(Object[] objectArray, Object[] objectArray2) {
        if (objectArray.length != objectArray2.length) {
            return false;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != null && objectArray[i].equals(objectArray2[i])) continue;
            return false;
        }
        return true;
    }

    private static void collectSentenceBoundaries(Document document) {
        sentences = document.annotationsOfType("sentence");
        sentenceBoundaries = new int[sentences.size()];
        for (int i = 0; i < sentences.size(); ++i) {
            Resolve.sentenceBoundaries[i] = ((Annotation)sentences.get(i)).span().start();
        }
    }

    private static int sentencesBetween(int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < sentenceBoundaries.length; ++i) {
            if (n >= sentenceBoundaries[i] || sentenceBoundaries[i] > n2) continue;
            ++n3;
        }
        return n3;
    }

    public static int sentenceNumber(int n) {
        for (int i = 1; i < sentenceBoundaries.length; ++i) {
            if (n >= sentenceBoundaries[i]) continue;
            return i - 1;
        }
        return sentenceBoundaries.length - 1;
    }

    private static int pseudoHobbsDistance(int n, int n2) {
        if (Resolve.sentencesBetween(n, n2) == 0) {
            return n2 - n;
        }
        for (int i = 0; i < sentenceBoundaries.length - 1; ++i) {
            if (n < sentenceBoundaries[i] || n >= sentenceBoundaries[i + 1]) continue;
            return n - sentenceBoundaries[i] + (n2 - sentenceBoundaries[i + 1]) + 1;
        }
        return 99999;
    }

    static {
        trace = true;
        definiteDets = new String[]{"the", "this", "these", "that", "those"};
        indefiniteDets = new String[]{"few", "afew", "more", "many", "most", "some", "any", "several", "less", "neither", "another", "such", "no", "either"};
        genericPersonTerms = new String[]{"man", "human", "person", "individual", "gentleman", "fellow", "boy", "woman", "lady", "girl", "official", "player", "diplomat", "chairman", "officer", "executive", "leader", "lawyer", "friend", "father", "president", "spokesman", "governor", "coach", "attorney", "member", "director", "body"};
        genericOrganizationTerms = new String[]{"academy", "administration", "agency", "airline", "army", "association", "board", "business", "college", "church", "company", "corporation", "establishment", "institute", "institution", "firm", "group", "military", "office", "panel", "partnership", "party", "police", "school", "synagogue", "syndicate", "team", "trust", "union", "university", "organization", "cathedral", "coalition", "temple", "bank", "commission", "committee", "council", "court", "department", "division", "federation", "force", "guild", "industry", "mosque", "league", "parliament", "seminary", "society"};
        genericCountryTerms = new String[]{"government", "country", "nation", "people", "kingdom"};
        genericStateTerms = new String[]{"state"};
        genericGpeTerms = new String[]{"village", "capital", "metropolis", "capital", "city", "town", "province"};
        genericLocationTerms = new String[]{"area", "region", "mount", "mountain", "hill", "ridge", "lake", "pond", "ocean", "sea", "river", "creek", "brook", "bayou", "stream"};
        genericFacilityTerms = new String[]{"tower", "castle", "hotel", "palace", "hall", "house", "road", "route", "bridge", "pass", "tunnel", "home", "street", "stadium"};
        nominative = new HashMap();
        nominative.put("me", "I");
        nominative.put("my", "I");
        nominative.put("myself", "I");
        nominative.put("your", "you");
        nominative.put("yourself", "you");
        nominative.put("him", "he");
        nominative.put("his", "he");
        nominative.put("himself", "he");
        nominative.put("her", "she");
        nominative.put("hers", "she");
        nominative.put("herself", "she");
        nominative.put("its", "it");
        nominative.put("itself", "it");
        nominative.put("us", "we");
        nominative.put("our", "we");
        nominative.put("ourselves", "we");
        nominative.put("them", "they");
        nominative.put("their", "they");
        nominative.put("themselves", "they");
    }
}

