/*
 * Decompiled with CFR 0.152.
 */
package AceJet;

import AceJet.Ace;
import AceJet.AceDocument;
import AceJet.AceEntity;
import AceJet.AceEntityMention;
import AceJet.LearnRelations;
import Jet.Control;
import Jet.JetTest;
import Jet.Lex.Tokenizer;
import Jet.Lisp.FeatureSet;
import Jet.Parser.StatParser;
import Jet.Pat.NewAnnotationAction;
import Jet.Pat.Pat;
import Jet.Refres.Resolve;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import Jet.Tipster.DocumentCollection;
import Jet.Tipster.ExternalDocument;
import Jet.Tipster.Span;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

public class PerfectAce
extends Resolve {
    static HashMap entityMentionMap = null;

    public static void main(String[] stringArray) throws IOException {
        String string = "C:/Documents and Settings/Ralph Grishman/My Documents/";
        String string2 = string + "ACE/";
        Ace.perfectMentions = true;
        String string3 = string2 + "rdreval04 nwire sgm.txt";
        String string4 = string2 + "perfect parses/rdreval04 nwire parses.txt";
        PerfectAce.parseCollection(string3, string4);
    }

    private static void parseCollection(String string, String string2) throws IOException {
        System.out.println("Starting ACE Jet...");
        JetTest.initializeFromConfig("props/ace perfect just parser.properties");
        Pat.trace = false;
        DocumentCollection documentCollection = new DocumentCollection(string);
        documentCollection.open();
        for (int i = 0; i < documentCollection.size(); ++i) {
            ExternalDocument externalDocument = documentCollection.get(i);
            System.out.println("\nProcessing document " + i + ": " + externalDocument.fileName());
            externalDocument.setAllTags(true);
            externalDocument.open();
            String string3 = externalDocument.fullFileName();
            String string4 = string3.replaceAll(".sgm", ".entities.apf.xml");
            AceDocument aceDocument = new AceDocument(string3, string4);
            Ace.monocase = Ace.allLowerCase(externalDocument);
            Control.processDocument(externalDocument, null, i == -1, i);
            PerfectAce.createPerfectNames(externalDocument, aceDocument);
            Vector vector = externalDocument.annotationsOfType("sentence");
            for (int j = 0; j < vector.size(); ++j) {
                Annotation annotation = (Annotation)vector.get(j);
                StatParser.parse(externalDocument, annotation.span());
            }
            externalDocument.removeAnnotationsOfType("ENAMEX");
            StatParser.clearInputAnnotations(externalDocument);
            externalDocument.removeAnnotationsOfType("tagger");
        }
        documentCollection.saveAs(string2);
    }

    static void createPerfectNames(ExternalDocument externalDocument, AceDocument aceDocument) {
        ArrayList arrayList = aceDocument.entities;
        for (int i = 0; i < arrayList.size(); ++i) {
            AceEntity aceEntity = (AceEntity)arrayList.get(i);
            ArrayList arrayList2 = aceEntity.mentions;
            for (int j = 0; j < arrayList2.size(); ++j) {
                Object object;
                int n;
                Annotation annotation;
                Vector vector;
                AceEntityMention aceEntityMention = (AceEntityMention)arrayList2.get(j);
                LearnRelations.doc = externalDocument;
                Span span = LearnRelations.aceSpanToJetSpan(aceEntityMention.head);
                String string = aceEntityMention.type;
                if (string.equals("PRE") && (vector = externalDocument.annotationsAt(span.start(), "ENAMEX")) != null && (annotation = (Annotation)vector.get(0)).end() == span.end()) {
                    string = "NAM";
                }
                if (!string.equals("NAM")) continue;
                int n2 = n = span.start();
                int n3 = span.end();
                while (n2 < n3) {
                    object = externalDocument.tokenAt(n2);
                    if (object == null) continue;
                    n2 = ((Annotation)object).end();
                }
                object = new Span(n, n2);
                NewAnnotationAction.hideAnnotations(externalDocument, "constit", (Span)object);
                NewAnnotationAction.hideAnnotations(externalDocument, "token", (Span)object);
                Annotation annotation2 = new Annotation("constit", (Span)object, new FeatureSet("cat", "name", "pa", new FeatureSet("head", aceEntity.type.toLowerCase(), "number", "singular")));
                externalDocument.addAnnotation(annotation2);
            }
        }
    }

    static void buildEntityMentionMap(ExternalDocument externalDocument, AceDocument aceDocument) {
        entityMentionMap = new HashMap();
        ArrayList arrayList = aceDocument.entities;
        for (int i = 0; i < arrayList.size(); ++i) {
            AceEntity aceEntity = (AceEntity)arrayList.get(i);
            ArrayList arrayList2 = aceEntity.mentions;
            for (int j = 0; j < arrayList2.size(); ++j) {
                AceEntityMention aceEntityMention = (AceEntityMention)arrayList2.get(j);
                LearnRelations.doc = externalDocument;
                Span span = LearnRelations.aceSpanToJetSpan(aceEntityMention.head);
                entityMentionMap.put(new Integer(span.start()), new Object[]{aceEntity, aceEntityMention});
            }
        }
    }

    public static boolean validMention(Document document, Annotation annotation, String string) {
        if (entityMentionMap == null) {
            System.out.println("*** PerfectAce.validMention:  no entityMentionMap");
            return true;
        }
        if (string == "title") {
            Annotation[] annotationArray = Tokenizer.gatherTokens(document, annotation.span());
            for (int i = 0; i < annotationArray.length; ++i) {
                Integer n = new Integer(annotationArray[i].start());
                if (entityMentionMap.get(n) == null) continue;
                return true;
            }
            return false;
        }
        Integer n = new Integer(annotation.start());
        boolean bl = entityMentionMap.get(n) != null;
        return bl;
    }

    public static String getEntityID(Annotation annotation) {
        if (entityMentionMap == null) {
            return null;
        }
        Integer n = new Integer(annotation.start());
        Object[] objectArray = (Object[])entityMentionMap.get(n);
        if (objectArray == null) {
            return null;
        }
        AceEntity aceEntity = (AceEntity)objectArray[0];
        return aceEntity.id;
    }

    public static String getTypeSubtype(Annotation annotation) {
        if (entityMentionMap == null) {
            return null;
        }
        Integer n = new Integer(annotation.start());
        Object[] objectArray = (Object[])entityMentionMap.get(n);
        if (objectArray == null) {
            System.out.println("*** No entityMentionMap entry for " + n);
            return "OTHER";
        }
        AceEntity aceEntity = (AceEntity)objectArray[0];
        if (aceEntity.subtype != null && !aceEntity.subtype.equals("")) {
            return aceEntity.type + ":" + aceEntity.subtype;
        }
        return aceEntity.type;
    }

    static String getMentionRole(Annotation annotation) {
        if (entityMentionMap == null) {
            return "GPE";
        }
        Integer n = new Integer(annotation.start());
        Object[] objectArray = (Object[])entityMentionMap.get(n);
        if (objectArray == null) {
            return "GPE";
        }
        AceEntityMention aceEntityMention = (AceEntityMention)objectArray[1];
        return aceEntityMention.role;
    }

    static String getMentionType(Annotation annotation) {
        if (entityMentionMap == null) {
            return "NOMINAL";
        }
        Integer n = new Integer(annotation.start());
        Object[] objectArray = (Object[])entityMentionMap.get(n);
        if (objectArray == null) {
            return "NOMINAL";
        }
        AceEntityMention aceEntityMention = (AceEntityMention)objectArray[1];
        return aceEntityMention.type;
    }
}

