package Jet.Refres;

import java.io.*;
import java.util.*;

import opennlp.maxent.*;
import opennlp.maxent.io.*;

import Jet.Tipster.*;
import Jet.Lisp.*;
import Jet.Console;
import AceJet.*;
import Jet.Parser.StatParser;
import Jet.Parser.SynFun;
import Jet.Parser.AddSyntacticRelations;
import Jet.Lex.Tokenizer;
import AceJet.Gazetteer;

public class RefresBuildTrain {
	
	//  train = true  to write training data
	static boolean train = false;
	//  test = true   to test incrementally, using correct entities
	//  (neither is true when doing normal ref. resolution)
	static boolean test;
	static boolean trace = true;
	static final int testDocs = 25;
	
	static final String home =
	    "C:/Documents and Settings/Ralph Grishman/My Documents/";
	static final String ACEdir = home + "ACE/";
	static final String fileList =
		// ACEdir + "training all.txt";
		// ACEdir + "feb02 all.txt";
		// ACEdir + "sep02 all.txt";
		// ACEdir + "aug03 all.txt";
		// ACEdir + "files-to-process.txt";
		ACEdir + "training nwire.txt";
	static final String parseCollection = ACEdir + "parses/training nwire parses.txt";
	static final String featureFile = home + "jet temp/coref features.txt";
	static final String modelFile = home + "jet temp/coref model.txt";
	static PrintStream writer;
	static final int sharedFeatures = 2;
	
	static GISModel model = null;
	static int correct = 0;
	static int incorrect = 0;
	
	static Vector entities;
	static HashMap headToEntityMap;
	static HashMap syntacticAntecedent;
	static HashMap mentionToEntity;
	
	public static void main (String[] args) throws IOException {
		// turn off trace
		Resolve.trace = false;
		// initialize WordNet
		WordNetInterface.initialize();
		// load ACE type dictionary and gazetteer
		AceJet.EDTtype.readTypeDict();
		AceJet.Ace.gazetteer = new Gazetteer();
		AceJet.Ace.gazetteer.load("C:/Documents and Settings/Ralph Grishman/My Documents/newjet/jet/data/loc.dict");
		if (train) {
			// for training, open stream to hold features
			writer = new PrintStream (new FileOutputStream (featureFile));
		} else {
			// for testing, open model file
			loadModel (modelFile);
		}
		test = !train;
		// open list of files
		BufferedReader reader = new BufferedReader (new FileReader(fileList));
		int docCount = 0;
		String currentDoc;
		while ((currentDoc = reader.readLine()) != null) { 
			// process file 'currentDoc'
			docCount++;
			if ((train && docCount < testDocs) || (!train && docCount >= testDocs)) 
				continue;
			System.out.println ("\nProcessing document " + docCount + ": " + currentDoc);
			String textFileName = ACEdir + currentDoc + ".sgm";
			boolean newData = fileList.indexOf("03") > 0;
			String APFfileName = ACEdir + currentDoc + (newData ? ".apf.xml" : ".sgm.tmx.rdc.xml");
			String parseFileName = ACEdir + "parses/" + currentDoc + ".sgm";
			analyzeDocument (textFileName, APFfileName, parseFileName);
		}
		if (!train) {
			System.out.println (correct + " correct resolutions");
			System.out.println (incorrect + " incorrect resolutions");
		}
	}
	
	private static void analyzeDocument (String textFileName, String APFfileName, 
	    String parseFileName) throws IOException {
	  AceDocument aceDoc = new AceDocument (textFileName, APFfileName);
	  ExternalDocument doc = new ExternalDocument("sgml", parseFileName);
	  // open document
	  doc.setAllTags(true);
		doc.open();
		// mark syntactic relations
		collectSentenceBoundaries(doc);
		for (int i=0; i<sentences.size(); i++) {
			Annotation sentence = (Annotation) sentences.get(i);
			AddSyntacticRelations.annotate(doc, sentence.span());
		}
		// mark inverse relations
		Ace.tagReciprocalRelations(doc);
		// gather mentions in document
		Vector mentions = Resolve.gatherMentions(doc, new Span(0,doc.length()));
		syntacticAntecedent = Resolve.gatherSyntacticCoref (doc, mentions);
		// make map from start of head to mention
		HashMap headToMentionMap = new HashMap();
		for (int i=0; i<mentions.size(); i++) {
			Annotation mention = (Annotation) mentions.get(i);
			Annotation head = Resolve.getHeadC(mention);
			Integer start = new Integer(head.span().start());
			headToMentionMap.put(start, mention);
		}
		// make map from start of head to Ace entity ID
		headToEntityMap = new HashMap();
		ArrayList aceEntities = aceDoc.entities;
		for (int ientity=0; ientity<aceEntities.size(); ientity++) {
			AceEntity entity = (AceEntity) aceEntities.get(ientity);
			ArrayList aceMentions = entity.mentions;
			for (int imention=0; imention<aceMentions.size(); imention++) {
				AceEntityMention aceMention = (AceEntityMention) aceMentions.get(imention);
				Integer aceStart = new Integer(aceMention.head.start());
				headToEntityMap.put(aceStart, entity.id);
			}
		}
		mentionToEntity = new HashMap();
		// initialize entities, which will be built incrementally
		entities = new Vector();
		// loop over document
		// at this position:  is there a mention which is part of an ace entity?
		for (int posn=0; posn<doc.length(); posn++) {
			Integer posnI = new Integer(posn);
			Annotation mention = (Annotation) headToMentionMap.get(posnI);
			String entityID = (String) headToEntityMap.get(posnI);
			if (mention != null && entityID != null) {
				resolveMention (doc, mention, entityID);
			}
		}
	}
	
	public static void references (Document doc, Span span) {
		train = false;
		test = false;
		if (model == null)
			loadModel (modelFile);
		entities = doc.annotationsOfType("entity");
		if (entities == null) entities = new Vector();
		mentionToEntity = new HashMap();
	
		if (trace) Console.println ("Resolving references");
		collectSentenceBoundaries (doc);
		Vector mentions = Resolve.gatherMentions (doc, span);
		syntacticAntecedent = Resolve.gatherSyntacticCoref (doc, mentions); //(doc, span);
		for(int i = 0; i < mentions.size(); i++) {
			Annotation mention = (Annotation) mentions.get(i);
			resolveMention (doc, mention, null);
		}
		Resolve.updateEvents (doc, span);
	}
	
	// features of entity
	//   head (head of first nominal/pronominal mention)
	//   position (start of head of last mention)
	//   number
	//   human (at present from dictionary, later from David)
	//   mentions (ArrayList)
	//   name (from first name mention):  String[]
	//   nameWithMods (noun group including name, from first name mention):  String[]
	//   nameType:  String
	
	private static void resolveMention 
	    (Document doc, Annotation mention, String entityID) {
		// identify type of mention
		Annotation headC = Resolve.getHeadC(mention);
		String cat = (String) headC.get("cat");
		String mentionHead = SynFun.getHead(doc, mention);
		if (mentionHead == null)
			return;
		boolean isNameMention = cat == "name";
		boolean isProMention = cat == "pro" || cat == "det" || cat == "np";
		boolean isNomMention = cat == "n" || cat == "adj" || cat == "ven" ||
		// take 'tv' as incorrectly tagged noun
		                       cat == "tv" || cat == "hyphword";
		boolean dontResolveMention = cat == "$";
		Annotation trueAntecedent = null;
		Annotation predictedAntecedent = null;
		String[] bestFeatures = null;
		String[] trueFeatures = null;
		double bestPAntecedent = 0.;
		double truePAntecedent = 0.;
		
		for (int ientity=0; ientity<entities.size(); ientity++) {
			Annotation entity = (Annotation) entities.get(ientity);
			String[] features = new String[2];
			if (isNameMention) {
				features = nameAnaphoraFeatures(doc, mention, entity);
			} else if (isNomMention) {
				features = nominalAnaphoraFeatures(doc, mention, entity);
			} else if (isProMention) {
				features = pronounAnaphoraFeatures(doc, mention, entity);
			} else if (dontResolveMention) {
				if (!test) continue;
			} else {
				System.out.println ("***RefresBuildTrain:  unexpected mention category: " + cat +
				                    " for " + doc.text(mention));
				if (!test) continue;
			}
		
		// for every entity,
		//   compute general features
		//     is it a syntactically-determined antecedent
			Annotation antecedent = (Annotation) syntacticAntecedent.get(mention);
			boolean syntacticAntecedent = 
			    antecedent != null &&
			    ((Vector)entity.get("mentions")).contains(antecedent);
			features[features.length-2] = "syntax=" + syntacticAntecedent;
		//     do the contexts of anaphor and antecedent match?
			String anaphorContext = context(mention);
			ArrayList priorContexts = (ArrayList) entity.get("contexts");
			boolean contextMatch = matchingContext(anaphorContext, priorContexts);
			features[features.length-1] = "context=" + tf(contextMatch);
		//				
		//    to do:  number/density of prior mentions 
		// 
		//    output features and result(+/-)
			boolean result = (train | test ) && entityID.equals(entity.get("aceID"));
			if (result)
					trueAntecedent = entity;
			if (train) {
				for (int ifeat=0; ifeat<features.length; ifeat++) {
					writer.print (features[ifeat] + " ");
				}
				writer.println (tf(result));
			} else {
				int trueIndex = model.getIndex("t");
				double pAntecedent = model.eval(features)[trueIndex];
				if (pAntecedent > 0.10 && pAntecedent > bestPAntecedent) {
					predictedAntecedent = entity;
					bestFeatures = features;
					bestPAntecedent = pAntecedent;
				}
				if (result) {
					trueFeatures = features;
					truePAntecedent = pAntecedent;
				}
			}
		}
		
		// create new entity or add mention to entity
		if (train | test) {
			if (trueAntecedent != null) {
				addMentionToEntity (doc, mention, trueAntecedent);
			} else {
				createEntity (doc, mention, entityID);
			}
		} else {
			if (predictedAntecedent != null) {
				addMentionToEntity (doc, mention, predictedAntecedent);
			} else {
				createEntity (doc, mention, entityID);
			}
		}
		mention.put("mention", "true");
		
		if (test) {
			if (trueAntecedent == predictedAntecedent) {
				correct++;
				// System.out.println ("\nCorrectly resolved " + doc.text(mention));
			} else {
				incorrect++;
				System.out.println ("\nError resolving " + doc.text(mention));
				System.out.println ("  Anaphor: " + mention);
				if (trueAntecedent != null)
					System.out.println ("  True antecedent: " + doc.text(trueAntecedent));
				System.out.println ("  True antecedent: " + trueAntecedent);
				if (trueFeatures != null) {
					System.out.print("  True antecedent features: \n    ");
					for (int ifeat=0; ifeat<trueFeatures.length; ifeat++) {
						System.out.print(trueFeatures[ifeat] + " ");
					}
					System.out.println(truePAntecedent);
				}
				if (predictedAntecedent != null)
					System.out.println ("  Predicted antecedent: " + doc.text(predictedAntecedent));
				System.out.println ("  Predicted antecedent: " + predictedAntecedent);
				if (bestFeatures != null) {
					System.out.print("  Predicted antecedent features: \n    ");
					for (int ifeat=0; ifeat<bestFeatures.length; ifeat++) {
						System.out.print(bestFeatures[ifeat] + " ");
					}
					System.out.println(bestPAntecedent);
				}
			}
		}
	}
	
	private static String tf (boolean b) {
		return b ? "t" : "f";
	}
	
	private static void addMentionToEntity (Document doc, Annotation mention, Annotation antecedent) {
		Vector mentions = (Vector) antecedent.get("mentions");
		mentions.add(mention);
		mentionToEntity.put(mention, antecedent);
		String mentionHead = nominativeFormOf(SynFun.getHead(doc, mention));
		String[] mentionName = Resolve.getNameTokens (doc, mention);
		// for named mention:  set name, nameWithMods, nameType fields
		if (mentionName != null) {
			if (antecedent.get("name") == null) {
				// second arg should indicate if mention is an adjective
				mentionName = Resolve.normalizeGazName(mentionName, false, Resolve.trace);
				Annotation ngHead = Resolve.getNgHead(mention);
				String[] mentionTokens = Tokenizer.gatherTokenStrings(doc, ngHead.span());
				antecedent.put("name", mentionName);
				antecedent.put("nameWithMods", mentionTokens);
				antecedent.put("nameType", mentionHead);
			}
		} else {
			// for nominal/pronominal mention:  set head field
			if (antecedent.get("head") == null) {
				antecedent.put("head", mentionHead);
			}
		}
		String context = context(mention);
		if (context != null) {
			ArrayList priorContexts = (ArrayList) antecedent.get("contexts");
			if (priorContexts == null) {
				priorContexts = new ArrayList();
				antecedent.put("contexts", priorContexts);
			}
			priorContexts.add(context);
		}
	}
	
	private static void createEntity (Document doc, Annotation mention, String entityID) {
		// create entity
		Span span = mention.span();
		Annotation entity = new Annotation ("entity", span, new FeatureSet());
		doc.addAnnotation (entity);
		// create mention Vector in entity
		Vector mentions = new Vector();
		entity.put("mentions", mentions);
		// get information about mention
		String mentionHead = nominativeFormOf(SynFun.getHead(doc, mention));
		String mentionNumber = SynFun.getNumber(mention);
		if (mentionNumber == null)
			if (in(mentionHead,pluralPronouns))
				mentionNumber = "plural";
			else
				mentionNumber = "singular";
		boolean isHumanMention = SynFun.getHuman(mention) || mentionHead == "person"
		                         || in(mentionHead,humanPronouns);
		// add this information to entity
		addMentionToEntity (doc, mention, entity);
		if (isHumanMention)
			entity.put("human", "true");
		entity.put("number", mentionNumber);
		entity.put("aceID", entityID);
		// add entity to entity set
		entities.add(entity);
	}

	//  ------------- n a m e s ------------------
	
	private static String[] nameAnaphoraFeatures (
		  Document doc, Annotation anaphor, Annotation antecedent) {
		//        anaphor is a mention;  antecedent is an entity
		String[] features = new String[5+sharedFeatures];
		//  FEATURES GENERATED
		//        distance (sentences)
		//        exactNameMatch
		//        substringNameMatch
		//        acronymMatch
		//        abbreviationMatch
		//  ---- (to do)
		//        title matching prior nominal head ...
		String[] anaphorName = Resolve.getNameTokens (doc, anaphor);
		if (anaphorName != null)
		  // second arg should indicate if anaphor is an adjective
			anaphorName = Resolve.normalizeGazName(anaphorName, false, Resolve.trace);
		String anaphorNameType = (String) SynFun.getHead(doc, anaphor);
		String[] antecedentName = (String[]) antecedent.get("name");
		String antecedentNameType = (String) antecedent.get("nameType");
		//     distance
		int distance = sentencesBetween(antecedent, anaphor);
		distance = Math.min(distance, 10);
		features[0] = "dist=" + distance;  
		//     exact name match
		boolean exactNameMatch = antecedentName != null &&
		                         Resolve.matchFullName(anaphorName, anaphorNameType, antecedentName, antecedentNameType) == 0;
		features[1] = "exactName=" + tf(exactNameMatch);
		//     substring name match
		boolean substringNameMatch = antecedentName != null &&
		                         Resolve.matchFullName(anaphorName, anaphorNameType, antecedentName, antecedentNameType) > 0;
		features[2] = "substringName=" + tf(substringNameMatch);
		//     acronym match
		boolean acronymMatch = antecedentName != null &&
		                       anaphorName.length == 1 &&
		                       Resolve.isAcronym(antecedentName,anaphorName[0]) >= 0;
		// features[3] = "acronym=" + tf(acronymMatch);
		//     abbreviationMatch
		boolean abbreviationMatch = antecedentName != null &&
		                       anaphorName.length == 1 &&
		                       Resolve.isAbbreviation(antecedentName,anaphorName[0]) >= 0;
		features[3] = "abbrev=" + tf(acronymMatch | abbreviationMatch);
		//     reverse acronym / abbreviation match
		boolean revAcronymMatch = antecedentName != null &&
		                       antecedentName.length == 1 &&
		                       Resolve.isAcronym(anaphorName,antecedentName[0]) >= 0;
		boolean revAbbreviationMatch = antecedentName != null &&
		                       antecedentName.length == 1 &&
		                       Resolve.isAbbreviation(anaphorName,antecedentName[0]) >= 0;
		features[4] = "revAbbrev=" + tf(revAcronymMatch | revAbbreviationMatch);
		//     need to also allow nominal antecedents
		//        EDT type match
		//        distance (order among antecedents of proper type)
		return features;
	}
	
	private static final String[] indefiniteDets =
		{"few", "afew", "more", "many", "most", "some", "any", "several", "less",
		 "neither", "another", "such", "no", "either"};
	
		//  ------------- n o m i n a l s ------------------

	private static String[] nominalAnaphoraFeatures (
		  Document doc, Annotation anaphor, Annotation antecedent) {
		String[] features = new String[6+sharedFeatures];    
		//   FEATURES GENERATED
		//     		distance (in sentences)
		//        anaphor det
		//        number agreement
		//        head match
		//   --------
		//        distance (order among antecedents of proper type)
		
		//     		distance (in sentences)
		int distance = sentencesBetween(antecedent, anaphor);
		distance = Math.min(distance, 10);
		features[0] = "dist=" + distance;
		//        anaphor det
		String anaphorDet = SynFun.getDet(anaphor);
		if (in(anaphorDet, indefiniteDets)) {
			features[1] = "det=indef";
		} else {
			features[1] = "det=" + anaphorDet;
		}
		//        number agreement
		String anaphorNumber = SynFun.getNumber(anaphor);
		if (anaphorNumber == null)
			anaphorNumber = "singular";
		String antecedentNumber = (String) antecedent.get("number");
		boolean numberAgreement = anaphorNumber.equals(antecedentNumber);
		features[2] = "numberAgr=" + tf(numberAgreement);
		//        head agreement
		String anaphorHead = SynFun.getHead(doc, anaphor);
		String antecedentHead = (String) antecedent.get("head");
		boolean headAgreement = anaphorHead.equals(antecedentHead);
		boolean leftModifierAgreement = headAgreement && compatibleLeftMods(doc, anaphor, antecedent);
		if (leftModifierAgreement) {
			features[3] = "agr=total";
		} else if (headAgreement) {
			features[3] = "agr=head";
		} else {
			features[3] = "agr=none";
		}
		//        nameType:head pair
		String antecedentNameType = (String) antecedent.get("nameType");
		if (antecedentNameType != null) {
			features[4] = "heads=" + antecedentNameType + ":" + anaphorHead;
		} else {
			features[4] = "";
		}
		//        modifier overlap
		//        exact match
		//        nom - name agreement
		boolean nameNomCoref = nameNomCoref(doc, anaphor, antecedent);
		if (nameNomCoref) {
			System.out.println ("Name-nom coref");
			System.out.println ("  Anaphor = " + doc.text(anaphor));
			System.out.println ("  Antecedent = " + doc.text(antecedent));
		}
		features[5] = "nameNom=" + tf(nameNomCoref);
		//        current refres test
		//
		return features;
	}
	
	/**
	 *  detects a nominal which refers back to a name ... all tokens of the
	 *  name except "the" must also appear as part of the nameWithMods.
	 */
	 
	public static boolean nameNomCoref 
			(Document doc, Annotation mention, Annotation entity) {
		String[] entityNameWithMods = (String[]) entity.get("nameWithMods");
		if (entityNameWithMods == null) return false;
		String[] mentionTokens = Tokenizer.gatherTokenStrings(doc, mention.span());
		for (int i=0; i<mentionTokens.length; i++) {
			if (mentionTokens[i].equalsIgnoreCase("the")) continue;
			boolean match = false;
			for (int j=0; j<entityNameWithMods.length; j++) {
				if (mentionTokens[i].equalsIgnoreCase(entityNameWithMods[j])) {
					match = true;
					break;
				}
			}
			if (!match) return false;
		}
		return true;			
	}
	
	//  ------------- p r o n o u n s ------------------
	
	// pronouns which definitely have a given property
	private static String[] singularPronouns = {"I", "he", "she", "it"};
	private static String[] pluralPronouns = {"we", "they"};
	private static String[] humanPronouns = {"I", "you", "he", "she", "we"};
	private static String[] nonHumanPronouns = {"it"};
	private static String[] firstSecondPronouns = {"I", "we", "you"};
	private static String[] thirdPronouns = {"he", "she", "it", "they"};
	
	private static String[] pronounAnaphoraFeatures (
		  Document doc, Annotation anaphor, Annotation antecedent) {
		//        anaphor is a mention;  antecedent is an entity
		//  FEATURES GENERATED
		//        hobbsDistance (max 10)
		//        numberAgreement
		//        humanAgreement
		//        personAgreement
		//  ---- (to do)
		//        reflexive...
		String[] features = new String[5+sharedFeatures];
		//        get head (normalized) of anaphor
		String anaphorHead = SynFun.getHead(doc, anaphor);
		String nominativeForm = nominativeFormOf(anaphorHead);
		//        Hobbs distance
		Vector antecedentMentions = (Vector) antecedent.get("mentions");
		Annotation lastMention = (Annotation) antecedentMentions.get(antecedentMentions.size()-1);
		int hobbsDistance = Hobbs.distance(lastMention, anaphor, sentences);
		hobbsDistance = Math.min(hobbsDistance, 10);
		features[0] = "hobbs=" + hobbsDistance;
		//        number agreement:  true unless explicit conflict
		String antecedentNumber = (String) antecedent.get("number");
		boolean numberAgreement = true;
		if ((in(nominativeForm,singularPronouns) && antecedentNumber == "plural") ||
			  (in(nominativeForm,pluralPronouns) && antecedentNumber == "singular"))
			numberAgreement = false;
		features[1] = "proNumberAgr=" + tf(numberAgreement);
		//        human feature agreement
		boolean antecedentHuman = antecedent.get("human") != null;
		boolean humanAgreement = true;
		if (in(nominativeForm,humanPronouns) && !antecedentHuman)
			humanAgreement = false;
		if (in(nominativeForm,nonHumanPronouns) && antecedentHuman)
			humanAgreement = false;
		features[2] = "humanAgr=" + tf(humanAgreement);
		//        person agreement (incl. number for first person)
		boolean personAgreement;
		String antecedentHead = (String) antecedent.get("head");
		if (in(nominativeForm,firstSecondPronouns))
			personAgreement = nominativeForm.equals(antecedentHead);
		else if (in(nominativeForm,thirdPronouns))
		  personAgreement = !in(antecedentHead,firstSecondPronouns);
		else
			personAgreement = false;
		features[3] = "personAgr=" + tf(personAgreement);
		//        the pronoun itself (in nominative form)
		features[4] = "pro=" + nominativeForm;
		return features;
	}
	
	// ============== copied from Resolve ======================
		
	static private HashMap nominative = new HashMap();
	static {nominative.put("me", "I");
	        nominative.put("my", "I");
	        nominative.put("myself", "I");
	        nominative.put("your", "you");
	        nominative.put("yourself", "you");
	        nominative.put("him", "he");
	        nominative.put("his", "he");
	        nominative.put("himself", "he");
	        nominative.put("her", "she");
	        nominative.put("hers", "she");
	        nominative.put("herself", "she");
	        nominative.put("its", "it");
	        nominative.put("itself", "it");
	        nominative.put("us", "we");
	        nominative.put("our", "we");
	        nominative.put("ourselves", "we");
	        nominative.put("them", "they");
	        nominative.put("their", "they");
	        nominative.put("themselves", "they");
	     }
	 
	 /**
	  *  returns the nominative form of 'pronoun'.
	  */
	  
	private static String nominativeFormOf (String pronoun) {
	 	if (nominative.containsKey(pronoun))
			return (String) nominative.get(pronoun);
		else
			return pronoun;
	}
		
	public static boolean in (Object o, Object[] array) {
		for (int i=0; i<array.length; i++)
			// if (array[i] == o) return true;
			if (array[i] != null && array[i].equals(o)) return true;
		return false;
	}
	
	private static int[] sentenceBoundaries;
	private static Vector sentences;
	
	private static void collectSentenceBoundaries (Document doc) {
		sentences = doc.annotationsOfType("sentence");
		sentenceBoundaries = new int[sentences.size()];
		for (int i=0; i<sentences.size(); i++)
			sentenceBoundaries[i] = ((Annotation) sentences.get(i)).span().start();
	}
	
	/*
	 *  returns the number of sentence boundaries between two positions
	 *  in the document, 'posn1' and 'posn2'.
	 */
	 
	private static int sentencesBetween (int posn1, int posn2) {
		int count = 0;
		for (int i=0; i<sentenceBoundaries.length; i++)
			if (posn1 < sentenceBoundaries[i] && sentenceBoundaries[i] <= posn2)
				count++;
		return count;
	}
	
	private static int sentencesBetween (Annotation a1, Annotation a2) {
		return sentencesBetween (a1.span().start(), a2.span().start());
	}
	
	private static void loadModel (String modelFileName) {		
		try {
		    model = new SuffixSensitiveGISModelReader(new File(modelFileName)).getModel();
		    System.out.println ("GIS model loaded.");
		} catch (Exception e) {
		    e.printStackTrace();
		    System.exit(0);
		}
	}
	
	private static String[] getLeftModifierTokens (Document doc, Annotation mention) {
		// we collect all tokens in the noun group preceeding the head
		// except for determiners ...
		Annotation ngHead = Resolve.getNgHead(mention);
		int start = ngHead.start();
		Annotation headC = Resolve.getHeadC(mention);
		int end = headC.start();
		Annotation[] children = StatParser.children(ngHead);
		if (children != null && children.length >= 2) {
			Annotation firstChild = children[0];
			String det = doc.text(firstChild).trim().toLowerCase().intern();
			if (Resolve.in(det,AddSyntacticRelations.comlexDeterminers)) {
				start = firstChild.end();
			}
		}
		String[] tokens = Tokenizer.gatherTokenStrings(doc, new Span(start, end));
		for (int i=0; i<tokens.length; i++) 
		  tokens[i] = tokens[i].toLowerCase();
		return tokens;
	}
	
	private static boolean compatibleLeftMods (Document doc, Annotation anaphor, Annotation antecedent) {
		String[] anaphorLeftModifiers = getLeftModifierTokens(doc, anaphor);
		// find first nominal mention, if any
		Vector mentions = (Vector) antecedent.get("mentions");
		Annotation mention = null;
		for (int i=0; i<mentions.size(); i++) {
			Annotation m = (Annotation) mentions.get(i);
			if (isNominalMention(m)) {
				mention = m;
				break;
			}
		}
		if (mention == null) return false;
		String[] antecedentLeftModifiers = getLeftModifierTokens(doc, mention);
		boolean leftModifierCompatibility = 
			Resolve.intersect(anaphorLeftModifiers, antecedentLeftModifiers);
		if (leftModifierCompatibility) {
			// System.out.println (">>Full match of " + doc.text(anaphor) + " and " + doc.text(mention));
		} else {
			// System.out.println (">>Head match of " + doc.text(anaphor) + " and " + doc.text(mention));
		}
		return leftModifierCompatibility;
	}
	
	private static boolean isNominalMention (Annotation mention) {
		Annotation headC = Resolve.getHeadC(mention);
		String cat = (String) headC.get("cat");
		return cat == "n";
	}
	
	private static String context (Annotation mention) {
		Annotation headC = null;
		String relation = null;
		String head = null;
		if (mention.get("subject-1") != null) {
			headC = (Annotation) mention.get("subject-1");
			relation = "subject";
		} else if (mention.get("object-1") != null) {
			headC = (Annotation) mention.get("object-1");
			relation = "object";
		}
		if (headC != null) {
			head = SynFun.getImmediateHead(headC);
		}
		if (head != null && !(head.equals("be"))) {
			String context = relation + ":" + head;
			return context;
		} else {
			return null;
		}
	}
	
	public static boolean matchingContext (String anaphorContext, ArrayList priorContexts) {
		if (anaphorContext == null) return false;
		if (priorContexts == null) return false;
		for (int i=0; i<priorContexts.size(); i++) {
			String priorContext = (String) priorContexts.get(i);
			if (matchingContext(anaphorContext, priorContext)) return true;
		}
		return false;
	}
	
	private static boolean matchingContext (String anaphorContext, String priorContext) {
		// return false; /*
		// return anaphorContext.equals(priorContext); /*
		int p1 = anaphorContext.indexOf(':');
		int p2 = priorContext.indexOf(':');
		String relation1 = anaphorContext.substring(0,p1);
		String relation2 = priorContext.substring(0,p2);
		if (!	relation1.equals(relation2)) return false;
		String anaphorHead = anaphorContext.substring(p1+1);
		String antecedentHead = priorContext.substring(p2+1);
		boolean match = WordNetInterface.isVerbSynonym(anaphorHead, antecedentHead);
		if (match) System.out.println ("*****Matching contexts " + priorContext + " and " + anaphorContext);
		return match; 
	}
	
}