/*
 * Decompiled with CFR 0.152.
 */
package org.ho.yaml;

import java.beans.PropertyDescriptor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.ho.util.BiDirectionalMap;
import org.ho.util.DateTimeParser;
import org.ho.yaml.ReflectionUtil;
import org.ho.yaml.Utilities;
import org.ho.yaml.YamlDecoder;
import org.ho.yaml.YamlEncoder;
import org.ho.yaml.YamlOperations;
import org.ho.yaml.YamlStream;
import org.ho.yaml.exception.YamlException;
import org.ho.yaml.wrapper.ArrayWrapper;
import org.ho.yaml.wrapper.ClassWrapper;
import org.ho.yaml.wrapper.ColorWrapper;
import org.ho.yaml.wrapper.DateWrapper;
import org.ho.yaml.wrapper.DefaultBeanWrapper;
import org.ho.yaml.wrapper.DefaultCollectionWrapper;
import org.ho.yaml.wrapper.DefaultMapWrapper;
import org.ho.yaml.wrapper.DefaultSimpleTypeWrapper;
import org.ho.yaml.wrapper.DimensionWrapper;
import org.ho.yaml.wrapper.EnumWrapper;
import org.ho.yaml.wrapper.ObjectWrapper;
import org.ho.yaml.wrapper.OneArgConstructorTypeWrapper;
import org.ho.yaml.wrapper.PointWrapper;
import org.ho.yaml.wrapper.SimpleObjectWrapper;
import org.ho.yaml.wrapper.WrapperFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YamlConfig
implements YamlOperations,
Cloneable {
    private static YamlConfig defaultConfig;
    public static final String CONSTRUCTOR_SCOPE = "constructor";
    public static final String FIELD_SCOPE = "field";
    public static final String PROPERTY_SCOPE = "property";
    public static final String PRIVATE = "private";
    public static final String DEFAULT = "default";
    public static final String PROTECTED = "protected";
    public static final String PUBLIC = "public";
    String indentAmount = "  ";
    boolean minimalOutput = false;
    boolean suppressWarnings = false;
    BiDirectionalMap<String, String> transfers = null;
    private String dateFormat = null;
    private DateFormat dateFormatter = null;
    Map<String, String> decodingAccessScope = new HashMap<String, String>();
    Map<String, String> encodingAccessScope = new HashMap<String, String>();
    Map<String, Object> handlers = new HashMap<String, Object>();
    String encoding = "UTF-8";

    public YamlConfig() {
        this.installDefaultHandlers();
        this.installDefaultAccessScopes();
    }

    public static YamlConfig getDefaultConfig() {
        return (YamlConfig)defaultConfig.clone();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public String getIndentAmount() {
        return this.indentAmount;
    }

    public void setIndentAmount(String string) {
        this.indentAmount = string;
    }

    public boolean isMinimalOutput() {
        return this.minimalOutput;
    }

    public void setMinimalOutput(boolean bl) {
        this.minimalOutput = bl;
    }

    public boolean isSuppressWarnings() {
        return this.suppressWarnings;
    }

    public void setSuppressWarnings(boolean bl) {
        this.suppressWarnings = bl;
    }

    public BiDirectionalMap<String, String> getTransfers() {
        return this.transfers;
    }

    public void setTransfers(BiDirectionalMap<String, String> biDirectionalMap) {
        this.transfers = biDirectionalMap;
    }

    public Map<String, Object> getHandlers() {
        return this.handlers;
    }

    public void setHandlers(Map<String, Object> map) {
        this.handlers = map;
        this.installDefaultHandlers();
    }

    void installDefaultHandlers() {
        this.install("java.awt.Dimension", DimensionWrapper.class.getName());
        this.install("java.awt.Point", PointWrapper.class.getName());
        this.install("java.awt.Color", ColorWrapper.class.getName());
        this.install("java.lang.Class", ClassWrapper.class.getName());
        this.install("java.math.BigInteger", new OneArgConstructorTypeWrapper(BigInteger.class, String.class.getName()));
        this.install("java.math.BigDecimal", new OneArgConstructorTypeWrapper(BigDecimal.class, String.class.getName()));
        this.install(File.class.getName(), new OneArgConstructorTypeWrapper(File.class, String.class.getName()));
        this.install(Date.class.getName(), new DateWrapper());
    }

    void installDefaultAccessScopes() {
        this.decodingAccessScope.put(FIELD_SCOPE, PUBLIC);
        this.decodingAccessScope.put(PROPERTY_SCOPE, PUBLIC);
        this.decodingAccessScope.put(CONSTRUCTOR_SCOPE, PUBLIC);
        this.encodingAccessScope.put(FIELD_SCOPE, PUBLIC);
        this.encodingAccessScope.put(PROPERTY_SCOPE, PUBLIC);
    }

    void install(String string, Object object) {
        if (object instanceof ObjectWrapper) {
            ((ObjectWrapper)object).setYamlConfig(this);
        }
        if (!this.handlers.containsKey(string)) {
            this.handlers.put(string, object);
        }
    }

    String transfer2classname(String string) {
        if (this.transfers != null && this.transfers.containsKey(string)) {
            return (String)this.transfers.get(string);
        }
        return string;
    }

    String classname2transfer(String string) {
        if (this.transfers != null && this.transfers.getReverse().containsKey(string)) {
            return this.transfers.getReverse().get(string);
        }
        return string;
    }

    public ObjectWrapper getWrapper(Object object) {
        ObjectWrapper objectWrapper = this.getWrapper(object.getClass());
        objectWrapper.setObject(object);
        return objectWrapper;
    }

    public ObjectWrapper getWrapper(Class clazz) {
        return this.getWrapper(ReflectionUtil.className(clazz));
    }

    ObjectWrapper initWrapper(String string, Class clazz) {
        Object object = this.handlers.get(string);
        if (object instanceof String) {
            try {
                return (ObjectWrapper)ReflectionUtil.classForName((String)object).getConstructor(Class.class).newInstance(clazz);
            }
            catch (Exception exception) {
                throw new YamlException("Error initializing Wrapper " + object + " for type " + clazz, exception);
            }
        }
        if (object instanceof WrapperFactory) {
            return ((WrapperFactory)object).makeWrapper();
        }
        return null;
    }

    public ObjectWrapper getWrapper(String string) {
        ObjectWrapper objectWrapper;
        Class clazz = ReflectionUtil.classForName(this.transfer2classname(string));
        if (clazz == null) {
            return null;
        }
        if (this.handlers != null && this.handlers.containsKey(string)) {
            objectWrapper = this.initWrapper(string, clazz);
        } else if (Map.class.isAssignableFrom(clazz)) {
            objectWrapper = new DefaultMapWrapper(clazz);
        } else if (Collection.class.isAssignableFrom(clazz)) {
            objectWrapper = new DefaultCollectionWrapper(clazz);
        } else if (clazz.isArray()) {
            objectWrapper = new ArrayWrapper(clazz);
        } else {
            if (ReflectionUtil.isSimpleType(clazz)) {
                return new DefaultSimpleTypeWrapper(clazz);
            }
            objectWrapper = clazz.isEnum() ? new EnumWrapper(clazz) : new DefaultBeanWrapper(clazz);
        }
        objectWrapper.setYamlConfig(this);
        return objectWrapper;
    }

    public ObjectWrapper getWrapperSetContent(String string, String string2) {
        SimpleObjectWrapper simpleObjectWrapper;
        Class clazz = ReflectionUtil.classForName(this.transfer2classname(string));
        if (this.handlers != null && this.handlers.containsKey(string)) {
            simpleObjectWrapper = (SimpleObjectWrapper)this.initWrapper(string, clazz);
            simpleObjectWrapper.setObject(Utilities.convertType(string2, simpleObjectWrapper.expectedArgType()));
        } else if (clazz != null && clazz.isEnum()) {
            simpleObjectWrapper = new EnumWrapper(clazz);
            simpleObjectWrapper.setObject(Utilities.convertType(string2, simpleObjectWrapper.expectedArgType()));
        } else {
            simpleObjectWrapper = new DefaultSimpleTypeWrapper(clazz);
            simpleObjectWrapper.setObject(Utilities.convertType(string2, simpleObjectWrapper.expectedArgType()));
        }
        simpleObjectWrapper.setYamlConfig(this);
        return simpleObjectWrapper;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error();
        }
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String string) {
        this.dateFormat = string;
        this.dateFormatter = null;
    }

    public DateFormat getDateFormatter() {
        if (this.dateFormatter == null && this.dateFormat != null) {
            this.dateFormatter = new DateTimeParser(this.dateFormat);
        }
        return this.dateFormatter;
    }

    public static YamlConfig fromFile(String string) throws FileNotFoundException, EOFException {
        YamlDecoder yamlDecoder = new YamlDecoder(new FileInputStream(string), new YamlConfig());
        YamlConfig yamlConfig = yamlDecoder.readObjectOfType(YamlConfig.class);
        yamlDecoder.close();
        return yamlConfig;
    }

    public static YamlConfig fromResource(String string) throws EOFException {
        YamlDecoder yamlDecoder = new YamlDecoder(YamlConfig.class.getClassLoader().getResourceAsStream(string), new YamlConfig());
        YamlConfig yamlConfig = yamlDecoder.readObjectOfType(YamlConfig.class);
        yamlDecoder.close();
        return yamlConfig;
    }

    public Object load(YamlDecoder yamlDecoder) {
        yamlDecoder.setConfig(this);
        Object object = null;
        try {
            object = yamlDecoder.readObject();
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return object;
    }

    @Override
    public Object load(InputStream inputStream) {
        return this.load(new YamlDecoder(inputStream, this));
    }

    @Override
    public Object load(Reader reader) {
        return this.load(new YamlDecoder(reader, this));
    }

    @Override
    public Object load(File file) throws FileNotFoundException {
        return this.load(new YamlDecoder(new FileInputStream(file), this));
    }

    @Override
    public Object load(String string) {
        return this.load(new ByteArrayInputStream(string.getBytes()));
    }

    public <T> T loadType(YamlDecoder yamlDecoder, Class<T> clazz) {
        yamlDecoder.setConfig(this);
        T t = null;
        try {
            t = yamlDecoder.readObjectOfType(clazz);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return t;
    }

    @Override
    public <T> T loadType(InputStream inputStream, Class<T> clazz) {
        return this.loadType(new YamlDecoder(inputStream, this), clazz);
    }

    @Override
    public <T> T loadType(Reader reader, Class<T> clazz) {
        return this.loadType(new YamlDecoder(reader, this), clazz);
    }

    @Override
    public <T> T loadType(File file, Class<T> clazz) throws FileNotFoundException {
        return this.loadType(new YamlDecoder(new FileInputStream(file), this), clazz);
    }

    @Override
    public <T> T loadType(String string, Class<T> clazz) {
        return this.loadType(new ByteArrayInputStream(string.getBytes()), clazz);
    }

    public YamlStream loadStream(YamlDecoder yamlDecoder) {
        yamlDecoder.setConfig(this);
        return yamlDecoder.asStream();
    }

    @Override
    public YamlStream loadStream(Reader reader) {
        return this.loadStream(new YamlDecoder(reader, this));
    }

    @Override
    public YamlStream loadStream(InputStream inputStream) {
        return this.loadStream(new YamlDecoder(inputStream, this));
    }

    @Override
    public YamlStream loadStream(File file) throws FileNotFoundException {
        return this.loadStream(new YamlDecoder(new FileInputStream(file), this));
    }

    @Override
    public YamlStream loadStream(String string) {
        return this.loadStream(new ByteArrayInputStream(string.getBytes()));
    }

    public <T> YamlStream<T> loadStreamOfType(YamlDecoder yamlDecoder, Class<T> clazz) {
        yamlDecoder.setConfig(this);
        return yamlDecoder.asStreamOfType(clazz);
    }

    @Override
    public <T> YamlStream<T> loadStreamOfType(Reader reader, Class<T> clazz) {
        return this.loadStreamOfType(new YamlDecoder(reader, this), clazz);
    }

    @Override
    public <T> YamlStream<T> loadStreamOfType(InputStream inputStream, Class<T> clazz) {
        return this.loadStreamOfType(new YamlDecoder(inputStream, this), clazz);
    }

    @Override
    public <T> YamlStream<T> loadStreamOfType(File file, Class<T> clazz) throws FileNotFoundException {
        return this.loadStreamOfType(new YamlDecoder(new FileInputStream(file), this), clazz);
    }

    @Override
    public <T> YamlStream<T> loadStreamOfType(String string, Class<T> clazz) {
        return this.loadStreamOfType(new ByteArrayInputStream(string.getBytes()), clazz);
    }

    @Override
    public void dump(Object object, File file) throws FileNotFoundException {
        YamlEncoder yamlEncoder = new YamlEncoder(new FileOutputStream(file), this);
        yamlEncoder.setConfig(this);
        yamlEncoder.writeObject(object);
        yamlEncoder.close();
    }

    @Override
    public void dump(Object object, File file, boolean bl) throws FileNotFoundException {
        YamlEncoder yamlEncoder = new YamlEncoder(new FileOutputStream(file), this);
        yamlEncoder.setConfig(this);
        yamlEncoder.setMinimalOutput(bl);
        yamlEncoder.writeObject(object);
        yamlEncoder.close();
    }

    @Override
    public void dumpStream(Iterator iterator, File file, boolean bl) throws FileNotFoundException {
        YamlEncoder yamlEncoder = new YamlEncoder(new FileOutputStream(file), this);
        yamlEncoder.setConfig(this);
        yamlEncoder.setMinimalOutput(bl);
        while (iterator.hasNext()) {
            yamlEncoder.writeObject(iterator.next());
        }
        yamlEncoder.close();
    }

    @Override
    public void dumpStream(Iterator iterator, File file) throws FileNotFoundException {
        YamlEncoder yamlEncoder = new YamlEncoder(new FileOutputStream(file), this);
        yamlEncoder.setConfig(this);
        while (iterator.hasNext()) {
            yamlEncoder.writeObject(iterator.next());
        }
        yamlEncoder.close();
    }

    @Override
    public String dump(Object object) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        YamlEncoder yamlEncoder = new YamlEncoder(byteArrayOutputStream, this);
        yamlEncoder.setConfig(this);
        yamlEncoder.writeObject(object);
        yamlEncoder.close();
        return new String(byteArrayOutputStream.toByteArray());
    }

    @Override
    public String dump(Object object, boolean bl) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        YamlEncoder yamlEncoder = new YamlEncoder(byteArrayOutputStream, this);
        yamlEncoder.setConfig(this);
        yamlEncoder.setMinimalOutput(bl);
        yamlEncoder.writeObject(object);
        yamlEncoder.close();
        return new String(byteArrayOutputStream.toByteArray());
    }

    @Override
    public String dumpStream(Iterator iterator) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        YamlEncoder yamlEncoder = new YamlEncoder(byteArrayOutputStream, this);
        yamlEncoder.setConfig(this);
        while (iterator.hasNext()) {
            yamlEncoder.writeObject(iterator.next());
        }
        yamlEncoder.close();
        return new String(byteArrayOutputStream.toByteArray());
    }

    @Override
    public String dumpStream(Iterator iterator, boolean bl) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        YamlEncoder yamlEncoder = new YamlEncoder(byteArrayOutputStream, this);
        yamlEncoder.setConfig(this);
        yamlEncoder.setMinimalOutput(bl);
        while (iterator.hasNext()) {
            yamlEncoder.writeObject(iterator.next());
        }
        yamlEncoder.close();
        return new String(byteArrayOutputStream.toByteArray());
    }

    public Map<String, String> getDecodingAccessScope() {
        return this.decodingAccessScope;
    }

    public void setDecodingAccessScope(Map<String, String> map) {
        this.decodingAccessScope = map;
    }

    public Map<String, String> getEncodingAccessScope() {
        return this.encodingAccessScope;
    }

    public void setEncodingAccessScope(Map<String, String> map) {
        this.encodingAccessScope = map;
    }

    public boolean isFieldAccessibleForDecoding(Field field) {
        return ReflectionUtil.isMemberField(field) && this.isWithin(field.getModifiers(), this.decodingAccessScope.get(FIELD_SCOPE));
    }

    public boolean isFieldAccessibleForEncoding(Field field) {
        return ReflectionUtil.isMemberField(field) && this.isWithin(field.getModifiers(), this.encodingAccessScope.get(FIELD_SCOPE));
    }

    public boolean isConstructorAccessibleForDecoding(Class clazz) {
        try {
            Constructor constructor = clazz.getDeclaredConstructor(null);
            return this.isWithin(constructor.getModifiers(), this.decodingAccessScope.get(CONSTRUCTOR_SCOPE));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isPropertyAccessibleForDecoding(PropertyDescriptor propertyDescriptor) {
        return this.isWithin(propertyDescriptor.getWriteMethod().getModifiers(), this.decodingAccessScope.get(PROPERTY_SCOPE));
    }

    public boolean isPropertyAccessibleForEncoding(PropertyDescriptor propertyDescriptor) {
        return this.isWithin(propertyDescriptor.getReadMethod().getModifiers(), this.encodingAccessScope.get(PROPERTY_SCOPE));
    }

    boolean isWithin(int n, String string) {
        boolean bl = Modifier.isPublic(n);
        boolean bl2 = Modifier.isPrivate(n);
        boolean bl3 = Modifier.isProtected(n);
        boolean bl4 = !bl & !bl2 & !bl3;
        if (PUBLIC.equals(string)) {
            return bl;
        }
        if (PROTECTED.equals(string)) {
            return bl || bl3;
        }
        if (DEFAULT.equals(string)) {
            return bl4 || bl || bl3;
        }
        return true;
    }

    @Override
    public void dump(Object object, OutputStream outputStream, boolean bl) {
        YamlEncoder yamlEncoder = new YamlEncoder(outputStream, this);
        yamlEncoder.setConfig(this);
        yamlEncoder.setMinimalOutput(bl);
        yamlEncoder.writeObject(object);
        yamlEncoder.close();
    }

    @Override
    public void dump(Object object, OutputStream outputStream) {
        YamlEncoder yamlEncoder = new YamlEncoder(outputStream, this);
        yamlEncoder.setConfig(this);
        yamlEncoder.writeObject(object);
        yamlEncoder.close();
    }

    static {
        try {
            defaultConfig = YamlConfig.fromResource("jyaml.yml");
        }
        catch (Exception exception) {
            try {
                defaultConfig = YamlConfig.fromFile("jyaml.yml");
            }
            catch (Exception exception2) {
                defaultConfig = new YamlConfig();
            }
        }
    }
}

