/*
 * Decompiled with CFR 0.152.
 */
package tratz.semantics.psd.training;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import tratz.runpipe.TextDocument;
import tratz.runpipe.TextDocumentReader;
import tratz.runpipe.annotations.Sentence;
import tratz.semantics.psd.training.HeadAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrepDocReader
implements TextDocumentReader {
    private String highDoubleQuotes;
    private String highSingleQuotes;

    @Override
    public void initialize(Map<String, String> params) {
        int[] doubleQuoteInts = new int[]{132, 171, 187, 147, 148, 8220, 8221, 8222, 8223, 8243, 8244, 8246, 8247};
        int[] singleQuoteInts = new int[]{145, 146, 8216, 8217, 8218, 8219, 8242, 8245};
        StringBuilder buf = new StringBuilder();
        for (int i : doubleQuoteInts) {
            buf.append((char)i).append("|");
        }
        buf.setLength(buf.length() - 1);
        this.highDoubleQuotes = buf.toString();
        buf = new StringBuilder();
        for (int i : singleQuoteInts) {
            buf.append((char)i).append("|");
        }
        buf.setLength(buf.length() - 1);
        this.highSingleQuotes = buf.toString();
    }

    @Override
    public void hydrateDocument(InputStream istream, TextDocument textDoc) throws IOException {
        int start = 0;
        StringBuilder docText = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(istream));
        String line = null;
        while ((line = reader.readLine()) != null) {
            if (!(line = line.trim()).startsWith("<instance")) continue;
            int idStartIndex = line.indexOf("id=\"");
            int idEnd = line.indexOf("\"", idStartIndex + 4);
            String id = line.substring(idStartIndex + 4, idEnd);
            String nextLine = reader.readLine().trim();
            String sense = null;
            if (nextLine.startsWith("<answer")) {
                String senseAttribStart = "senseid=\"";
                int senseIndex = nextLine.indexOf(senseAttribStart);
                int endOfSenseIndex = nextLine.indexOf("\"", senseIndex + senseAttribStart.length());
                sense = nextLine.substring(senseIndex + senseAttribStart.length(), endOfSenseIndex);
                String contextLine = reader.readLine().trim();
                if (!contextLine.startsWith("<context")) {
                    throw new RuntimeException("failed to parse psd instances file... corrupted? edited?");
                }
            } else if (!nextLine.startsWith("<context")) {
                throw new RuntimeException("failed to parse psd instances file... corrupted? edited?");
            }
            String contextText = reader.readLine().trim();
            contextText = contextText.replace("`", "``");
            contextText = contextText.replace("\"", "''");
            contextText = " " + contextText + " ";
            int headTagIndex = contextText.indexOf("<head>");
            int headTagEndIndex = contextText.indexOf("</head>");
            if (contextText.contains("<head></head>")) continue;
            String preHeadTagText = contextText.substring(0, headTagIndex).trim();
            String postHead = contextText.substring(headTagEndIndex + 7).trim();
            String headText = contextText.substring(headTagIndex + 6, headTagEndIndex).trim();
            String tagRemovedText = preHeadTagText + " " + headText + " " + postHead;
            HeadAnnotation headAnnot = new HeadAnnotation(textDoc, start + preHeadTagText.length() + 1, start + preHeadTagText.length() + 1 + headText.length());
            headAnnot.setId(id);
            headAnnot.setSenseId(sense);
            textDoc.addAnnotation(headAnnot);
            docText.append(tagRemovedText);
            textDoc.addAnnotation(new Sentence(textDoc, start, start + tagRemovedText.length()));
            start += tagRemovedText.length();
        }
        reader.close();
        textDoc.setText(docText.toString());
    }
}

