/*
 * Decompiled with CFR 0.152.
 */
package tratz.featgen.fer;

import java.util.Set;
import tratz.featgen.fer.AbstractWordNetFER;
import tratz.jwni.IndexEntry;
import tratz.jwni.POS;
import tratz.jwni.Pointer;
import tratz.jwni.PointerType;
import tratz.jwni.Sense;
import tratz.jwni.WordNet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WordNetLinksFER
extends AbstractWordNetFER {
    private static final long serialVersionUID = 1L;
    public static final PointerType[] ptTypes = new PointerType[]{PointerType.ANTONYM, PointerType.HYPERNYM, PointerType.INSTANCE_HYPERNYM, PointerType.HYPONYM, PointerType.INSTANCE_HYPONYM, PointerType.MEMBER_HOLONYM, PointerType.SUBSTANCE_HOLONYM, PointerType.PART_HOLONYM, PointerType.MEMBER_MERONYM, PointerType.SUBSTANCE_MERONYM, PointerType.PART_MERONYM, PointerType.ATTRIBUTE, PointerType.DERIVED_FORM, PointerType.DOMAIN_OF_SYNSET_TOPIC, PointerType.MEMBER_OF_THIS_DOMAIN_TOPIC, PointerType.DOMAIN_OF_SYNSET_REGION, PointerType.MEMBER_OF_THIS_DOMAIN_REGION, PointerType.DOMAIN_OF_SYNSET_USAGE, PointerType.MEMBER_OF_THIS_DOMAIN_USAGE, PointerType.ENTAILMENT, PointerType.CAUSE, PointerType.ALSO_SEE, PointerType.VERB_GROUP, PointerType.SIMILAR_TO, PointerType.PARTICIPLE_OF_VERB, PointerType.PERTAINYM};

    @Override
    public Set<String> generateFeatures(String term, String type, Set<String> productions) {
        IndexEntry entry;
        POS pos = this.getPosForType(type);
        if (pos != null && (entry = WordNet.getInstance().lookupIndexEntry(pos, term)) != null) {
            Sense[] senses = entry.getSenses();
            for (int i = 0; i < senses.length && i < this.mMaxSenseNum; ++i) {
                Sense sense = senses[i];
                for (PointerType pType : ptTypes) {
                    Pointer[] pointers = sense.getPointers(pType);
                    if (pointers.length <= 0) continue;
                    productions.add(pType.name());
                }
            }
        }
        return productions;
    }
}

