/*
 * Decompiled with CFR 0.152.
 */
package tratz.parse.ml;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import tratz.parse.ml.AbstractParseModel;
import tratz.types.FloatArrayList;
import tratz.types.IntArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OldTrainablePerceptron
extends AbstractParseModel {
    public static final long serialVersionUID = 1L;
    private int count;
    private List<Entry> mEntries = new ArrayList<Entry>();
    private int numEntries;
    private Map<String, Integer> mFeatToIndex;

    public void printStats(PrintWriter writer, CharSequence feat) throws IOException {
        int featIndex = this.mFeatToIndex.get(new String(((Object)feat).toString()));
        Entry entry = this.mEntries.get(featIndex);
        if (entry.c.size() == 1) {
            writer.print("\t" + entry.w.get(0) + ":" + entry.w2.get(0) + ":" + entry.c.get(0));
        } else if (entry.c.size() > 1) {
            for (int i = 0; i < entry.c.size(); ++i) {
                writer.print("\t" + entry.w.get(i) + ":" + entry.w2.get(i) + ":" + entry.c.get(i));
            }
        }
    }

    public OldTrainablePerceptron() {
    }

    public OldTrainablePerceptron(List<String> actions) {
        this.mEntries.add(new Entry());
        this.mActions = new ArrayList<String>(actions);
        this.mActionToIndex = new HashMap();
        this.mFeatToIndex = new HashMap<String, Integer>();
    }

    @Override
    public int getIndex(String feat, boolean add) {
        Integer index = this.mFeatToIndex.get(feat);
        if (index != null) {
            return index;
        }
        if (add) {
            index = this.mFeatToIndex.size() + 1;
            this.mFeatToIndex.put(feat, index);
        }
        return index;
    }

    @Override
    public void incrementCount() {
        ++this.count;
    }

    @Override
    public void updateFeature(int actionIndex, int feat, double change) {
        int numEntries = this.mEntries.size();
        if (feat >= numEntries) {
            for (int j = 0; j < feat - numEntries + 1; ++j) {
                this.mEntries.add(new Entry());
                if (numEntries % 100 != 0) continue;
                System.err.println("Entries: " + numEntries);
            }
        }
        Entry entry = this.mEntries.get(feat);
        if (entry.w == null) {
            entry.w = new FloatArrayList(1);
            entry.w2 = new FloatArrayList(1);
            entry.c = new IntArrayList();
            entry.w2.add(0.0f);
            entry.w.add((float)change);
            entry.c.add(this.count);
            entry.classOne = actionIndex;
        } else {
            int numWeights = entry.w.size();
            if (numWeights == 1) {
                if (entry.classOne == actionIndex) {
                    entry.w2.set(0, entry.w2.get(0) + entry.w.get(0) * (float)(this.count - entry.c.get(0)));
                    entry.w.set(0, entry.w.get(0) + (float)change);
                    entry.c.set(0, this.count);
                } else {
                    int oldClassOne = entry.classOne;
                    int c = entry.c.get(0);
                    double w = entry.w.get(0);
                    double w2 = entry.w2.get(0);
                    int maxIndex = Math.max(actionIndex, entry.classOne);
                    entry.classOne = -1;
                    if (numWeights <= maxIndex) {
                        int numToAdd = maxIndex - numWeights + 1;
                        for (int j = 0; j < numToAdd; ++j) {
                            entry.w2.add(0.0f);
                            entry.w.add(0.0f);
                            entry.c.add(0);
                        }
                    }
                    entry.w2.set(0, 0.0f);
                    entry.w.set(0, 0.0f);
                    entry.c.set(0, 0);
                    entry.w2.set(oldClassOne, (float)w2);
                    entry.w.set(oldClassOne, (float)w);
                    entry.c.set(oldClassOne, c);
                    double oldW = entry.w.get(actionIndex);
                    entry.w2.set(actionIndex, (float)((double)entry.w2.get(actionIndex) + oldW * (double)(this.count - entry.c.get(actionIndex))));
                    entry.w.set(actionIndex, (float)(oldW + change));
                    entry.c.set(actionIndex, this.count);
                }
            } else {
                if (numWeights <= actionIndex) {
                    int numToAdd = actionIndex - numWeights + 1;
                    for (int j = 0; j < numToAdd; ++j) {
                        entry.w2.add(0.0f);
                        entry.w.add(0.0f);
                        entry.c.add(0);
                    }
                }
                double oldW = entry.w.get(actionIndex);
                entry.w2.set(actionIndex, (float)((double)entry.w2.get(actionIndex) + oldW * (double)(this.count - entry.c.get(actionIndex))));
                entry.w.set(actionIndex, (float)(oldW + change));
                entry.c.set(actionIndex, this.count);
            }
        }
    }

    @Override
    public void update(String action, IntArrayList feats, double change) {
        int actionIndex = this.getActionIndex(action, true);
        int numFeats = feats.size();
        int numEntries = this.mEntries.size();
        for (int i = 0; i < numFeats; ++i) {
            int feat = feats.get(i);
            if (feat >= numEntries) {
                for (int j = 0; j < feat - numEntries + 1; ++j) {
                    this.mEntries.add(new Entry());
                }
            }
            Entry entry = this.mEntries.get(feat);
            if (entry.w == null) {
                entry.w = new FloatArrayList(1);
                entry.w2 = new FloatArrayList(1);
                entry.c = new IntArrayList(1);
                entry.w2.add(0.0f);
                entry.w.add((float)change);
                entry.c.add(this.count);
                entry.classOne = actionIndex;
                continue;
            }
            int numWeights = entry.w.size();
            if (numWeights == 1) {
                if (entry.classOne == actionIndex) {
                    entry.w2.set(0, entry.w2.get(0) + entry.w.get(0) * (float)(this.count - entry.c.get(0)));
                    entry.w.set(0, entry.w.get(0) + (float)change);
                    entry.c.set(0, this.count);
                    continue;
                }
                int oldClassOne = entry.classOne;
                int c = entry.c.get(0);
                double w = entry.w.get(0);
                double w2 = entry.w2.get(0);
                int maxIndex = Math.max(actionIndex, entry.classOne);
                entry.classOne = -1;
                if (numWeights <= maxIndex) {
                    int numToAdd = maxIndex - numWeights + 1;
                    for (int j = 0; j < numToAdd; ++j) {
                        entry.w2.add(0.0f);
                        entry.w.add(0.0f);
                        entry.c.add(0);
                    }
                }
                entry.w2.set(0, 0.0f);
                entry.w.set(0, 0.0f);
                entry.c.set(0, 0);
                entry.w2.set(oldClassOne, (float)w2);
                entry.w.set(oldClassOne, (float)w);
                entry.c.set(oldClassOne, c);
                double oldW = entry.w.get(actionIndex);
                entry.w2.set(actionIndex, (float)((double)entry.w2.get(actionIndex) + oldW * (double)(this.count - entry.c.get(actionIndex))));
                entry.w.set(actionIndex, (float)(oldW + change));
                entry.c.set(actionIndex, this.count);
                continue;
            }
            if (numWeights <= actionIndex) {
                int numToAdd = actionIndex - numWeights + 1;
                for (int j = 0; j < numToAdd; ++j) {
                    entry.w2.add(0.0f);
                    entry.w.add(0.0f);
                    entry.c.add(0);
                }
            }
            double oldW = entry.w.get(actionIndex);
            entry.w2.set(actionIndex, (float)((double)entry.w2.get(actionIndex) + oldW * (double)(this.count - entry.c.get(actionIndex))));
            entry.w.set(actionIndex, (float)(oldW + change));
            entry.c.set(actionIndex, this.count);
        }
    }

    @Override
    public final void scoreIntermediate(List<String> actions, IntArrayList feats, int[] indices, double[] scores) {
        int i;
        int numActions = actions.size();
        int numFeats = feats.size();
        int numEntries = this.mEntries.size();
        for (i = 0; i < numActions; ++i) {
            Integer index = (Integer)this.mActionToIndex.get(actions.get(i));
            indices[i] = index == null ? -1 : 0;
            scores[i] = 0.0;
        }
        block1: for (i = 0; i < numFeats; ++i) {
            int a;
            int entrySize;
            int feat = feats.get(i);
            if (feat >= numEntries) continue;
            Entry entry = this.mEntries.get(feat);
            int n = entrySize = entry.c == null ? 0 : entry.c.size();
            if (entrySize > 1) {
                for (a = 0; a < numActions; ++a) {
                    int actionIndex = indices[a];
                    if (actionIndex == -1 || actionIndex >= entrySize) continue;
                    int n2 = a;
                    scores[n2] = scores[n2] + (double)entry.w.get(actionIndex);
                }
                continue;
            }
            if (entrySize != 1) continue;
            for (a = 0; a < numActions; ++a) {
                if (indices[a] != entry.classOne) continue;
                int n3 = a;
                scores[n3] = scores[n3] + (double)entry.w.get(0);
                continue block1;
            }
        }
    }

    public Map<String, Integer> getActionToIndex() {
        return this.mActionToIndex;
    }

    public float getValue(int featIndex, int actionIndex) {
        Entry entry = this.mEntries.get(featIndex);
        int entrySize = entry.c.size();
        try {
            float retValue = 0.0f;
            if (entrySize > 1) {
                float w = entry.w.get(actionIndex);
                float w2 = entry.w2.get(actionIndex);
                int c = entry.c.get(actionIndex);
                return w2 + w * (float)(this.count - c);
            }
            if (entry.classOne == actionIndex) {
                float w = entry.w.get(0);
                float w2 = entry.w2.get(0);
                int c = entry.c.get(0);
                return w2 + w * (float)(this.count - c);
            }
            return 0.0f;
        }
        catch (IndexOutOfBoundsException iobe) {
            return 0.0f;
        }
    }

    @Override
    public final void score(List<String> actions, IntArrayList feats, int[] indices, double[] scores) {
        int i;
        int numActions = actions.size();
        int numFeats = feats.size();
        int numEntries = this.mEntries.size();
        for (i = 0; i < numActions; ++i) {
            Integer index = (Integer)this.mActionToIndex.get(actions.get(i));
            indices[i] = index == null ? -1 : index;
            scores[i] = 0.0;
        }
        block1: for (i = 0; i < numFeats; ++i) {
            int a;
            int entrySize;
            int feat = feats.get(i);
            if (feat >= numEntries) continue;
            Entry entry = this.mEntries.get(feat);
            int n = entrySize = entry.c == null ? 0 : entry.c.size();
            if (entrySize > 1) {
                for (a = 0; a < numActions; ++a) {
                    int actionIndex = indices[a];
                    if (actionIndex == -1 || actionIndex >= entrySize) continue;
                    double w = entry.w.get(actionIndex);
                    double w2 = entry.w2.get(actionIndex);
                    int c = entry.c.get(actionIndex);
                    int n2 = a;
                    scores[n2] = scores[n2] + (w2 + w * (double)(this.count - c));
                }
                continue;
            }
            if (entrySize != 1) continue;
            for (a = 0; a < numActions; ++a) {
                if (indices[a] != entry.classOne) continue;
                double w = entry.w.get(0);
                double w2 = entry.w2.get(0);
                int c = entry.c.get(0);
                int n3 = a;
                scores[n3] = scores[n3] + (w2 + w * (double)(this.count - c));
                continue block1;
            }
        }
    }

    public Map<String, Map<String, List<String>>> getPosPosMap() {
        return this.mPosPosActs;
    }

    private static class Entry
    implements Serializable {
        public static final long serialVersionUID = 1L;
        public int classOne;
        public FloatArrayList w = null;
        public FloatArrayList w2 = null;
        public IntArrayList c = null;

        private Entry() {
        }
    }

    public static class DoubleHolder
    implements Serializable {
        public static final long serialVersionUID = 1L;
    }
}

