/*
 * Decompiled with CFR 0.152.
 */
package Jet.Pat;

import Jet.Concepts.ConcreteFileFilter;
import Jet.Pat.PatternCollection;
import Jet.Pat.PatternSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;

public class PatternGraphView
extends JFrame
implements ActionListener {
    PatternCollection pc;
    JTree patternGraphTree;
    JScrollPane jScrollPane = new JScrollPane();
    JFileChooser fc = new JFileChooser(".");
    File currentFile;

    public PatternGraphView(File file) {
        this.currentFile = file;
        this.readPatterns();
        this.buildTree();
        this.jbInit();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        if (dimension2.height > dimension.height) {
            dimension2.height = dimension.height;
        }
        if (dimension2.width > dimension.width) {
            dimension2.width = dimension.width;
        }
        this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Open ...")) {
            int n = this.fc.showOpenDialog(this);
            if (n == 0) {
                this.currentFile = this.fc.getSelectedFile();
                this.readPatterns();
                this.buildTree();
                this.patternGraphTree.getSelectionModel().setSelectionMode(1);
                this.jScrollPane.getViewport().add((Component)this.patternGraphTree, null);
                this.setTitle("Pattern Graph View - " + this.currentFile.getPath());
            }
        } else if (actionEvent.getActionCommand().equals("Expand")) {
            TreePath treePath = this.patternGraphTree.getSelectionPath();
            if (treePath != null) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                this.expand(defaultMutableTreeNode);
            }
        } else if (actionEvent.getActionCommand().equals("Collapse")) {
            TreePath treePath = this.patternGraphTree.getSelectionPath();
            if (treePath != null) {
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                this.collapse(defaultMutableTreeNode);
            }
        } else if (actionEvent.getActionCommand().equals("Expand All")) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.patternGraphTree.getModel().getRoot();
            for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
                this.expand((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i));
            }
        } else if (actionEvent.getActionCommand().equals("Collapse All")) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.patternGraphTree.getModel().getRoot();
            for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
                this.collapse((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i));
            }
        } else {
            this.dispose();
        }
    }

    private void buildTree() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Pattern Sets");
        this.patternGraphTree = new JTree(defaultMutableTreeNode);
        this.patternGraphTree.setRootVisible(true);
        this.patternGraphTree.setShowsRootHandles(true);
        this.patternGraphTree.setEditable(false);
        this.patternGraphTree.putClientProperty("JTree.lineStyle", "Angled");
        this.patternGraphTree.setCellRenderer(new PatternGraphRenderer());
        for (int i = 0; i < this.pc.patternSetNames.size(); ++i) {
            String string = (String)this.pc.patternSetNames.get(i);
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode("Pattern Set: " + string);
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            DefaultMutableTreeNode defaultMutableTreeNode3 = defaultMutableTreeNode2;
            defaultMutableTreeNode2 = new DefaultMutableTreeNode("NODE_0");
            defaultMutableTreeNode3.add(defaultMutableTreeNode2);
            defaultMutableTreeNode3 = defaultMutableTreeNode2;
            PatternSet patternSet = (PatternSet)this.pc.patternSets.get(string);
            patternSet.rootNode.toTree(defaultMutableTreeNode3);
        }
        this.patternGraphTree.updateUI();
    }

    private void readPatterns() {
        this.pc = new PatternCollection();
        try {
            this.pc.readPatternCollection(new BufferedReader(new FileReader(this.currentFile)));
        }
        catch (IOException iOException) {
            System.err.println("Error: reading pattern file " + this.currentFile.getName() + ", " + iOException.getMessage());
        }
        this.pc.makePatternGraph();
    }

    private void expand(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.patternGraphTree.expandPath(new TreePath(defaultMutableTreeNode.getPath()));
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            this.expand((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i));
        }
    }

    private void collapse(DefaultMutableTreeNode defaultMutableTreeNode) {
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            this.collapse((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i));
        }
        this.patternGraphTree.collapsePath(new TreePath(defaultMutableTreeNode.getPath()));
    }

    private void jbInit() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        JMenuItem jMenuItem = new JMenuItem("Open ...");
        jMenuItem.setMnemonic(79);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Exit");
        jMenuItem.setMnemonic(88);
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(this);
        JMenu jMenu2 = new JMenu("View");
        jMenu2.setMnemonic(86);
        jMenuItem = new JMenuItem("Expand");
        jMenuItem.setMnemonic(69);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        jMenu2.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenuItem = new JMenuItem("Collapse");
        jMenuItem.setMnemonic(67);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        jMenu2.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenuItem = new JMenuItem("Expand All");
        jMenuItem.setMnemonic(69);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, 10));
        jMenu2.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenuItem = new JMenuItem("Collapse All");
        jMenuItem.setMnemonic(67);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 10));
        jMenu2.add(jMenuItem);
        jMenuItem.addActionListener(this);
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        this.setJMenuBar(jMenuBar);
        ConcreteFileFilter concreteFileFilter = new ConcreteFileFilter("pat", "Pattern Files (*.pat)");
        this.fc.setFileFilter(concreteFileFilter);
        this.fc.setDialogTitle("Open Pattern File");
        this.fc.setApproveButtonText("Open");
        this.fc.setApproveButtonMnemonic(79);
        this.fc.setApproveButtonToolTipText("Open Pattern File");
        this.patternGraphTree.getSelectionModel().setSelectionMode(1);
        this.jScrollPane.getViewport().add((Component)this.patternGraphTree, null);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jScrollPane, "Center");
        this.setSize(600, 600);
        this.setTitle("Pattern Graph View - " + this.currentFile.getPath());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PatternGraphView.this.dispose();
            }
        });
    }

    class PatternGraphRenderer
    extends DefaultTreeCellRenderer {
        ImageIcon actionIcon = new ImageIcon("images/fish.gif");

        PatternGraphRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (bl3 && this.isAction(object)) {
                this.setIcon(this.actionIcon);
            }
            return this;
        }

        boolean isAction(Object object) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
            String string = (String)defaultMutableTreeNode.getUserObject();
            return string.indexOf("-->") >= 0;
        }
    }
}

