/*
 * Decompiled with CFR 0.152.
 */
package Jet.Chunk;

import AceJet.Gazetteer;
import Jet.Lex.Lexicon;
import Jet.Lisp.FeatureSet;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import Jet.Tipster.Span;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Onoma {
    public static boolean loaded = false;

    public static void read(String string) throws IOException {
        String string2;
        loaded = true;
        int n = 0;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        while ((string2 = bufferedReader.readLine()) != null) {
            String[] stringArray = string2.split("\t");
            if (stringArray.length < 2 || stringArray.length > 3) {
                System.out.println("Invalid onoma line: " + string2);
                continue;
            }
            String string3 = stringArray[0];
            String string4 = stringArray[1];
            String string5 = null;
            if (stringArray.length == 3) {
                string5 = stringArray[2];
            }
            Lexicon.addEntry(Gazetteer.splitAtWS(string3), new FeatureSet("TYPE", string4, "SUBTYPE", string5), "onoma");
            ++n;
        }
        System.out.println("Onoma:  read " + n + " names.");
    }

    public static void tagDrugs(Document document, Span span) {
    }

    public static void tagNames(Document document, Span span) {
        int n = span.start();
        while (n < span.end()) {
            Vector<Annotation> vector = document.annotationsAt(n, "onoma");
            if (vector != null && vector.size() > 0) {
                Annotation annotation = vector.get(0);
                List<Annotation> list = Onoma.containedNames(document, span, annotation.span());
                if (list != null) {
                    String string = (String)annotation.get("TYPE");
                    String string2 = (String)annotation.get("SUBTYPE");
                    document.annotate("ENAMEX", annotation.span(), new FeatureSet("TYPE", string, "SUBTYPE", string2));
                    for (Annotation annotation2 : list) {
                        document.removeAnnotation(annotation2);
                    }
                }
                n = annotation.end();
                continue;
            }
            Annotation annotation = document.tokenAt(n);
            if (annotation != null) {
                n = annotation.end();
                continue;
            }
            return;
        }
    }

    private static List<Annotation> containedNames(Document document, Span span, Span span2) {
        ArrayList<Annotation> arrayList = new ArrayList<Annotation>();
        int n = span.start();
        while (n < span.end()) {
            Vector<Annotation> vector = document.annotationsAt(n, "ENAMEX");
            if (vector != null && vector.size() > 0) {
                Annotation annotation = vector.get(0);
                Span span3 = annotation.span();
                if (span3.end() > span2.start() && span3.start() < span2.end()) {
                    if (span3.within(span2)) {
                        arrayList.add(annotation);
                    } else {
                        return null;
                    }
                }
                n = annotation.end();
                continue;
            }
            Annotation annotation = document.tokenAt(n);
            if (annotation != null) {
                n = annotation.end();
                continue;
            }
            return null;
        }
        return arrayList;
    }
}

