/*
 * Decompiled with CFR 0.152.
 */
package AceJet;

import AceJet.AceDocument;
import AceJet.AceEntity;
import AceJet.AceEntityMention;
import AceJet.AceEntityName;
import AceJet.AceTimex;
import AceJet.AceTimexMention;
import AceJet.EDTtype;
import AceJet.EventTagger;
import AceJet.FindAceValues;
import AceJet.Gazetteer;
import AceJet.LearnRelations;
import AceJet.PerfectAce;
import AceJet.PerfectNameTagger;
import AceJet.RelationPatternSet;
import AceJet.RelationTagger;
import Jet.Control;
import Jet.Format.InvalidFormatException;
import Jet.Format.PTBReader;
import Jet.HMM.BigramHMMemitter;
import Jet.HMM.HMMstate;
import Jet.JetTest;
import Jet.Lisp.FeatureSet;
import Jet.Parser.AddSyntacticRelations;
import Jet.Parser.ParseTreeNode;
import Jet.Parser.SynFun;
import Jet.Pat.Pat;
import Jet.Refres.Resolve;
import Jet.Scorer.NameTagger;
import Jet.Time.TimeAnnotator;
import Jet.Time.TimeMain;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import Jet.Tipster.ExternalDocument;
import Jet.Tipster.Span;
import Jet.Zoner.SpecialZoner;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ace {
    static final Logger logger = LoggerFactory.getLogger(Ace.class);
    public static boolean useParser = false;
    static final boolean useParseCollection = false;
    public static boolean perfectMentions = false;
    public static boolean perfectEntities = false;
    static final boolean asr = false;
    public static boolean preferRelations = false;
    public static boolean preferEntities = !preferRelations;
    public static boolean entityTrace = false;
    public static boolean monocase = false;
    static String fileList;
    public static Gazetteer gazetteer;
    static int aceEntityNo;
    static HashMap aceTypeDict;
    static final String suffix = ".sgm.apf";
    static String sourceType;
    public static RelationPatternSet eve;
    static EventTagger eventTagger;
    static String docDir;
    static String outputDir;
    static String parseDir;
    static String glarfDir;
    static int docCount;
    static String parseSuffix;
    static NameTagger realNameTagger;
    static boolean writeEventConfidence;
    static String[] functionWord;
    static final String[] locativePrepositions;
    static final String[] genericFriendlyDeterminers;
    static final String[] clearGenericPronouns;

    public static void main(String[] stringArray) throws IOException {
        String string;
        Ace.initForFileIO(stringArray);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(fileList));
        boolean bl = false;
        while ((string = bufferedReader.readLine()) != null) {
            if (bl) {
                Ace.processFile(string);
                continue;
            }
            try {
                Ace.processFile(string);
            }
            catch (Exception exception) {
                logger.error("Error processing document " + fileList + "(" + docCount + ")=" + string, exception);
            }
        }
    }

    public static void initForFileIO(String[] stringArray) throws IOException {
        logger.info("Starting ACE Jet...");
        if (stringArray.length < 4 || stringArray.length > 8) {
            logger.error("Ace must take 4 to 8 arguments:");
            logger.error("    properties filelist documentDir outputDir [parseDir [glarfDir [glarfSuffix [parseSuffix]]]]");
            System.exit(1);
        }
        String string = stringArray[0];
        fileList = stringArray[1];
        docDir = stringArray[2];
        outputDir = stringArray[3];
        parseDir = null;
        if (stringArray.length >= 5) {
            parseDir = stringArray[4];
        }
        String string2 = null;
        if (stringArray.length >= 6) {
            string2 = stringArray[5];
        }
        if (stringArray.length >= 7) {
            EventTagger.triplesSuffix = stringArray[6];
        }
        if (stringArray.length == 8) {
            parseSuffix = stringArray[7];
        }
        Ace.init(string);
    }

    public static void init(String string) throws IOException {
        String string2;
        String string3;
        Pat.trace = false;
        Resolve.trace = false;
        JetTest.initializeFromConfig(string);
        realNameTagger = JetTest.nameTagger;
        Ace.setAceYear();
        if (JetTest.getConfig("Ace.PerfectEntities") != null) {
            perfectMentions = true;
            perfectEntities = true;
        }
        Resolve.ACE = true;
        EDTtype.readTypeDict();
        EDTtype.readGenericDict();
        String string4 = JetTest.getConfigFile("Ace.Value.fileName");
        if (string4 != null) {
            FindAceValues.readTypeDict(string4);
        } else {
            logger.info("Ace:  no value dictionary file name specified in config file.");
            logger.info("      Will not tag values.");
        }
        String string5 = JetTest.getConfigFile("Time.fileName");
        if (string5 != null) {
            TimeMain.timeAnnotator = new TimeAnnotator(string5);
        } else {
            logger.info("Ace:  no time rules file name specified in config file.");
            logger.info("      Will not tag time expressions.");
        }
        String string6 = JetTest.getConfigFile("Ace.RelationPatterns.fileName");
        if (string6 != null) {
            eve = new RelationPatternSet();
            eve.load(string6, 0);
        }
        if ((string3 = JetTest.getConfigFile("Ace.RelationModel.fileName")) != null) {
            RelationTagger.loadModels(string3);
        }
        if (string6 == null && string3 == null) {
            logger.info("Ace:  no relation model specified in config file");
            logger.info("      Will not tag relations.");
        }
        if ((string2 = JetTest.getConfigFile("Ace.EventModels.directory")) != null) {
            eventTagger = new EventTagger();
            EventTagger.useParser = useParser;
            EventTagger.usePA = glarfDir != null;
            EventTagger.glarfDir = glarfDir;
            String string7 = string2 + "eventPatterns.log";
            eventTagger.load(string7);
            eventTagger.loadAllModels(string2);
        } else {
            logger.info("Ace:  no event model file name specified in config file");
            logger.info("      Will not tag events.");
        }
        writeEventConfidence = JetTest.getConfigFile("Ace.writeEventConfidence") != null;
        EventTagger.EVENT_PROBABILITY_THRESHOLD = Ace.getConfigDouble("Ace.EventModels.eventProbabilityThreshold", EventTagger.EVENT_PROBABILITY_THRESHOLD);
        EventTagger.ARGUMENT_PROBABILITY_THRESHOLD = Ace.getConfigDouble("Ace.EventModels.argumentProbabilityThreshold", EventTagger.ARGUMENT_PROBABILITY_THRESHOLD);
    }

    static double getConfigDouble(String string, double d) {
        String string2 = JetTest.getConfig(string);
        if (string2 == null) {
            return d;
        }
        try {
            return Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            logger.error("Error in Jet parameter " + string + " = " + string2);
            logger.error(numberFormatException.toString());
            return d;
        }
    }

    static void setAceYear() {
        String string = JetTest.getConfig("Ace.Year");
        if (string != null) {
            Ace.setAceYear(string);
        }
    }

    static void setAceYear(String string) {
        if (string.equals("2003")) {
            AceDocument.ace2004 = false;
            AceDocument.ace2005 = false;
        } else if (string.equals("2004")) {
            AceDocument.ace2004 = true;
            AceDocument.ace2005 = false;
        } else if (string.equals("2005")) {
            AceDocument.ace2004 = true;
            AceDocument.ace2005 = true;
        } else {
            logger.error("Unrecognized value " + string + " for Ace.Year");
        }
    }

    public static void processFileAndCatchError(String string) throws IOException {
        try {
            Ace.processFile(string);
        }
        catch (Exception exception) {
            logger.error("Error processing document " + docCount + " = " + string, exception);
        }
    }

    public static void processFile(String string) throws IOException {
        Object object;
        String string2;
        Object object2;
        logger.info("\nProcessing document " + ++docCount + ": " + string);
        String string3 = new File(string).getName();
        String string4 = Ace.removeFileExtension(string3);
        String string5 = Ace.removeFileExtension(string);
        ExternalDocument externalDocument = new ExternalDocument("sgml", docDir + string);
        if (perfectMentions) {
            object2 = docDir + string;
            string2 = docDir + string5 + ".apf.xml";
            object = new AceDocument((String)object2, string2);
            PerfectAce.buildEntityMentionMap(externalDocument, (AceDocument)object);
            JetTest.nameTagger = new PerfectNameTagger((AceDocument)object, realNameTagger);
        }
        externalDocument.setAllTags(true);
        externalDocument.open();
        object2 = Ace.processDocument(externalDocument, string4, string3, string5);
        string2 = outputDir + string5 + suffix;
        object = new PrintWriter(string2, JetTest.encoding);
        ((AceDocument)object2).write((PrintWriter)object, externalDocument);
    }

    public static AceDocument processDocument(Document document, String string, String string2, String string3) throws IOException {
        Object object;
        Iterator iterator;
        Serializable serializable;
        String string4;
        document.stretchAll();
        monocase = Ace.allLowerCase(document);
        logger.trace("Monocase is " + monocase);
        gazetteer.setMonocase(monocase);
        BigramHMMemitter.useBigrams = monocase;
        double d = HMMstate.otherPreference = monocase ? 1.0 : 0.0;
        if (document.annotationsOfType("dateline") == null && document.annotationsOfType("textBreak") == null) {
            SpecialZoner.findSpecialZones(document);
        }
        Control.processDocument(document, null, docCount == -1, docCount);
        if (parseDir != null && !parseDir.equals("-")) {
            string4 = parseDir + string3 + parseSuffix;
            try {
                serializable = new File(string4);
                iterator = new PTBReader();
                object = ((PTBReader)((Object)iterator)).loadParseTrees((File)serializable);
                List<Integer> list = ((PTBReader)((Object)iterator)).getOffsets();
                ((PTBReader)((Object)iterator)).addAnnotations((List<ParseTreeNode>)object, list, document, "sentence", new Span(0, document.text().length()), true);
            }
            catch (InvalidFormatException invalidFormatException) {
                logger.error("Format error in reading parse tree from file " + string4);
            }
            catch (IOException iOException) {
                logger.error("IO error reading parse tree from file " + string4);
                logger.error("   " + iOException);
            }
            serializable = document.annotationsOfType("sentence");
            if (serializable != null) {
                iterator = ((Vector)serializable).iterator();
                while (iterator.hasNext()) {
                    object = (Annotation)iterator.next();
                    AddSyntacticRelations.annotate(document, ((Annotation)object).span());
                    Resolve.references(document, ((Annotation)object).span());
                }
            }
        }
        Ace.tagReciprocalRelations(document);
        string4 = Ace.getDocId(document);
        if (string4 == null) {
            string4 = string;
        }
        sourceType = "text";
        serializable = document.annotationsOfType("DOCTYPE");
        if (serializable != null && ((Vector)serializable).size() > 0 && (object = (String)((Annotation)((Object)(iterator = ((Vector)serializable).get(0)))).get("SOURCE")) != null) {
            sourceType = object;
        }
        iterator = new AceDocument(string2, sourceType, string4, document.text());
        Ace.buildAceEntities(document, string4, (AceDocument)((Object)iterator));
        if (TimeMain.timeAnnotator != null) {
            Ace.buildTimex(document, (AceDocument)((Object)iterator), string4);
        }
        if (FindAceValues.isDictLoaded()) {
            FindAceValues.buildAceValues(document, string4, (AceDocument)((Object)iterator));
        }
        if (eve != null) {
            LearnRelations.findRelations(string4, document, iterator);
        } else if (RelationTagger.model0 != null) {
            RelationTagger.findRelations(string4, document, iterator);
        }
        if (eventTagger != null) {
            eventTagger.tag(document, (AceDocument)((Object)iterator), string3, string4);
        }
        if (FindAceValues.isDictLoaded()) {
            FindAceValues.pruneAceValues(iterator);
        }
        return iterator;
    }

    public static String getDocId(Document document) {
        Annotation annotation;
        Object object;
        Vector<Annotation> vector = document.annotationsOfType("DOCID");
        if (vector != null && vector.size() > 0) {
            Annotation annotation2 = vector.get(0);
            return document.text(annotation2).trim();
        }
        vector = document.annotationsOfType("DOCNO");
        if (vector != null && vector.size() > 0) {
            Annotation annotation3 = vector.get(0);
            return document.text(annotation3).trim();
        }
        Vector<Annotation> vector2 = document.annotationsOfType("document");
        if (vector2 != null && vector2.size() > 0 && (object = (annotation = vector2.get(0)).get("DOCID")) != null && object instanceof String) {
            return (String)object;
        }
        vector2 = document.annotationsOfType("DOC");
        if (vector2 != null && vector2.size() > 0 && (object = (annotation = vector2.get(0)).get("id")) != null && object instanceof String) {
            return (String)object;
        }
        return null;
    }

    public static boolean allLowerCase(Document document) {
        Vector<Annotation> vector = document.annotationsOfType("TEXT");
        Span span = vector != null && vector.size() > 0 ? vector.get(0).span() : document.fullSpan();
        return Ace.allLowerCase(document, span);
    }

    public static boolean allLowerCase(Document document, Span span) {
        boolean bl = true;
        boolean bl2 = true;
        for (int i = span.start(); i < span.end(); ++i) {
            if (Character.isUpperCase(document.charAt(i))) {
                bl = false;
            }
            if (!Character.isLowerCase(document.charAt(i))) continue;
            bl2 = false;
        }
        return bl || bl2;
    }

    public static boolean titleCase(Document document, Span span) {
        boolean bl = true;
        String string = document.text(span);
        block0: for (int i = 0; i < string.length() - 1; ++i) {
            if (!Character.isWhitespace(string.charAt(i)) || !Character.isLowerCase(string.charAt(i + 1))) continue;
            for (int j = 0; j < functionWord.length; ++j) {
                if (string.startsWith(functionWord[j], i + 1)) continue block0;
            }
            bl = false;
        }
        return bl;
    }

    static String removeFileExtension(String string) {
        String string2 = new File(string).getName();
        int n = string2.lastIndexOf(46);
        if (n > 0 && n < string2.length() - 1) {
            return string.substring(0, n += string.length() - string2.length());
        }
        return string;
    }

    public static void buildAceEntities(Document document, String string, AceDocument aceDocument) {
        aceEntityNo = 0;
        LearnRelations.resetMentions();
        String string2 = document.text();
        Vector<Annotation> vector = document.annotationsOfType("entity");
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                AceEntity aceEntity = Ace.buildEntity(vector.get(i), i, document, string, string2);
                if (aceEntity == null) continue;
                aceDocument.addEntity(aceEntity);
            }
        }
        logger.info("buildAceEntities: generated " + aceDocument.entities.size() + " entities");
    }

    private static AceEntity buildEntity(Annotation annotation, int n, Document document, String string, String string2) {
        Vector vector = (Vector)annotation.get("mentions");
        Annotation annotation2 = (Annotation)vector.get(0);
        String string3 = EDTtype.getTypeSubtype(document, annotation, annotation2);
        String string4 = EDTtype.bareType(string3);
        if (entityTrace) {
            logger.trace("Type of " + Resolve.normalizeName(document.text(annotation2)) + " is " + string3);
        }
        if (string4.equals("OTHER")) {
            return null;
        }
        String string5 = EDTtype.subtype(string3);
        boolean bl = Ace.isGeneric(document, annotation2);
        if (bl) {
            logger.trace("Identified generic mention " + Resolve.normalizeName(document.text(annotation2)));
        }
        ++aceEntityNo;
        if (entityTrace) {
            logger.trace("Generating ace entity " + aceEntityNo + " (internal entity " + n + ") = " + Resolve.normalizeName(document.text(annotation2)) + " [" + string4 + "]");
        }
        String string6 = string + "-" + aceEntityNo;
        AceEntity aceEntity = new AceEntity(string6, string4, string5, bl);
        for (int i = 0; i < vector.size(); ++i) {
            boolean bl2;
            Annotation annotation3 = (Annotation)vector.get(i);
            Annotation annotation4 = Resolve.getHeadC(annotation3);
            String string7 = string6 + "-" + i;
            AceEntityMention aceEntityMention = Ace.buildMention(annotation3, annotation4, string7, string4, document, string2);
            aceEntity.addMention(aceEntityMention);
            LearnRelations.addMention(aceEntityMention);
            boolean bl3 = bl2 = aceEntityMention.type == "NAME";
            if (!bl2) continue;
            aceEntity.addName(new AceEntityName(annotation4.span(), string2));
        }
        return aceEntity;
    }

    private static AceEntityMention buildMention(Annotation annotation, Annotation annotation2, String string, String string2, Document document, String string3) {
        Span span = annotation.span();
        Span span2 = annotation2.span();
        String string4 = Ace.mentionType(annotation2, annotation);
        AceEntityMention aceEntityMention = new AceEntityMention(string, string4, span, span2, string3);
        if (string2.equals("GPE")) {
            String string5;
            aceEntityMention.role = perfectMentions ? PerfectAce.getMentionRole(annotation2) : ((string5 = Ace.governingPreposition(document, annotation)) != null && Ace.in(string5, locativePrepositions) || Resolve.sentenceSet.sentenceNumber(annotation.start()) == 0 ? "LOC" : "GPE");
        }
        return aceEntityMention;
    }

    private static String mentionType(Annotation annotation, Annotation annotation2) {
        if (perfectMentions) {
            return PerfectAce.getMentionType(annotation);
        }
        String string = (String)annotation.get("cat");
        String string2 = (String)annotation2.get("cat");
        if (string == "n" || string == "title" || string == "tv" || string == "v") {
            return "NOMINAL";
        }
        if (string == "pro" || string == "det" || string == "adj" || string == "ven" || string == "q" || string == "np" || string == "wp" || string == "wp$") {
            return "PRONOUN";
        }
        if (annotation2.get("nameWithModifier") != null) {
            return "NOMINAL";
        }
        return "NAME";
    }

    private static boolean isGeneric(Document document, Annotation annotation) {
        Annotation annotation2 = Ace.getNgHead(annotation);
        Annotation annotation3 = Resolve.getHeadC(annotation);
        if (annotation3.get("cat") == "n") {
            FeatureSet featureSet;
            String string = SynFun.getDet(annotation);
            if (string != null && Ace.in(string, genericFriendlyDeterminers)) {
                return true;
            }
            if (!EDTtype.hasGenericHead(document, annotation)) {
                return false;
            }
            if (annotation2.get("poss") != null || string == "poss") {
                return false;
            }
            if (annotation2.get("quant") != null || string == "q") {
                return false;
            }
            Annotation annotation4 = Ace.governingVerbGroup(annotation);
            if (annotation4 != null && (featureSet = (FeatureSet)annotation4.get("pa")) != null && featureSet.get("tense") != "past" && featureSet.get("aspect") == null) {
                logger.trace("Governing verb group = " + document.text(annotation4));
                logger.trace("Verb group pa = " + featureSet);
                return true;
            }
            return false;
        }
        if (annotation3.get("cat") == "pro" || annotation3.get("cat") == "np" || annotation3.get("cat") == "det") {
            String string = SynFun.getHead(document, annotation);
            return Ace.in(string, clearGenericPronouns) || Ace.in(string, genericFriendlyDeterminers);
        }
        return false;
    }

    private static Annotation getNgHead(Annotation annotation) {
        Annotation annotation2 = annotation;
        while ((annotation = (Annotation)annotation2.get("headC")) != null) {
            if (annotation.get("cat") != "np" || annotation.get("possPrefix") == "true") {
                return annotation2;
            }
            annotation2 = annotation;
        }
        return annotation2;
    }

    private static void buildTimex(Document document, AceDocument aceDocument, String string) {
        TimeMain.processDocument(document);
        Vector<Annotation> vector = document.annotationsOfType("TIMEX2");
        if (vector != null) {
            logger.info(vector.size() + " time expressions found.");
            for (int i = 0; i < vector.size(); ++i) {
                Annotation annotation = vector.get(i);
                String string2 = document.text();
                String string3 = string + "-T" + i;
                String string4 = (String)annotation.get("VAL");
                if (string4 == null) {
                    logger.warn("TIMEX " + string3 + " has no VAL.");
                }
                AceTimexMention aceTimexMention = new AceTimexMention(string3 + "-1", annotation.span(), string2);
                AceTimex aceTimex = new AceTimex(string3, string4);
                aceTimex.addMention(aceTimexMention);
                aceDocument.addTimeExpression(aceTimex);
            }
        }
    }

    private static boolean in(Object object, Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null || !objectArray[i].equals(object)) continue;
            return true;
        }
        return false;
    }

    public static void tagReciprocalRelations(Document document) {
        Vector<Annotation> vector = document.annotationsOfType("constit");
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                Annotation annotation;
                Annotation annotation2 = vector.elementAt(i);
                if (annotation2.get("subject") != null && (annotation = (Annotation)annotation2.get("subject")).get("subject-1") == null) {
                    annotation.put("subject-1", annotation2);
                }
                if (annotation2.get("object") == null || (annotation = (Annotation)annotation2.get("object")).get("object-1") != null) continue;
                annotation.put("object-1", annotation2);
            }
        }
    }

    static Annotation governingVerbGroup(Annotation annotation) {
        Annotation annotation2;
        if (annotation.get("subject-1") != null) {
            annotation2 = (Annotation)annotation.get("subject-1");
        } else if (annotation.get("object-1") != null) {
            annotation2 = (Annotation)annotation.get("object-1");
        } else {
            return null;
        }
        return Resolve.getHeadC(annotation2);
    }

    static String governingPreposition(Document document, Annotation annotation) {
        Annotation annotation2 = (Annotation)annotation.get("p-obj-1");
        if (annotation2 == null) {
            return null;
        }
        Annotation[] annotationArray = (Annotation[])annotation2.get("children");
        if (annotationArray.length != 2) {
            return null;
        }
        Annotation annotation3 = annotationArray[0];
        String string = document.text(annotation3).trim();
        return string;
    }

    public static void setPatternSet(String string) throws IOException {
        eve = new RelationPatternSet();
        eve.load(string, 0);
    }

    static {
        sourceType = "text";
        eve = null;
        eventTagger = null;
        docCount = 0;
        parseSuffix = ".sgm.sent.chout";
        writeEventConfidence = false;
        functionWord = new String[]{"a ", "an ", "the ", "his ", "her ", "its ", "against ", "as ", "at ", "by ", "due to ", "for ", "from ", "in ", "into ", "of ", "over ", "to ", "with ", "within ", "and ", "not ", "or ", "can ", "be ", "will "};
        locativePrepositions = new String[]{"in", "at", "to", "near"};
        genericFriendlyDeterminers = new String[]{"no", "neither", "any", "many", "every", "each"};
        clearGenericPronouns = new String[]{"everyone", "anyone", "everybody", "anybody", "something", "who", "whoever", "whomever", "wherever", "whatever", "where"};
        JetTest.validProperties.add("Ace.PerfectEntities");
        JetTest.validProperties.add("Ace.Value.fileName");
        JetTest.validProperties.add("Time.fileName");
        JetTest.validProperties.add("Ace.RelationPatterns.fileName");
        JetTest.validProperties.add("Ace.RelationModel.fileName");
        JetTest.validProperties.add("Ace.EventModels.directory");
        JetTest.validProperties.add("Ace.writeEventConfidence");
        JetTest.validProperties.add("Ace.EventModels.eventProbabilityThreshold");
        JetTest.validProperties.add("Ace.EventModels.argumentProbabilityThreshold");
        JetTest.validProperties.add("Ace.Year");
        JetTest.validProperties.add("Ace.extendedAPF");
        JetTest.validProperties.add("Ace.EDTtype.fileName");
        JetTest.validProperties.add("Ace.generic.fileName");
        JetTest.validProperties.add("Ace.writeEventConfidence");
        JetTest.validProperties.add("Ace.EventModels.eventProbabilityThreshold");
        JetTest.validProperties.add("Ace.EventModels.argumentProbabilityThreshold");
        JetTest.validProperties.add("Ace.Value.fileName");
        JetTest.validProperties.add("Gazetteer.fileName");
        JetTest.validProperties.add("Ace.NameSubtypeModel.fileName");
    }
}

