/*
 * Decompiled with CFR 0.152.
 */
package org.pnuts.tools;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import pnuts.ext.NonPublicMemberAccessor;
import pnuts.lang.Configuration;
import pnuts.lang.Context;
import pnuts.lang.Pnuts;
import pnuts.tools.ContextEvent;
import pnuts.tools.ContextListener;
import pnuts.tools.DebugContext;

public class InspectWatchView
extends JPanel
implements ContextListener {
    private static final Configuration debugConfig = new NonPublicMemberAccessor();
    private static final Font monospaced = Font.getFont("monospaced");
    JTextField inspectField = new JTextField(20);
    JTextArea result;
    Context currentContext;

    public InspectWatchView() {
        this.inspectField.setBackground(Color.white);
        this.inspectField.setFont(monospaced);
        this.inspectField.setAutoscrolls(true);
        this.result = new JTextArea(2, 0);
        this.result.setLineWrap(true);
        this.result.setEditable(false);
        JScrollPane resultpane = new JScrollPane(this.result);
        resultpane.setPreferredSize(new Dimension(300, 180));
        GridBagLayout gb = new GridBagLayout();
        this.setLayout(gb);
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 10;
        c.fill = 2;
        c.insets = new Insets(2, 2, 2, 2);
        gb.setConstraints(this.inspectField, c);
        this.add(this.inspectField);
        c.gridy = 1;
        c.weighty = 1.0;
        c.fill = 1;
        gb.setConstraints(resultpane, c);
        this.add(resultpane);
        this.inspectField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (InspectWatchView.this.currentContext == null) {
                    return;
                }
                try {
                    Context c = (Context)((DebugContext)InspectWatchView.this.currentContext).clone(false, false, true);
                    c.setConfiguration(debugConfig);
                    Object r = Pnuts.eval(InspectWatchView.this.inspectField.getText(), c);
                    InspectWatchView.this.result.setText(Pnuts.format(r));
                }
                catch (Exception e2) {
                    InspectWatchView.this.result.setText(e2.toString());
                }
            }
        });
    }

    public void update(ContextEvent event) {
        this.currentContext = event.getContext();
        String watch = this.inspectField.getText();
        if (watch != null && watch.length() > 0) {
            try {
                Context c = (Context)((DebugContext)this.currentContext).clone(false, false, true);
                c.setConfiguration(debugConfig);
                Object r = Pnuts.eval(watch, c);
                this.result.setText(Pnuts.format(r));
            }
            catch (Exception e2) {
                this.result.setText(e2.toString());
            }
        } else {
            this.result.setText("");
        }
    }
}

