/*
 * Decompiled with CFR 0.152.
 */
package Jet.HMM;

import Jet.HMM.HMM;
import Jet.HMM.HMMemitter;
import Jet.Lisp.FeatureSet;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class SuffixHMMemitter
extends HMMemitter {
    private static final float VOCAB_SIZE = 5000.0f;
    private static final int suffixLength = 3;
    private static final double threshold = 10.0;
    static int allStateCount = 0;
    static HashMap suffixCount = new HashMap();
    int count;
    HashMap tokenCount;
    HashMap tokenProbability;
    HashMap LCtokenCount;
    HashMap LCtokenProbability;
    HashMap featureCount;
    HashMap featureProbability;
    HashMap cacheCount;
    HashMap stateSuffixCount;
    HashMap stateSuffixTokens;
    HashMap suffixProbability;
    double[] inCacheProbability;
    double[] notInCacheProbability;
    double lambda;
    double unseenTokenProbability;

    public void resetForTraining() {
        this.count = 0;
        this.tokenCount = new HashMap();
        this.LCtokenCount = new HashMap();
        this.featureCount = new HashMap();
        this.cacheCount = new HashMap();
        this.stateSuffixCount = new HashMap();
        this.stateSuffixTokens = new HashMap();
    }

    public void setCacheCount(String string, int n) {
        this.cacheCount.put(string, new Integer(n));
    }

    public void trainOnInstances(String string, String string2, int n) {
        this.count += n;
        allStateCount += n;
        SuffixHMMemitter.incrementHashMap(this.tokenCount, string, n);
        SuffixHMMemitter.incrementHashMap(this.LCtokenCount, string.toLowerCase(), n);
        SuffixHMMemitter.incrementHashMap(this.featureCount, SuffixHMMemitter.wordFeature(string), n);
        if (this.hmm.tagsToCache != null) {
            for (int i = 0; i < this.hmm.tagsToCache.length; ++i) {
                if (!this.hmm.inCache(string, this.hmm.tagsToCache[i])) continue;
                SuffixHMMemitter.incrementHashMap(this.cacheCount, this.hmm.tagsToCache[i], 1);
            }
        }
        if (string.length() > 3) {
            String string3 = string.substring(string.length() - 3);
            SuffixHMMemitter.incrementHashMap(suffixCount, string3, n);
            SuffixHMMemitter.incrementHashMap(this.stateSuffixCount, string3, n);
            HashSet<String> hashSet = (HashSet<String>)this.stateSuffixTokens.get(string3);
            if (hashSet == null) {
                hashSet = new HashSet<String>();
            }
            hashSet.add(string);
            this.stateSuffixTokens.put(string3, hashSet);
        }
    }

    public void computeProbabilities() {
        int n;
        Object object;
        Integer n2;
        double d;
        this.tokenProbability = new HashMap();
        int n3 = 0;
        for (Map.Entry object2 : this.tokenCount.entrySet()) {
            String string = (String)object2.getKey();
            int n4 = (Integer)object2.getValue();
            double d2 = Math.log((double)n4 / (double)this.count);
            this.tokenProbability.put(string, new Double(d2));
            if (n4 != 1) continue;
            ++n3;
        }
        this.LCtokenProbability = new HashMap();
        for (Map.Entry entry : this.LCtokenCount.entrySet()) {
            String string = (String)entry.getKey();
            int n5 = (Integer)entry.getValue();
            double d3 = Math.log((double)n5 / (double)this.count);
            this.LCtokenProbability.put(string, new Double(d3));
        }
        this.featureProbability = new HashMap();
        for (Map.Entry entry : this.featureCount.entrySet()) {
            String string = (String)entry.getKey();
            int n6 = (Integer)entry.getValue();
            d = Math.log((double)n6 / (double)this.count);
            this.featureProbability.put(string, new Double(d));
        }
        Integer n7 = (Integer)this.featureCount.get("initCap");
        int n8 = (n7 == null ? 0 : n7) + ((n2 = (Integer)this.featureCount.get("lowerCase")) == null ? 0 : n2);
        if (n8 != 0) {
            d = Math.log((double)n8 / (double)this.count);
            this.featureProbability.put("forcedCap", new Double(d));
        }
        this.suffixProbability = new HashMap();
        for (Map.Entry entry : suffixCount.entrySet()) {
            double d4;
            object = (String)entry.getKey();
            n = (Integer)entry.getValue();
            HashSet hashSet = (HashSet)this.stateSuffixTokens.get(object);
            int n9 = hashSet == null ? 0 : hashSet.size();
            Integer n10 = (Integer)this.stateSuffixCount.get(object);
            int n11 = n10 == null ? 0 : n10;
            double d5 = n * this.count / allStateCount;
            if (n9 <= 5 || !((d4 = Math.log((double)(n11 + 2) / (d5 + 2.0))) > 0.0)) continue;
            if (HMM.probReport) {
                System.out.println("For state " + this.stateName + " pfactor(" + (String)object + ") = " + d4 + "tokens=" + hashSet);
            }
            this.suffixProbability.put(object, new Double(d4));
        }
        this.lambda = 1.0 / (1.0 + (double)this.tokenCount.size() / (double)this.count);
        this.unseenTokenProbability = Math.log((double)n3 / (double)this.count / 5000.0);
        if (this.hmm.tagsToCache != null) {
            this.inCacheProbability = new double[this.hmm.tagsToCache.length];
            this.notInCacheProbability = new double[this.hmm.tagsToCache.length];
            if (HMM.probReport) {
                System.out.println("For state " + this.stateName);
            }
            for (int i = 0; i < this.hmm.tagsToCache.length; ++i) {
                object = (Integer)this.cacheCount.get(this.hmm.tagsToCache[i]);
                int n12 = n = object == null ? 0 : (Integer)object;
                if (HMM.probReport) {
                    System.out.println("Cache count[" + this.hmm.tagsToCache[i] + "]=" + n);
                    System.out.println("inCacheProbability[" + this.hmm.tagsToCache[i] + "]=" + (double)n / (double)this.count);
                }
                this.inCacheProbability[i] = Math.log((double)n / (double)this.count);
                this.notInCacheProbability[i] = Math.log(1.0 - (double)n / (double)this.count);
            }
        }
    }

    public double getProbability(String string, String string2, FeatureSet featureSet) {
        String string3;
        Object object;
        double d;
        double d2 = -8.0;
        boolean bl = featureSet.get("case") == "forcedCap";
        Double d3 = bl ? (Double)this.LCtokenProbability.get(string.toLowerCase()) : (Double)this.tokenProbability.get(string);
        if (d3 != null) {
            d = d3;
        } else {
            String string4 = SuffixHMMemitter.wordFeature(string);
            if (bl && string4 == "initCap") {
                string4 = "forcedCap";
            }
            d = (object = (Double)this.featureProbability.get(string4)) != null ? this.unseenTokenProbability + (Double)object : this.unseenTokenProbability + d2;
        }
        if (this.hmm.tagsToCache != null) {
            for (int i = 0; i < this.hmm.tagsToCache.length; ++i) {
                object = this.hmm.tagsToCache[i];
                boolean bl2 = this.hmm.inCache(string, (String)object);
                if (bl2) {
                    d += this.inCacheProbability[i];
                    continue;
                }
                d += this.notInCacheProbability[i];
            }
        }
        if (string.length() > 3 && (object = (Double)this.suffixProbability.get(string3 = string.substring(string.length() - 3))) != null) {
            d += ((Double)object).doubleValue();
        }
        return d;
    }

    public void print() {
        for (Map.Entry entry : this.featureProbability.entrySet()) {
            String string = (String)entry.getKey();
            double d = (Double)entry.getValue();
            System.out.println("EMIT " + string + " " + d);
        }
    }

    public void store(PrintWriter printWriter) {
        for (Map.Entry object : this.tokenCount.entrySet()) {
            String string = (String)object.getKey();
            int n = (Integer)object.getValue();
            printWriter.println("EMIT " + string + " " + n);
        }
        for (Map.Entry entry : this.cacheCount.entrySet()) {
            String string = (String)entry.getKey();
            int n = (Integer)entry.getValue();
            printWriter.println("PREVTAGGED " + string + " " + n);
        }
    }

    static String wordFeature(String string) {
        int n = string.length();
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = true;
        boolean bl5 = true;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (!Character.isDigit(c)) {
                bl = false;
            }
            if (!Character.isUpperCase(c)) {
                bl2 = false;
            }
            if (!Character.isLowerCase(c)) {
                bl4 = false;
            }
            if (!Character.isLetter(c) && c != '-') {
                bl5 = false;
            }
            if ((i != 0 || Character.isUpperCase(c)) && (i <= 0 || Character.isLowerCase(c))) continue;
            bl3 = false;
        }
        if (bl) {
            if (n == 2) {
                return "twoDigitNum";
            }
            if (n == 4) {
                return "fourDigitNum";
            }
            return "otherNum";
        }
        if (bl2) {
            return "allCaps";
        }
        if (bl3) {
            return "initCap";
        }
        if (bl4) {
            return "lowerCase";
        }
        if (bl5) {
            return "hyphenated";
        }
        return "other";
    }

    private static void incrementHashMap(HashMap hashMap, String string, int n) {
        Integer n2 = (Integer)hashMap.get(string);
        int n3 = n2 == null ? 0 : n2;
        hashMap.put(string, new Integer(n3 + n));
    }
}

