/*
 * Decompiled with CFR 0.152.
 */
package Jet.HMM;

import Jet.HMM.HMM;
import Jet.HMM.HMMarc;
import Jet.HMM.HMMemitter;
import Jet.Tipster.Annotation;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class HMMstate {
    public String name;
    public String tag;
    private HMM hmm;
    private String featureName;
    private ArrayList allowedFeatureValues;
    HMMemitter emitter;
    HashSet arcset;
    HMMarc[] arcs;
    int count;
    public static double otherPreference = 1.0;

    public HMMstate(String string, String string2, Class clazz) {
        this.name = string;
        this.tag = string2;
        this.featureName = null;
        this.allowedFeatureValues = new ArrayList();
        try {
            this.emitter = (HMMemitter)clazz.newInstance();
            this.emitter.stateName = string;
        }
        catch (Exception exception) {
            System.out.println("Cannot create instance of HMMemitter " + clazz);
        }
        this.arcset = new HashSet();
        this.hmm = null;
    }

    public void addArc(HMMarc hMMarc) {
        this.arcset.add(hMMarc);
    }

    public void addArc(String string) {
        this.addArc(new HMMarc(string, 0));
    }

    public void resolveNames(HashMap hashMap, int n) {
        this.arcs = new HMMarc[n];
        for (HMMarc hMMarc : this.arcset) {
            hMMarc.resolveTarget(hashMap);
            this.arcs[hMMarc.target] = hMMarc;
        }
    }

    public void setHMM(HMM hMM) {
        this.hmm = hMM;
        this.emitter.hmm = hMM;
    }

    public void resetForTraining() {
        this.count = 0;
        this.emitter.resetForTraining();
        for (HMMarc hMMarc : this.arcset) {
            hMMarc.resetForTraining();
        }
    }

    public void incrementEmitCount(String string, String string2, int n) {
        this.emitter.trainOnInstances(string, string2, n);
    }

    public void setCacheCount(String string, int n) {
        this.emitter.setCacheCount(string, n);
    }

    public void setFeatureName(String string) {
        this.featureName = string;
    }

    public void addAllowedFeatureValue(String string) {
        this.allowedFeatureValues.add(string);
    }

    public boolean allowedToken(Annotation annotation) {
        if (this.featureName == null) {
            return true;
        }
        return this.allowedFeatureValues.contains(annotation.get(this.featureName));
    }

    public void computeProbabilities() {
        if (HMM.probReport) {
            System.out.println();
            System.out.println("===== Computing probabilities for " + this.name);
            System.out.println("state count = " + this.count);
        }
        for (HMMarc hMMarc : this.arcset) {
            hMMarc.computeProbabilities(this.count);
        }
        this.emitter.computeProbabilities();
    }

    public void print() {
        System.out.println("STATE " + this.name);
        if (this.tag != "") {
            System.out.println("TAG " + this.tag);
        }
        if (this.featureName != null) {
            System.out.print("FEATURE " + this.featureName);
            for (int i = 0; i < this.allowedFeatureValues.size(); ++i) {
                System.out.print(" " + this.allowedFeatureValues.get(i));
            }
            System.out.println();
        }
        Iterator iterator = this.arcset.iterator();
        while (iterator.hasNext()) {
            ((HMMarc)iterator.next()).print();
        }
        this.emitter.print();
    }

    public void store(PrintWriter printWriter) {
        printWriter.println("STATE " + this.name + " " + this.count);
        if (this.tag != "") {
            printWriter.println("TAG " + this.tag);
        }
        if (this.featureName != null) {
            printWriter.print("FEATURE " + this.featureName);
            for (int i = 0; i < this.allowedFeatureValues.size(); ++i) {
                printWriter.print(" " + this.allowedFeatureValues.get(i));
            }
            printWriter.println();
        }
        Iterator iterator = this.arcset.iterator();
        while (iterator.hasNext()) {
            ((HMMarc)iterator.next()).store(printWriter);
        }
        this.emitter.store(printWriter);
    }

    public double getEmissionProb(String string, String string2, Annotation annotation) {
        if (!this.allowedToken(annotation)) {
            return -1.0E100;
        }
        double d = this.emitter.getProbability(string, string2, annotation.attributes());
        if (this.tag.equals("other")) {
            d += otherPreference;
        }
        return d;
    }

    public double getTransitionProb(int n) {
        HMMarc hMMarc = this.arcs[n];
        if (hMMarc != null) {
            return hMMarc.probability;
        }
        return -1.0E100;
    }
}

