/*
 * Decompiled with CFR 0.152.
 */
package AceJet;

import AceJet.AceDocument;
import AceJet.AceEventArgument;
import AceJet.AceEventMention;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AceEvent {
    public String type;
    public String subtype;
    public String modality = "Asserted";
    public String polarity = "Positive";
    public String genericity = "Specific";
    public String tense = "Past";
    public String id;
    public ArrayList<AceEventArgument> arguments = new ArrayList();
    public ArrayList<AceEventMention> mentions = new ArrayList();

    public AceEvent(String string, String string2, String string3) {
        this.id = string;
        this.type = string2;
        this.subtype = string3;
    }

    public AceEvent(Element element, AceDocument aceDocument, String string) {
        Object object;
        this.id = element.getAttribute("ID");
        this.type = element.getAttribute("TYPE");
        this.subtype = element.getAttribute("SUBTYPE");
        this.modality = element.getAttribute("MODALITY");
        this.polarity = element.getAttribute("POLARITY");
        this.genericity = element.getAttribute("GENERICITY");
        this.tense = element.getAttribute("TENSE");
        NodeList nodeList = element.getElementsByTagName("event_argument");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            object = new AceEventArgument(element2, aceDocument);
            this.addArgument((AceEventArgument)object);
        }
        NodeList nodeList2 = element.getElementsByTagName("event_mention");
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            object = (Element)nodeList2.item(i);
            AceEventMention aceEventMention = new AceEventMention((Element)object, aceDocument, string);
            this.addMention(aceEventMention);
        }
    }

    void setId(String string) {
        this.id = string;
    }

    public void addMention(AceEventMention aceEventMention) {
        this.mentions.add(aceEventMention);
    }

    void addArgument(AceEventArgument aceEventArgument) {
        this.arguments.add(aceEventArgument);
    }

    public void write(PrintWriter printWriter) {
        Object object;
        int n;
        printWriter.print("  <event ID=\"" + this.id + "\" TYPE=\"" + this.type + "\"");
        if (this.subtype != null && !this.subtype.equals("")) {
            printWriter.print(" SUBTYPE=\"" + this.subtype + "\"");
        }
        printWriter.print(" MODALITY=\"" + this.modality + "\"");
        printWriter.print(" POLARITY=\"" + this.polarity + "\"");
        printWriter.print(" GENERICITY=\"" + this.genericity + "\"");
        printWriter.print(" TENSE=\"" + this.tense + "\"");
        printWriter.println(">");
        for (n = 0; n < this.arguments.size(); ++n) {
            object = this.arguments.get(n);
            ((AceEventArgument)object).write(printWriter);
        }
        for (n = 0; n < this.mentions.size(); ++n) {
            object = this.mentions.get(n);
            ((AceEventMention)object).write(printWriter);
        }
        printWriter.println("  </event>");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("event ");
        stringBuffer.append(this.type);
        stringBuffer.append(".");
        stringBuffer.append(this.subtype);
        stringBuffer.append("{");
        for (int i = 0; i < this.mentions.size(); ++i) {
            AceEventMention aceEventMention = this.mentions.get(i);
            stringBuffer.append(aceEventMention.toString());
        }
        stringBuffer.append("} ");
        return stringBuffer.toString();
    }
}

