/*
 * Decompiled with CFR 0.152.
 */
package org.ho.yaml.wrapper;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.ho.yaml.YamlConfig;
import org.ho.yaml.exception.ObjectCreationException;
import org.ho.yaml.wrapper.ObjectWrapper;

public abstract class AbstractWrapper
implements ObjectWrapper {
    Class type;
    Object object;
    List<ObjectWrapper.CreateListener> listeners = new ArrayList<ObjectWrapper.CreateListener>();
    boolean objectInitialized = false;
    YamlConfig config;

    protected AbstractWrapper(Class clazz) {
        this.type = clazz;
    }

    protected void fireCreated() {
        for (ObjectWrapper.CreateListener createListener : this.listeners) {
            createListener.created(this.object);
        }
    }

    protected Object createObject() {
        try {
            if (this.config.isConstructorAccessibleForDecoding(this.type)) {
                Constructor constructor = this.type.getDeclaredConstructor(null);
                constructor.setAccessible(true);
                return constructor.newInstance(new Object[0]);
            }
            throw new ObjectCreationException("Default constructor for " + this.type + " is not accessible.");
        }
        catch (Exception exception) {
            throw new ObjectCreationException("Can't create object of type " + this.type + " using default constructor.", exception);
        }
    }

    public void addCreateHandler(ObjectWrapper.CreateListener createListener) {
        if (this.object == null) {
            this.listeners.add(createListener);
        } else {
            createListener.created(this.object);
        }
    }

    public Class getType() {
        return this.type;
    }

    public void setObject(Object object) {
        if (object == null) {
            this.object = null;
            this.objectInitialized = true;
        } else {
            this.object = object;
            this.objectInitialized = true;
            this.fireCreated();
        }
    }

    public Object getObject() {
        if (!this.objectInitialized) {
            this.setObject(this.createObject());
            return this.object;
        }
        return this.object;
    }

    public Object createPrototype() {
        return this.createObject();
    }

    public String toString() {
        return this.object == null ? "[" + this.getType() + "]" : "[" + this.object + "]";
    }

    public ObjectWrapper makeWrapper() {
        return null;
    }

    public void setYamlConfig(YamlConfig yamlConfig) {
        this.config = yamlConfig;
    }
}

