/*
 * Decompiled with CFR 0.152.
 */
package tratz.jwni;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import tratz.jwni.IndexEntry;
import tratz.jwni.POS;
import tratz.jwni.WordNet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MorphoProcessor {
    private WordNet mWn;
    private static final List<SuffixRule> NOUN_RULES = new ArrayList<SuffixRule>();
    private static final List<SuffixRule> VERB_RULES = new ArrayList<SuffixRule>();
    private static final List<SuffixRule> ADJ_RULES = new ArrayList<SuffixRule>();
    private static final Map<POS, List<SuffixRule>> POS_TO_RULES = new HashMap<POS, List<SuffixRule>>();
    private Map<String, String> mNounExceptions = new HashMap<String, String>();
    private Map<String, String> mVerbExceptions = new HashMap<String, String>();
    private Map<String, String> mAdjExceptions = new HashMap<String, String>();
    private Map<POS, Map<String, String>> mPosToExceptionsMap = new HashMap<POS, Map<String, String>>();

    public MorphoProcessor(WordNet wn, URL nounExceptionsURL, URL verbExceptionsURL, URL adjExceptionsURL) throws IOException {
        this.mWn = wn;
        this.readExceptions(nounExceptionsURL, this.mNounExceptions);
        this.readExceptions(verbExceptionsURL, this.mVerbExceptions);
        this.readExceptions(adjExceptionsURL, this.mAdjExceptions);
        this.mPosToExceptionsMap.put(POS.NOUN, this.mNounExceptions);
        this.mPosToExceptionsMap.put(POS.VERB, this.mVerbExceptions);
        this.mPosToExceptionsMap.put(POS.ADJECTIVE, this.mAdjExceptions);
    }

    public MorphoProcessor(WordNet wn, String base) throws IOException {
        this(wn, URI.create(base + "noun.exc").toURL(), URI.create(base + "verb.exc").toURL(), URI.create(base + "adj.exc").toURL());
    }

    public MorphoProcessor(WordNet wn, File basedir) throws IOException {
        this(wn, new File(basedir, "noun.exc").toURI().toURL(), new File(basedir, "verb.exc").toURI().toURL(), new File(basedir, "adj.exc").toURI().toURL());
    }

    private void readExceptions(URL url, Map<String, String> exceptions) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
        String line = null;
        while ((line = reader.readLine()) != null) {
            String[] split = line.split("\\s+");
            exceptions.put(split[0], split[1]);
        }
        reader.close();
    }

    public IndexEntry lookupIndexEntry(POS pos, String word, boolean splitIfNecessary) {
        String[] split;
        IndexEntry entry = this.mWn.getIndexEntry(pos, word = word.trim().toLowerCase().replaceAll("\\s+", "_"));
        if (entry == null) {
            List<SuffixRule> rules;
            String exceptionOption;
            Map<String, String> exceptions = this.mPosToExceptionsMap.get((Object)pos);
            if (exceptions != null && (exceptionOption = exceptions.get(word)) != null) {
                entry = this.mWn.getIndexEntry(pos, exceptionOption);
            }
            if (entry == null && (rules = POS_TO_RULES.get((Object)pos)) != null) {
                SuffixRule rule;
                String newWord;
                Iterator<SuffixRule> i$ = rules.iterator();
                while (i$.hasNext() && (entry = this.mWn.getIndexEntry(pos, newWord = word.replaceAll((rule = i$.next()).originalSuffix, rule.newSuffix))) == null) {
                }
            }
        }
        if (entry == null && splitIfNecessary && (split = word.split("[^a-z]")).length > 1) {
            entry = this.lookupIndexEntry(pos, split[split.length - 1], splitIfNecessary);
        }
        return entry;
    }

    static {
        NOUN_RULES.add(new SuffixRule("s$", ""));
        NOUN_RULES.add(new SuffixRule("ses$", "s"));
        NOUN_RULES.add(new SuffixRule("xes$", "x"));
        NOUN_RULES.add(new SuffixRule("zes$", "z"));
        NOUN_RULES.add(new SuffixRule("ches$", "ch"));
        NOUN_RULES.add(new SuffixRule("shes$", "sh"));
        NOUN_RULES.add(new SuffixRule("men$", "man"));
        NOUN_RULES.add(new SuffixRule("ies$", "y"));
        VERB_RULES.add(new SuffixRule("s$", ""));
        VERB_RULES.add(new SuffixRule("ies$", "y"));
        VERB_RULES.add(new SuffixRule("es$", "e"));
        VERB_RULES.add(new SuffixRule("es$", ""));
        VERB_RULES.add(new SuffixRule("ed$", "e"));
        VERB_RULES.add(new SuffixRule("ed$", ""));
        VERB_RULES.add(new SuffixRule("ing$", "e"));
        VERB_RULES.add(new SuffixRule("ing$", ""));
        ADJ_RULES.add(new SuffixRule("er$", ""));
        ADJ_RULES.add(new SuffixRule("est$", ""));
        ADJ_RULES.add(new SuffixRule("er$", "e"));
        ADJ_RULES.add(new SuffixRule("est$", "e"));
        POS_TO_RULES.put(POS.NOUN, NOUN_RULES);
        POS_TO_RULES.put(POS.VERB, VERB_RULES);
        POS_TO_RULES.put(POS.ADJECTIVE, ADJ_RULES);
    }

    private static class SuffixRule {
        private String originalSuffix;
        private String newSuffix;

        public SuffixRule(String originalSuffix, String newSuffix) {
            this.originalSuffix = originalSuffix;
            this.newSuffix = newSuffix;
        }
    }
}

