/*
 * Decompiled with CFR 0.152.
 */
package org.ho.yaml;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.ho.yaml.ReflectionUtil;
import org.ho.yaml.Utilities;
import org.ho.yaml.YamlConfig;
import org.ho.yaml.wrapper.CollectionWrapper;
import org.ho.yaml.wrapper.MapWrapper;
import org.ho.yaml.wrapper.ObjectWrapper;
import org.ho.yaml.wrapper.SimpleObjectWrapper;

public class YamlEncoder {
    PrintWriter out;
    Map<Object, ObjectEntry> referenceMap = new IdentityHashMap<Object, ObjectEntry>();
    NameGenerator nameGenerator = new NameGenerator();
    YamlConfig config = YamlConfig.getDefaultConfig();

    public YamlEncoder(OutputStream outputStream) {
        try {
            this.out = new PrintWriter(new OutputStreamWriter(outputStream, this.config.encoding));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public YamlEncoder(OutputStream outputStream, YamlConfig yamlConfig) {
        try {
            this.config = yamlConfig;
            this.out = new PrintWriter(new OutputStreamWriter(outputStream, yamlConfig.encoding));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public String getIndentAmount() {
        return this.config.getIndentAmount();
    }

    public void setIndentAmount(String string) {
        this.config.setIndentAmount(string);
    }

    public boolean isMinimalOutput() {
        return this.config.isMinimalOutput();
    }

    public void setMinimalOutput(boolean bl) {
        this.config.setMinimalOutput(bl);
    }

    void traverseAndCount(Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof String) {
            return;
        }
        this.mark(object);
        if (this.refCount(object) > 1) {
            return;
        }
        if (ReflectionUtil.isSimpleType(object.getClass())) {
            return;
        }
        ObjectWrapper objectWrapper = this.getConfig().getWrapper(object);
        if (objectWrapper instanceof CollectionWrapper) {
            this.traverseAndCountCollection((CollectionWrapper)objectWrapper);
        } else if (objectWrapper instanceof MapWrapper) {
            this.traverseAndCountMap((MapWrapper)objectWrapper);
        }
    }

    void traverseAndCountCollection(CollectionWrapper collectionWrapper) {
        for (Object t : collectionWrapper) {
            this.traverseAndCount(t);
        }
    }

    void traverseAndCountMap(MapWrapper mapWrapper) {
        for (Object e : mapWrapper.keys()) {
            Object object = mapWrapper.get(e);
            this.traverseAndCount(e);
            this.traverseAndCount(object);
        }
    }

    int refCount(Object object) {
        ObjectEntry objectEntry = this.referenceMap.get(object);
        return objectEntry != null ? objectEntry.refs : 0;
    }

    boolean toBeAnchored(Object object) {
        ObjectEntry objectEntry = this.referenceMap.get(object);
        return objectEntry != null && objectEntry.refs > 1 && !objectEntry.anchorDeclared;
    }

    boolean toBeAliased(Object object) {
        ObjectEntry objectEntry = this.referenceMap.get(object);
        return objectEntry != null && objectEntry.refs > 1 && objectEntry.anchorDeclared;
    }

    void mark(Object object) {
        ObjectEntry objectEntry = this.referenceMap.get(object);
        if (objectEntry == null) {
            objectEntry = new ObjectEntry(object);
            this.referenceMap.put(object, objectEntry);
        }
        ++objectEntry.refs;
    }

    void generateNames() {
        for (Map.Entry<Object, ObjectEntry> entry : this.referenceMap.entrySet()) {
            if (entry.getValue().refs < 2) continue;
            entry.getValue().refname = this.generateName(entry.getValue());
        }
    }

    String generateName(Object object) {
        return this.nameGenerator.generate(object);
    }

    public void writeObject(Object object) {
        this.traverseAndCount(object);
        this.generateNames();
        this.out.print("--- ");
        this.writeObject(object, "", object.getClass());
        this.reset();
    }

    void reset() {
        this.referenceMap.clear();
        this.nameGenerator = new NameGenerator();
    }

    String indent(String string) {
        return this.getIndentAmount() + string;
    }

    void writeObject(Object object, String string, Class clazz) {
        if (object == null) {
            this.out.println("~");
        } else if (this.toBeAliased(object)) {
            this.writeReference(object);
        } else {
            ObjectWrapper objectWrapper;
            if (this.toBeAnchored(object)) {
                this.writeAlias(object);
            }
            if ((objectWrapper = this.getConfig().getWrapper(object)) instanceof SimpleObjectWrapper) {
                this.writeSimpleValue((SimpleObjectWrapper)objectWrapper, clazz, string);
            } else if (objectWrapper instanceof CollectionWrapper) {
                this.writeCollection((CollectionWrapper)objectWrapper, clazz, string);
            } else if (objectWrapper instanceof MapWrapper) {
                this.writeMap((MapWrapper)objectWrapper, string, clazz);
            }
        }
    }

    void writeReference(Object object) {
        ObjectEntry objectEntry = this.referenceMap.get(object);
        this.out.println("*" + objectEntry.refname);
    }

    void writeAlias(Object object) {
        ObjectEntry objectEntry = this.referenceMap.get(object);
        this.out.print("&" + objectEntry.refname + " ");
        objectEntry.anchorDeclared = true;
    }

    void writeSimpleValue(SimpleObjectWrapper simpleObjectWrapper, Class clazz, String string) {
        Object object;
        if (!(Utilities.classEquals(clazz, simpleObjectWrapper.getType()) && this.isMinimalOutput() || simpleObjectWrapper.getType() == Integer.class || simpleObjectWrapper.getType() == Boolean.class || simpleObjectWrapper.getType() == String.class)) {
            this.out.print("!" + this.getTransferName(simpleObjectWrapper.getType()) + " ");
        }
        if ((object = simpleObjectWrapper.getOutputValue()) == null) {
            this.out.println("~");
        } else if (object instanceof String || object instanceof Character) {
            this.out.println(Utilities.stringify(object, string));
        } else {
            this.out.println(object);
        }
    }

    void writeMap(MapWrapper mapWrapper, String string, Class clazz) {
        if (this.isMinimalOutput() && clazz == mapWrapper.getType() || clazz == HashMap.class || clazz == Map.class) {
            this.out.print("");
        } else {
            this.out.print("!" + this.getTransferName(mapWrapper.getType()));
        }
        if (mapWrapper.keys().size() == 0) {
            this.out.println(" {}");
        } else {
            this.out.println("");
            for (Object e : mapWrapper.keys()) {
                Object object = mapWrapper.get(e);
                this.out.print(string + Utilities.stringify(e) + ": ");
                this.writeObject(object, this.indent(string), mapWrapper.getExpectedType(e));
            }
        }
    }

    void writeCollection(CollectionWrapper collectionWrapper, Class clazz, String string) {
        if (collectionWrapper.size() > 0) {
            if (this.isMinimalOutput() && clazz == collectionWrapper.getType() || collectionWrapper.getType() == ArrayList.class || clazz == List.class) {
                this.out.println();
            } else {
                this.out.println("!" + this.getTransferName(collectionWrapper.getType()));
            }
            for (Object t : collectionWrapper) {
                this.out.print(string + "- ");
                this.writeObject(t, this.indent(string), collectionWrapper.isTyped() ? collectionWrapper.componentType() : null);
            }
        } else {
            if (this.isMinimalOutput() && clazz == collectionWrapper.getType() || collectionWrapper.getType() == ArrayList.class || clazz == List.class) {
                this.out.print("");
            } else {
                this.out.print("!" + this.getTransferName(collectionWrapper.getType()) + " ");
            }
            if (collectionWrapper.size() == 0) {
                this.out.println("[]");
            }
        }
    }

    boolean same(Object object, Object object2) {
        if (object != null) {
            return object.equals(object2);
        }
        if (object2 != null) {
            return object2.equals(object);
        }
        return true;
    }

    String getTransferName(Class clazz) {
        return ReflectionUtil.className(clazz, this.config);
    }

    public void close() {
        this.out.close();
    }

    public void flush() {
        this.out.flush();
    }

    public YamlConfig getConfig() {
        return this.config;
    }

    public void setConfig(YamlConfig yamlConfig) {
        this.config = yamlConfig;
    }

    class NameGenerator {
        BigInteger i = BigInteger.ONE;

        NameGenerator() {
        }

        String generate(Object object) {
            String string = this.i.toString();
            this.i = this.i.add(BigInteger.ONE);
            return string;
        }
    }

    class ObjectEntry {
        Object target;
        String refname = null;
        int refs = 0;
        boolean anchorDeclared = false;

        ObjectEntry(Object object) {
            this.target = object;
        }

        public String toString() {
            return "{target: " + this.target + ", refname: " + this.refname + ", refs: " + this.refs + "}";
        }
    }
}

