/*
 * Decompiled with CFR 0.152.
 */
package Jet.Chunk;

import Jet.Format.InvalidFormatException;
import Jet.Format.PTBReader;
import Jet.Format.Treebank;
import Jet.Lisp.FeatureSet;
import Jet.Parser.ParseTreeNode;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import Jet.Tipster.Span;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeBasedChunker {
    private static final Set<String> PRUNE_ALWAYS = new HashSet<String>(Arrays.asList("NAC", "QP", "NX", "X"));
    private static final Set<List<String>> PRUNE_IF_IN_FRONT_OF_HEAD = new HashSet<List<String>>();
    private static final Map<String, Pattern> HEAD_CAT;
    private static final Map<String, Pattern> HEAD;
    private static final String chunkTagName = "chunk";

    public static void main(String[] stringArray) throws IOException, InvalidFormatException {
        PTBReader pTBReader = new PTBReader();
        File file = new File("testdata/wsj_0001.mrg");
        Treebank treebank = pTBReader.load(file);
        Document document = treebank.getDocument();
        TreeBasedChunker treeBasedChunker = new TreeBasedChunker();
        for (ParseTreeNode parseTreeNode : treebank.getParseTreeList()) {
            treeBasedChunker.chunk(document, parseTreeNode);
        }
        document.setSGMLwrapMargin(0);
        System.out.println(document.writeSGML(chunkTagName));
    }

    public void chunk(Document document, ParseTreeNode parseTreeNode) {
        Node node = TreeBasedChunker.convert(parseTreeNode);
        this.prune(node);
        List<Terminal> list = this.flatten(node);
        this.chunks(list);
        int n = 0;
        while (n < list.size()) {
            Terminal terminal = list.get(n);
            String string = terminal.getChunkTag();
            if (string.startsWith("B-")) {
                String string2 = string.substring(2);
                String string3 = "I-" + string2;
                int n2 = terminal.span().start();
                int n3 = terminal.span().end();
                ++n;
                while (n < list.size() && list.get(n).getChunkTag().equals(string3)) {
                    n3 = list.get(n).span().end();
                    ++n;
                }
                Span span = new Span(n2, n3);
                FeatureSet featureSet = new FeatureSet("type", string2);
                document.annotate(chunkTagName, span, featureSet);
                continue;
            }
            ++n;
        }
    }

    private List<Terminal> flatten(Node node) {
        return this.flatten(node, new FlattenState());
    }

    private List<Terminal> flatten(Node node, FlattenState flattenState) {
        Matcher matcher = Pattern.compile("([A-Z]+)").matcher(node.getFunction());
        if (node.isTerminal()) {
            return Collections.singletonList((Terminal)node);
        }
        if (!node.isTerminal() && matcher.lookingAt()) {
            String string = matcher.group(1);
            NonTerminal nonTerminal = (NonTerminal)node;
            List<Node> list = nonTerminal.getChildren();
            ++flattenState.chunkNumber;
            for (Node object : list) {
                if (object.isTerminal()) {
                    Terminal terminal = (Terminal)object;
                    terminal.setChunkTag(String.format("I-%s-%d", string, flattenState.chunkNumber));
                }
                if (!object.isHead()) continue;
                String string2 = object.getFunction();
                if (string2.length() == 0 || string2.startsWith(string)) {
                    object.setFunction(string);
                    continue;
                }
                object.setFunction(String.format("%s/%s", string2, string));
            }
            ArrayList arrayList = new ArrayList();
            for (Node node2 : list) {
                arrayList.addAll(this.flatten(node2, flattenState));
            }
            return arrayList;
        }
        System.err.println(node.getFunction());
        throw new RuntimeException();
    }

    private void chunks(List<Terminal> list) {
        String string = null;
        int n = -1;
        int n2 = -1;
        Pattern pattern = Pattern.compile("^ I - ([A-Z]+) - ([0-9]+) $", 4);
        for (int i = list.size() - 1; i >= 0; --i) {
            Matcher matcher;
            Terminal terminal = list.get(i);
            Terminal terminal2 = null;
            if (i < list.size() - 1) {
                terminal2 = list.get(i + 1);
            }
            if (!(matcher = pattern.matcher(terminal.getChunkTag())).matches()) continue;
            String string2 = matcher.group(1);
            int n3 = Integer.parseInt(matcher.group(2));
            if (string2.startsWith("WH")) {
                string2 = string2.substring(2);
            }
            if (terminal.getFunction().length() > 0) {
                string = string2;
                n = n3;
                terminal.setChunkTag(String.format("I-%s", string2));
            } else if (string2.equals(string) && n3 == n) {
                terminal.setChunkTag(String.format("I-%s", string2));
            } else if (terminal.getParfOfSpeech().equals("POS")) {
                terminal.setChunkTag("I-NP");
                n3 = terminal2 != null && Pattern.matches("^.-NP", terminal2.getChunkTag()) ? n2 : -2;
            } else {
                terminal.setChunkTag("O");
            }
            if (n2 != n3) {
                String string3;
                if (string2.startsWith("I-")) {
                    terminal.setChunkTag("E-" + string2.substring(2));
                }
                if (string2.startsWith("E-")) {
                    terminal.setChunkTag("C-" + string2.substring(2));
                }
                if (terminal2 != null && (string3 = terminal2.getChunkTag()).startsWith("I-")) {
                    terminal2.setChunkTag("B-" + string3.substring(2));
                }
            }
            n2 = n3;
        }
        Terminal terminal = list.get(0);
        if (terminal.getChunkTag().startsWith("I-")) {
            terminal.setChunkTag("B-" + terminal.getChunkTag().substring(2));
        }
        if (terminal.getChunkTag().startsWith("E-")) {
            terminal.setChunkTag("E-" + terminal.getChunkTag().substring(2));
        }
    }

    private void prune(Node node) {
        if (node.isTerminal()) {
            return;
        }
        this.pruneRecursive((NonTerminal)node);
    }

    private void pruneRecursive(NonTerminal nonTerminal) {
        PruneState pruneState = new PruneState();
        List<Node> list = nonTerminal.getChildren();
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i).isTerminal()) {
                this.checkTerminal(nonTerminal, i, pruneState);
                continue;
            }
            if (!this.checkNonTerminal(nonTerminal, i, pruneState)) continue;
            --i;
        }
        this.markHead(nonTerminal, pruneState);
        this.pruneADVPInVP(nonTerminal, pruneState);
        for (Node node : list) {
            if (node.isTerminal()) continue;
            this.pruneRecursive((NonTerminal)node);
        }
    }

    private void markHead(NonTerminal nonTerminal, PruneState pruneState) {
        if (pruneState.lastNonRef.size() > 0) {
            int n = pruneState.lastNonRef.get(pruneState.lastNonRef.size() - 1);
            nonTerminal.getChild(n).setHead(true);
        } else if (pruneState.subFunctions.size() > 0) {
            if (pruneState.cc) {
                for (int n : pruneState.subFunctions) {
                    nonTerminal.getChild(n).setHead(true);
                }
            } else {
                nonTerminal.getChild(pruneState.subFunctions.get(0)).setHead(true);
            }
        }
    }

    private void pruneADVPInVP(NonTerminal nonTerminal, PruneState pruneState) {
        String string = nonTerminal.getFunction();
        if (string.equals("VP") && pruneState.adverbs.size() > 0 && pruneState.lastNonRef.size() > 0) {
            int n = 0;
            List<Integer> list = pruneState.adverbs;
            int n2 = pruneState.lastNonRef.get(pruneState.lastNonRef.size() - 1);
            for (int i = 0; i < list.size() && list.get(i) < n2; ++i) {
                int n3 = list.get(i) + n;
                if (nonTerminal.getChild(n3).isTerminal()) continue;
                NonTerminal nonTerminal2 = (NonTerminal)nonTerminal.getChild(n3);
                n += nonTerminal2.getChildren().size() - 1;
                nonTerminal.getChildren().remove(n3);
                nonTerminal.getChildren().addAll(n3, nonTerminal2.getChildren());
            }
        }
    }

    private void checkTerminal(NonTerminal nonTerminal, int n, PruneState pruneState) {
        String string;
        String string2 = nonTerminal.getFunction();
        if (this.isHeadOf(string2, string = ((Terminal)nonTerminal.getChild(n)).getParfOfSpeech())) {
            pruneState.lastNonRef.add(n);
        }
        if (n > 0 && string.startsWith("CC")) {
            pruneState.cc = true;
        } else if (string.startsWith("RB")) {
            pruneState.adverbs.add(n);
        }
    }

    private boolean isHeadOf(String string, String string2) {
        Pattern pattern = HEAD.get(string);
        if (pattern != null) {
            return pattern.matcher(string2).lookingAt();
        }
        return false;
    }

    private boolean checkNonTerminal(NonTerminal nonTerminal, int n, PruneState pruneState) {
        String string = nonTerminal.getFunction();
        String string2 = nonTerminal.getChild(n).getFunction();
        if (PRUNE_ALWAYS.contains(string2)) {
            this.simplePrune(nonTerminal, n);
            return true;
        }
        if (PRUNE_IF_IN_FRONT_OF_HEAD.contains(Arrays.asList(string, string2)) && pruneState.subFunctions.size() == 0) {
            this.simplePrune(nonTerminal, n);
            return true;
        }
        if (this.pruneSInVPCondition(nonTerminal, n, pruneState)) {
            return this.pruneSInVP(nonTerminal, n);
        }
        if (string.equals("VP") && string2.equals("VP") && this.isVerbsOrAdverbsInFront(n, pruneState)) {
            this.simplePrune(nonTerminal, n);
            return true;
        }
        if (string.equals("VP") && string2.equals("ADVP")) {
            pruneState.adverbs.add(n);
            return false;
        }
        if (HEAD_CAT.containsKey(string) && HEAD_CAT.get(string).matcher(string2).matches()) {
            if (!this.npCondition(nonTerminal, n, pruneState)) {
                pruneState.subFunctions.add(n);
            }
            return false;
        }
        if (string2.equals("CONJP")) {
            pruneState.cc = true;
            return false;
        }
        return false;
    }

    private boolean isVerbsOrAdverbsInFront(int n, PruneState pruneState) {
        int n2 = pruneState.lastNonRef.size() + pruneState.adverbs.size();
        return n2 > 0 && n == n2;
    }

    private void simplePrune(NonTerminal nonTerminal, int n) {
        List<Node> list = nonTerminal.getChildren();
        NonTerminal nonTerminal2 = (NonTerminal)list.get(n);
        list.remove(n);
        list.addAll(n, nonTerminal2.getChildren());
    }

    private boolean pruneSInVP(NonTerminal nonTerminal, int n) {
        if (this.pruneSInVPEmptySubjectCondition(nonTerminal, n)) {
            List<Node> list = ((NonTerminal)nonTerminal.getChild(n)).getChildren();
            nonTerminal.getChildren().remove(n);
            nonTerminal.getChildren().addAll(n, list.subList(1, list.size()));
            return true;
        }
        return false;
    }

    private boolean pruneSInVPCondition(NonTerminal nonTerminal, int n, PruneState pruneState) {
        String string = nonTerminal.getFunction();
        String string2 = nonTerminal.getChild(n).getFunction();
        if (!string.equals("VP") || !string2.equals("S")) {
            return false;
        }
        if (nonTerminal.getChild(n).isTerminal()) {
            return false;
        }
        if (!this.isVerbsOrAdverbsInFront(n, pruneState)) {
            return false;
        }
        NonTerminal nonTerminal2 = (NonTerminal)nonTerminal.getChild(n);
        return nonTerminal2.getChildren().size() >= 2;
    }

    private boolean pruneSInVPEmptySubjectCondition(NonTerminal nonTerminal, int n) {
        NonTerminal nonTerminal2 = (NonTerminal)nonTerminal.getChild(n);
        List<Node> list = nonTerminal2.getChildren();
        if (list.get(0).isTerminal()) {
            return false;
        }
        NonTerminal nonTerminal3 = (NonTerminal)list.get(0);
        if (nonTerminal3.getChildren().size() != 0) {
            return false;
        }
        return list.get(1).getFunction().equals("VP");
    }

    private boolean npCondition(NonTerminal nonTerminal, int n, PruneState pruneState) {
        String string = nonTerminal.getFunction();
        Node node = nonTerminal.getChild(n);
        if (!string.equals("NP")) {
            return false;
        }
        if (n == nonTerminal.getChildren().size() - 1) {
            return false;
        }
        if (!nonTerminal.getChild(n + 1).getFunction().startsWith("NP")) {
            return false;
        }
        if (node.isTerminal()) {
            return false;
        }
        List<Node> list = ((NonTerminal)node).getChildren();
        if (list.size() == 0) {
            return false;
        }
        Node node2 = list.get(list.size() - 1);
        if (!node2.isTerminal()) {
            return false;
        }
        Terminal terminal = (Terminal)node2;
        return terminal.getParfOfSpeech() == null && terminal.getParfOfSpeech().equals("POS");
    }

    private static Node convert(ParseTreeNode parseTreeNode) {
        if (parseTreeNode.children == null) {
            return new Terminal((String)parseTreeNode.category, parseTreeNode.word, parseTreeNode.ann);
        }
        ArrayList<Node> arrayList = new ArrayList<Node>(parseTreeNode.children.length);
        for (ParseTreeNode parseTreeNode2 : parseTreeNode.children) {
            arrayList.add(TreeBasedChunker.convert(parseTreeNode2));
        }
        return new NonTerminal((String)parseTreeNode.category, arrayList, parseTreeNode.ann);
    }

    static {
        PRUNE_IF_IN_FRONT_OF_HEAD.add(Arrays.asList("NP", "ADJP"));
        PRUNE_IF_IN_FRONT_OF_HEAD.add(Arrays.asList("NP", "UCP"));
        PRUNE_IF_IN_FRONT_OF_HEAD.add(Arrays.asList("WHNP", "WHADJP"));
        PRUNE_IF_IN_FRONT_OF_HEAD.add(Arrays.asList("ADJP", "ADVP"));
        HEAD = new HashMap<String, Pattern>();
        HEAD.put("ADJP", Pattern.compile("JJ|RB|VB|IN|UH|FW|RP|$|#|DT|NN"));
        HEAD.put("ADVP", Pattern.compile("RB|IN|TO|DT|PDT|JJ|RP|FW|LS|UH|CC|NN|CD|VB"));
        HEAD.put("CONJP", Pattern.compile("CC|IN|RB"));
        HEAD.put("INTJ", Pattern.compile("UH|RB|NN|VB|FW|JJ"));
        HEAD.put("LST", Pattern.compile("LS|JJ|:"));
        HEAD.put("NAC", Pattern.compile("NN"));
        HEAD.put("NOLABEL", Pattern.compile("[A-Z]"));
        HEAD.put("NP", Pattern.compile("NN|CD|PRP|JJ|DT|EX|IN|RB|VB|FW|SYM|UH|WP|WDT"));
        HEAD.put("NX", Pattern.compile("NN|CD|PRP|JJ|DT|EX|FW|SYM|UH|WP|WDT"));
        HEAD.put("PP", Pattern.compile("IN|TO|RB|VBG|VBN|JJ|RP|CC|FW"));
        HEAD.put("PRT", Pattern.compile("RP|IN|RB|JJ"));
        HEAD.put("QP", Pattern.compile("CD|DT|NN|JJ"));
        HEAD.put("SBAR", Pattern.compile("IN|WDT"));
        HEAD.put("UCP", Pattern.compile("JJ|NN|VB|CD"));
        HEAD.put("VP", Pattern.compile("VB|MD|TO|JJ|NN|POS|FW|SYM|AUX|AUXG"));
        HEAD.put("WHADJP", Pattern.compile("JJ"));
        HEAD.put("WHADVP", Pattern.compile("WRB|IN|RB|WDT"));
        HEAD.put("WHNP", Pattern.compile("WDT|WP|CD|DT|IN|NN|JJ|RB"));
        HEAD.put("WHPP", Pattern.compile("IN|TO"));
        HEAD_CAT = new HashMap<String, Pattern>();
        HEAD_CAT.put("ADJP", Pattern.compile("^ADJP"));
        HEAD_CAT.put("ADVP", Pattern.compile("^ADVP|.*-ADV"));
        HEAD_CAT.put("CONJP", Pattern.compile("^CONJP"));
        HEAD_CAT.put("FRAG", Pattern.compile("^FRAG|INTJ|S|VP"));
        HEAD_CAT.put("INTJ", Pattern.compile("^S|VP|INTJ"));
        HEAD_CAT.put("LST", Pattern.compile("^LST"));
        HEAD_CAT.put("NOLABEL", Pattern.compile("^[A-Z]"));
        HEAD_CAT.put("NP", Pattern.compile("^NP|NX|.*-NOM"));
        HEAD_CAT.put("NX", Pattern.compile("^NX"));
        HEAD_CAT.put("PP", Pattern.compile("^PP"));
        HEAD_CAT.put("PRN", Pattern.compile("^S|VP"));
        HEAD_CAT.put("PRT", Pattern.compile("^PRT"));
        HEAD_CAT.put("RRC", Pattern.compile("^S|VP"));
        HEAD_CAT.put("S", Pattern.compile("^S$|VP|.*-PRD"));
        HEAD_CAT.put("SBAR", Pattern.compile("^SBAR|S|WH"));
        HEAD_CAT.put("SBARQ", Pattern.compile("^SBARQ|SQ|WH"));
        HEAD_CAT.put("SINV", Pattern.compile("^SINV|VP|SBAR"));
        HEAD_CAT.put("SQ", Pattern.compile("^SQ|VP|S|WH"));
        HEAD_CAT.put("UCP", Pattern.compile("^[A-Z]+P(-[-A-Z]+)?$|S"));
        HEAD_CAT.put("VP", Pattern.compile("^VP"));
        HEAD_CAT.put("WHADJP", Pattern.compile("^WHADJP|ADJP"));
        HEAD_CAT.put("WHADVP", Pattern.compile("^WHADVP"));
        HEAD_CAT.put("WHNP", Pattern.compile("^WHNP|NP"));
        HEAD_CAT.put("WHPP", Pattern.compile("^WHPP"));
        HEAD_CAT.put("X", Pattern.compile("^S|[A-Z]+P(-[-A-Z]+)?$"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NonTerminal
    extends Node {
        private List<Node> children;

        public NonTerminal(String string, List<Node> list, Annotation annotation) {
            super(string, annotation);
            this.children = list;
        }

        public List<Node> getChildren() {
            return this.children;
        }

        public Node getChild(int n) {
            return this.children.get(n);
        }

        @Override
        public boolean isTerminal() {
            return false;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("(");
            stringBuilder.append(this.getFunction());
            stringBuilder.append(" ");
            for (Node node : this.getChildren()) {
                stringBuilder.append(node.toString());
                stringBuilder.append(" ");
            }
            stringBuilder.append(")");
            return stringBuilder.toString();
        }
    }

    private static class Terminal
    extends Node {
        private String word;
        private String pos;
        private String chunkTag;

        public Terminal(String string, String string2, Annotation annotation) {
            super("", annotation);
            this.word = string2;
            if (string != null) {
                this.pos = string.toUpperCase();
            }
        }

        public boolean isTerminal() {
            return true;
        }

        public String getWord() {
            return this.word;
        }

        public String getParfOfSpeech() {
            return this.pos;
        }

        public void setPartOfSpeech(String string) {
            this.pos = string;
        }

        public void setChunkTag(String string) {
            this.chunkTag = string;
        }

        public String getChunkTag() {
            return this.chunkTag;
        }

        public Span span() {
            return this.getAnnotation().span();
        }

        public String toString() {
            if (this.isHead()) {
                return String.format("(%s-H %s)", this.getParfOfSpeech(), this.getWord());
            }
            return String.format("(%s %s)", this.getParfOfSpeech(), this.getWord());
        }
    }

    private static abstract class Node {
        private boolean isHead;
        private Annotation ann;
        private String function;

        public Node(String string, Annotation annotation) {
            if (string != null) {
                this.function = string.toUpperCase();
            }
            this.ann = annotation;
        }

        public String getFunction() {
            return this.function;
        }

        public void setFunction(String string) {
            this.function = string;
        }

        public boolean isHead() {
            return this.isHead;
        }

        public void setHead(boolean bl) {
            this.isHead = bl;
        }

        public Annotation getAnnotation() {
            return this.ann;
        }

        public abstract boolean isTerminal();
    }

    private static class FlattenState {
        int chunkNumber;

        private FlattenState() {
        }
    }

    private static class PruneState {
        List<Integer> lastNonRef = new ArrayList<Integer>();
        List<Integer> subFunctions = new ArrayList<Integer>();
        List<Integer> adverbs = new ArrayList<Integer>();
        boolean cc = false;

        private PruneState() {
        }
    }
}

