/*
 * Decompiled with CFR 0.152.
 */
package AceJet;

import AceJet.AceEntityMention;
import AceJet.AceEventAnchor;
import AceJet.AceMention;
import AceJet.LearnRelations;
import AceJet.RelationPattern;
import Jet.Lex.Tokenizer;
import Jet.Parser.SynFun;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import Jet.Tipster.Span;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChunkPath {
    static final Logger logger = LoggerFactory.getLogger(ChunkPath.class);
    ArrayList<String> chunks;
    Document doc;
    private static HashMap categoryRankTable = new HashMap();

    public ChunkPath(Document document, AceMention aceMention, AceMention aceMention2) {
        this.doc = document;
        if (aceMention.jetExtent.start() <= aceMention2.jetExtent.start() && aceMention.jetExtent.end() >= aceMention2.jetExtent.end()) {
            if (aceMention instanceof AceEntityMention || aceMention instanceof AceEventAnchor) {
                this.chunks = this.patternBetweenSpans(aceMention.getJetHead(), aceMention2.jetExtent);
            }
        } else if (aceMention2.jetExtent.start() <= aceMention.jetExtent.start() && aceMention2.jetExtent.end() >= aceMention.jetExtent.end()) {
            if (aceMention2 instanceof AceEntityMention || aceMention2 instanceof AceEventAnchor) {
                this.chunks = this.patternBetweenSpans(aceMention.jetExtent, aceMention2.getJetHead());
            }
        } else {
            this.chunks = this.patternBetweenSpans(aceMention.jetExtent, aceMention2.jetExtent);
        }
    }

    public ChunkPath(Document document, int n, int n2) {
        this.doc = document;
        this.chunks = this.buildPattern(n, n2);
    }

    private ArrayList patternBetweenSpans(Span span, Span span2) {
        ArrayList<String> arrayList = null;
        if (span.start() < span2.start()) {
            arrayList = this.buildPattern(span.end(), span2.start());
        } else {
            logger.warn("*** Unexpected span order.");
            logger.warn("Span1 = " + this.doc.text(span));
            logger.warn("Span2 = " + this.doc.text(span2));
            arrayList = null;
        }
        return arrayList;
    }

    private ArrayList<String> buildPattern(int n, int n2) {
        int n3 = Tokenizer.skipWS(this.doc, n, this.doc.length());
        ArrayList<String> arrayList = new ArrayList<String>();
        while (n3 < n2) {
            String string;
            int n4;
            int n5;
            Vector<Annotation> vector = this.doc.annotationsAt(n3, "constit");
            Annotation annotation = null;
            if (vector != null) {
                int n6 = -1;
                n5 = -1;
                for (n4 = 0; n4 < vector.size(); ++n4) {
                    Annotation annotation2 = vector.get(n4);
                    String string2 = (String)annotation2.get("cat");
                    int n7 = annotation2.span().end();
                    if (n7 <= n6 && (n7 != n6 || ChunkPath.categoryRank(string2) <= n5) || n7 > n2) continue;
                    n6 = annotation2.span().end();
                    annotation = annotation2;
                    n5 = ChunkPath.categoryRank(string2);
                }
            }
            if (annotation != null) {
                String string3;
                string = (String)annotation.get("cat");
                if (!this.noiseToken(string, string3 = SynFun.getHead(this.doc, annotation))) {
                    arrayList.add(string3);
                }
                n3 = annotation.span().end();
                continue;
            }
            Annotation annotation3 = this.doc.tokenAt(n3);
            if (annotation3 != null) {
                string = this.doc.text(annotation3).trim();
                arrayList.add(string);
                n3 = annotation3.span().end();
                continue;
            }
            logger.warn("buildPattern:  no constits at position " + n3);
            String string4 = this.doc.text();
            n5 = n3 < 10 ? 0 : n3 - 10;
            n4 = n3 + 10 > string4.length() ? string4.length() : n3 + 10;
            logger.warn("               text(" + n5 + ":" + n4 + ")" + " = " + string4.substring(n5, n4));
            return null;
        }
        return arrayList;
    }

    private boolean noiseToken(String string, String string2) {
        return string == "adv" || string == "timex" || string == "q" || string2.equals("'") || string2.equals("''") || string2.equals("\"") || string2.equals("timex");
    }

    private static int categoryRank(String string) {
        Integer n = (Integer)categoryRankTable.get(string);
        if (n == null) {
            return 0;
        }
        return n;
    }

    public ArrayList<String> getChunks() {
        return this.chunks;
    }

    public String getLastChunk() {
        if (this.chunks != null && this.chunks.size() > 0) {
            return this.chunks.get(this.chunks.size() - 1);
        }
        return null;
    }

    public int size() {
        if (this.chunks == null) {
            return -1;
        }
        return this.chunks.size();
    }

    public boolean contains(String string) {
        return this.chunks.contains(string);
    }

    public String toString() {
        return LearnRelations.concat(this.chunks);
    }

    public void write(PrintWriter printWriter) {
        printWriter.println(this.toString());
    }

    public ChunkPath(String string) {
        String[] stringArray = string.split(" ");
        this.chunks = new ArrayList(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            this.chunks.add(stringArray[i]);
        }
    }

    public boolean equals(ChunkPath chunkPath) {
        if (this.chunks == null) {
            return false;
        }
        if (this.chunks.size() != chunkPath.size()) {
            return false;
        }
        for (int i = 0; i < this.chunks.size(); ++i) {
            if (this.chunks.get(i).equals(chunkPath.getChunks().get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public int matchFromLeft(int n, Document document) {
        if (this.chunks == null) {
            return -1;
        }
        n = this.skipNoiseTokenFromLeft(n, document);
        block0: for (int i = 0; i < this.chunks.size(); ++i) {
            Annotation annotation;
            Object object;
            String string = this.chunks.get(i);
            Vector<Annotation> vector = document.annotationsAt(n, "constit");
            if (vector != null) {
                for (int j = 0; j < vector.size(); ++j) {
                    object = vector.get(j);
                    String string2 = (String)((Annotation)object).get("cat");
                    String string3 = string2 == "adv" || string2 == "timex" || string2 == "q" ? string2 + "(" + SynFun.getHead(document, (Annotation)object) + ")" : SynFun.getHead(document, (Annotation)object);
                    if (!string3.equals(string)) continue;
                    n = ((Annotation)object).end();
                    n = this.skipNoiseTokenFromLeft(n, document);
                    continue block0;
                }
            }
            if ((annotation = document.tokenAt(n)) != null && ((String)(object = document.text(annotation).trim())).equals(string)) {
                n = annotation.end();
                n = this.skipNoiseTokenFromLeft(n, document);
                continue;
            }
            return -1;
        }
        return n;
    }

    private int skipNoiseTokenFromLeft(int n, Document document) {
        Vector<Annotation> vector = document.annotationsAt(n, "constit");
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                Annotation annotation = vector.get(i);
                String string = (String)annotation.get("cat");
                String string2 = string == "adv" || string == "timex" || string == "q" ? string + "(" + SynFun.getHead(document, annotation) + ")" : SynFun.getHead(document, annotation);
                if (!RelationPattern.noiseToken(string2)) continue;
                return annotation.end();
            }
        }
        return n;
    }

    public int matchFromRight(int n, Document document) {
        if (this.chunks == null) {
            return -1;
        }
        n = this.skipNoiseTokenFromRight(n, document);
        block0: for (int i = 0; i < this.chunks.size(); ++i) {
            Annotation annotation;
            Object object;
            String string = this.chunks.get(i);
            Vector<Annotation> vector = document.annotationsEndingAt(n, "constit");
            if (vector != null) {
                for (int j = 0; j < vector.size(); ++j) {
                    object = vector.get(j);
                    String string2 = (String)((Annotation)object).get("cat");
                    String string3 = string2 == "adv" || string2 == "timex" || string2 == "q" ? string2 + "(" + SynFun.getHead(document, (Annotation)object) + ")" : SynFun.getHead(document, (Annotation)object);
                    if (!string3.equals(string)) continue;
                    n = ((Annotation)object).start();
                    n = this.skipNoiseTokenFromRight(n, document);
                    continue block0;
                }
            }
            if ((annotation = document.tokenEndingAt(n)) != null && ((String)(object = document.text(annotation).trim())).equals(string)) {
                n = annotation.start();
                n = this.skipNoiseTokenFromLeft(n, document);
                continue;
            }
            return -1;
        }
        return n;
    }

    private int skipNoiseTokenFromRight(int n, Document document) {
        Vector<Annotation> vector = document.annotationsEndingAt(n, "constit");
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                Annotation annotation = vector.get(i);
                String string = (String)annotation.get("cat");
                String string2 = string == "adv" || string == "timex" || string == "q" ? string + "(" + SynFun.getHead(document, annotation) + ")" : SynFun.getHead(document, annotation);
                if (!RelationPattern.noiseToken(string2)) continue;
                return annotation.start();
            }
        }
        return n;
    }

    static {
        categoryRankTable.put("name", new Integer(1));
        categoryRankTable.put("timex", new Integer(1));
        categoryRankTable.put("np", new Integer(2));
        categoryRankTable.put("np-pro", new Integer(2));
        categoryRankTable.put("vgroup", new Integer(2));
        categoryRankTable.put("vgroup-inf", new Integer(2));
        categoryRankTable.put("vgroup-pass", new Integer(2));
        categoryRankTable.put("vgroup-ving", new Integer(2));
        categoryRankTable.put("vgroup-ven", new Integer(2));
        categoryRankTable.put("vp", new Integer(3));
        categoryRankTable.put("vp-inf", new Integer(3));
        categoryRankTable.put("vingo", new Integer(3));
        categoryRankTable.put("s", new Integer(4));
    }
}

