/*
 * Decompiled with CFR 0.152.
 */
package AceJet;

import AceJet.Ace;
import AceJet.AceEntity;
import AceJet.AceEntityMention;
import AceJet.AceEvent;
import AceJet.AceEventArgumentValue;
import AceJet.AceMention;
import AceJet.AcePlus;
import AceJet.AceRelation;
import AceJet.AceTimex;
import AceJet.AceValue;
import Jet.JetTest;
import Jet.Tipster.Document;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AceDocument {
    public static boolean ace2004 = true;
    public static boolean ace2005 = true;
    private static DocumentBuilder builder = null;
    private String fileText;
    private StringBuffer fileTextWithXML;
    public String sourceFile;
    public String sourceType;
    public String docID;
    public ArrayList<AceEntity> entities = new ArrayList();
    public ArrayList<AceTimex> timeExpressions = new ArrayList();
    public ArrayList<AceValue> values = new ArrayList();
    public ArrayList<AceRelation> relations = new ArrayList();
    public ArrayList<AceEvent> events = new ArrayList();
    private static final String encoding = "ISO-8859-1";
    TreeSet<AceMention> allMentionsSet = new TreeSet();
    ArrayList<AceMention> allMentionsList = new ArrayList();

    public AceDocument(String string, String string2, String string3, String string4) {
        this.sourceFile = string;
        this.sourceType = string2;
        this.docID = string3;
        this.fileText = string4;
    }

    public AceDocument(String string, String string2) {
        try {
            if (builder == null) {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setValidating(false);
                builder = documentBuilderFactory.newDocumentBuilder();
            }
            this.analyzeDocument(string, string2);
        }
        catch (SAXException sAXException) {
            System.err.println("AceDocument:  Exception in initializing APF reader: " + sAXException);
        }
        catch (IOException iOException) {
            System.err.println("AceDocument:  Exception in initializing APF reader: " + iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.err.println("AceDocument:  Exception in initializing APF reader: " + parserConfigurationException);
        }
    }

    private void analyzeDocument(String string, String string2) throws SAXException, IOException {
        org.w3c.dom.Document document = builder.parse(string2);
        this.fileTextWithXML = AceDocument.readDocument(string);
        this.fileText = AceDocument.eraseXML(this.fileTextWithXML);
        this.readAPFdocument(document, this.fileText);
    }

    void readAPFdocument(org.w3c.dom.Document document, String string) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        NodeList nodeList = document.getElementsByTagName("source_file");
        Element element = (Element)nodeList.item(0);
        this.sourceFile = element.getAttribute("URI");
        this.sourceType = element.getAttribute("SOURCE");
        NodeList nodeList2 = document.getElementsByTagName("document");
        Element element2 = (Element)nodeList2.item(0);
        this.docID = element2.getAttribute("DOCID");
        if (Ace.perfectMentions & !Ace.perfectEntities) {
            this.readPerfectMentions(document, string);
            return;
        }
        NodeList nodeList3 = document.getElementsByTagName("entity");
        for (int i = 0; i < nodeList3.getLength(); ++i) {
            Element element3 = (Element)nodeList3.item(i);
            object4 = new AceEntity(element3, string);
            this.addEntity((AceEntity)object4);
        }
        NodeList nodeList4 = document.getElementsByTagName("value");
        for (int i = 0; i < nodeList4.getLength(); ++i) {
            object4 = (Element)nodeList4.item(i);
            object3 = new AceValue((Element)object4, string);
            this.addValue((AceValue)object3);
        }
        NodeList nodeList5 = document.getElementsByTagName("timex2");
        for (int i = 0; i < nodeList5.getLength(); ++i) {
            object3 = (Element)nodeList5.item(i);
            object2 = new AceTimex((Element)object3, string);
            this.addTimeExpression((AceTimex)object2);
        }
        NodeList nodeList6 = document.getElementsByTagName("relation");
        for (int i = 0; i < nodeList6.getLength(); ++i) {
            object2 = (Element)nodeList6.item(i);
            object = new AceRelation((Element)object2, this, string);
            this.addRelation((AceRelation)object);
        }
        NodeList nodeList7 = document.getElementsByTagName("event");
        for (int i = 0; i < nodeList7.getLength(); ++i) {
            object = (Element)nodeList7.item(i);
            AceEvent aceEvent = new AceEvent((Element)object, this, string);
            this.addEvent(aceEvent);
        }
    }

    public void addEntity(AceEntity aceEntity) {
        this.entities.add(aceEntity);
        this.allMentionsSet.addAll(aceEntity.mentions);
        this.allMentionsList = new ArrayList<AceMention>(this.allMentionsSet);
    }

    public void addValue(AceValue aceValue) {
        this.values.add(aceValue);
        this.allMentionsSet.addAll(aceValue.mentions);
        this.allMentionsList = new ArrayList<AceMention>(this.allMentionsSet);
    }

    public void addTimeExpression(AceTimex aceTimex) {
        this.timeExpressions.add(aceTimex);
        this.allMentionsSet.addAll(aceTimex.mentions);
        this.allMentionsList = new ArrayList<AceMention>(this.allMentionsSet);
    }

    public void addRelation(AceRelation aceRelation) {
        this.relations.add(aceRelation);
    }

    public void addEvent(AceEvent aceEvent) {
        this.events.add(aceEvent);
    }

    static String getElementText(Element element, String string) {
        NodeList nodeList = element.getElementsByTagName(string);
        Element element2 = (Element)nodeList.item(0);
        String string2 = element2.getFirstChild().getNodeValue();
        return string2;
    }

    void readPerfectMentions(org.w3c.dom.Document document, String string) {
        NodeList nodeList = document.getElementsByTagName("entity_mention");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            String string2 = "E" + element.getAttribute("ID");
            String string3 = element.getAttribute("ENTITY_TYPE");
            if (AceEntity.standardType.containsKey(string3)) {
                string3 = (String)AceEntity.standardType.get(string3);
            }
            String string4 = element.getAttribute("ENTITY_SUBTYPE");
            if (!string3.equals("PERSON") && !string3.equals("") && string4.equals("")) {
                string4 = "Other";
            }
            AceEntityMention aceEntityMention = new AceEntityMention(element, string);
            AceEntity aceEntity = new AceEntity(string2, string3, string4, false);
            aceEntity.addMention(aceEntityMention);
            this.addEntity(aceEntity);
        }
    }

    static StringBuffer readDocument(String string) throws IOException {
        String string2;
        File file = new File(string);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), encoding));
        StringBuffer stringBuffer = new StringBuffer();
        while ((string2 = bufferedReader.readLine()) != null) {
            stringBuffer.append(string2 + "\n");
        }
        return stringBuffer;
    }

    static String eraseXML(StringBuffer stringBuffer) {
        boolean bl = false;
        int n = stringBuffer.length();
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            char c = stringBuffer.charAt(i);
            if (c == '<') {
                bl = true;
            }
            if (!bl) {
                stringBuffer2.append(c);
            }
            if (c != '>') continue;
            bl = false;
        }
        return stringBuffer2.toString();
    }

    public Document JetDocument() {
        Document document = new Document(this.fileTextWithXML.toString());
        document.annotateWithTag("TEXT");
        return document;
    }

    AceEntity findEntity(String string) {
        for (int i = 0; i < this.entities.size(); ++i) {
            AceEntity aceEntity = this.entities.get(i);
            if (!aceEntity.id.equals(string)) continue;
            return aceEntity;
        }
        System.err.println("*** unable to find entity with id " + string);
        return null;
    }

    AceEventArgumentValue findEntityValueTimex(String string) {
        AceEventArgumentValue aceEventArgumentValue;
        int n;
        for (n = 0; n < this.values.size(); ++n) {
            aceEventArgumentValue = this.values.get(n);
            if (!aceEventArgumentValue.id.equals(string)) continue;
            return aceEventArgumentValue;
        }
        for (n = 0; n < this.timeExpressions.size(); ++n) {
            aceEventArgumentValue = this.timeExpressions.get(n);
            if (!((AceTimex)aceEventArgumentValue).id.equals(string)) continue;
            return aceEventArgumentValue;
        }
        return this.findEntity(string);
    }

    AceEntityMention findEntityMention(String string) {
        for (int i = 0; i < this.entities.size(); ++i) {
            AceEntity aceEntity = this.entities.get(i);
            AceEntityMention aceEntityMention = aceEntity.findMention(string);
            if (aceEntityMention == null) continue;
            return aceEntityMention;
        }
        System.err.println("*** unable to find entity mention with id " + string);
        return null;
    }

    AceMention findMention(String string) {
        AceMention aceMention;
        AceEventArgumentValue aceEventArgumentValue;
        int n;
        for (n = 0; n < this.values.size(); ++n) {
            aceEventArgumentValue = this.values.get(n);
            aceMention = ((AceValue)aceEventArgumentValue).findMention(string);
            if (aceMention == null) continue;
            return aceMention;
        }
        for (n = 0; n < this.timeExpressions.size(); ++n) {
            aceEventArgumentValue = this.timeExpressions.get(n);
            aceMention = ((AceTimex)aceEventArgumentValue).findMention(string);
            if (aceMention == null) continue;
            return aceMention;
        }
        return this.findEntityMention(string);
    }

    ArrayList<AceMention> getAllMentions() {
        return this.allMentionsList;
    }

    public void write(PrintWriter printWriter, Document document) {
        Object object;
        int n;
        printWriter.println("<?xml version=\"1.0\"?>");
        printWriter.println("<!DOCTYPE source_file SYSTEM \"apf.v5.1.1.dtd\">");
        printWriter.print("<source_file URI=\"" + this.sourceFile + "\"");
        printWriter.println(" SOURCE=\"" + this.sourceType + "\" TYPE=\"text\" AUTHOR=\"NYU\">");
        printWriter.println("<document DOCID=\"" + this.docID + "\">");
        String string = JetTest.getConfig("Ace.extendedAPF");
        if (string != null) {
            AcePlus.write(document, printWriter);
        }
        for (n = 0; n < this.entities.size(); ++n) {
            object = this.entities.get(n);
            ((AceEntity)object).write(printWriter);
        }
        for (n = 0; n < this.values.size(); ++n) {
            object = this.values.get(n);
            ((AceValue)object).write(printWriter);
        }
        for (n = 0; n < this.timeExpressions.size(); ++n) {
            object = this.timeExpressions.get(n);
            ((AceTimex)object).write(printWriter);
        }
        for (n = 0; n < this.relations.size(); ++n) {
            object = this.relations.get(n);
            ((AceRelation)object).write(printWriter);
        }
        for (n = 0; n < this.events.size(); ++n) {
            object = this.events.get(n);
            ((AceEvent)object).write(printWriter);
        }
        printWriter.println("</document>");
        printWriter.println("</source_file>");
        printWriter.close();
    }

    public static void main(String[] stringArray) {
        String string = "C:/Documents and Settings/Ralph Grishman/My Documents/";
        String string2 = string + "ace 05/";
        String string3 = string2 + "AFP_ENG_20030304.0250.apf.xml";
        String string4 = string2 + "AFP_ENG_20030304.0250.sgm";
        AceDocument aceDocument = new AceDocument(string4, string3);
        aceDocument.write(new PrintWriter(System.out), null);
    }
}

