/*
 * Decompiled with CFR 0.152.
 */
package pnuts.tools;

import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import pnuts.lang.Context;
import pnuts.lang.Pnuts;
import pnuts.lang.PnutsException;
import pnuts.lang.Runtime;
import pnuts.lang.SimpleNode;
import pnuts.tools.CommandEvent;
import pnuts.tools.DebugContext;
import pnuts.tools.Debugger;
import pnuts.tools.VisualDebuggerView;

public class VisualDebuggerModel
extends Runtime
implements Debugger {
    DebugContext dc;
    boolean quit;
    private Object currentSource;
    private int currentLine;
    private int n_nexts;
    private int n_steps;
    private int command;
    private Hashtable files = new Hashtable();
    private boolean initialized = false;
    private int initialEvalDepth;
    private int initialCallDepth;
    private int e_depth;
    private int c_depth;
    private PrintWriter errorStream;
    private Object traceTag;
    private Context parent;
    private VisualDebuggerView view;
    static final int OPEN = 1;
    static final int STEP = 2;
    static final int STEP_UP = 3;
    static final int NEXT = 4;
    static final int CONT = 5;
    static final int CLOSE = 6;
    static final int CLEAR_BP = 7;
    static final int INSPECT = 8;

    void setView(VisualDebuggerView view) {
        this.view = view;
    }

    void init(DebugContext dc) {
        this.quit = false;
        this.dc = dc;
        dc.setDebugger(this);
        this.initialEvalDepth = Pnuts.evalDepth(dc);
        this.e_depth = 0;
        this.c_depth = 0;
        this.n_steps = 1;
        this.n_nexts = 1;
    }

    public synchronized void do_step(int n) {
        this.command = 2;
        this.n_steps = n;
        this.notifyAll();
    }

    public synchronized void do_stepup() {
        this.command = 3;
        this.c_depth = this.dc.getCallDepth();
        this.e_depth = this.dc.getEvalDepth();
        this.notifyAll();
    }

    public synchronized void do_next(int n) {
        this.command = 4;
        this.n_nexts = n;
        this.notifyAll();
    }

    public synchronized void do_cont() {
        this.command = 5;
        this.n_steps = 0;
        this.n_nexts = 0;
        this.notifyAll();
    }

    public synchronized void do_close() {
        this.command = 5;
        this.quit = true;
        this.notifyAll();
    }

    public Object getCurrentSource() {
        return this.currentSource;
    }

    public void setBreakPoint(Object source, int lineno) {
        Integer i;
        if (source == null) {
            return;
        }
        Vector<Integer> lines = (Vector<Integer>)this.files.get(source);
        if (lines == null) {
            lines = new Vector<Integer>();
            this.files.put(source, lines);
        }
        if (!lines.contains(i = new Integer(lineno + 1))) {
            lines.addElement(i);
        }
    }

    public void removeBreakPoint(Object source, int lineno) {
        if (source == null) {
            return;
        }
        Vector lines = (Vector)this.files.get(source);
        if (lines == null) {
            return;
        }
        lines.removeElement(new Integer(lineno + 1));
    }

    public Vector getBreakPoints(Object source) {
        if (source == null) {
            return null;
        }
        return (Vector)this.files.get(source);
    }

    public void clearBreakPoints() {
        this.files.clear();
    }

    public void signal(CommandEvent event) {
        this.dc = (DebugContext)event.getSource();
        int eventType = event.getType();
        if (eventType == 2) {
            if (this.dc.getEvalDepth() <= this.initialEvalDepth && this.dc.getCallDepth() <= this.initialCallDepth) {
                if (!this.quit) {
                    this.showScript(this.dc.getScriptSource(), -1, null, this.dc);
                }
                this.initialized = false;
            }
            return;
        }
        if (eventType == 0) {
            SimpleNode node = (SimpleNode)event.getArg();
            int beginLine = this.dc.getBeginLine();
            int endLine = this.dc.getEndLine();
            Object source = this.dc.getScriptSource();
            if (!this.initialized) {
                this.init(this.dc);
                this.initialized = true;
                this.c_depth = this.dc.getCallDepth();
                this.e_depth = this.dc.getEvalDepth();
                this.initialCallDepth = this.dc.getCallDepth();
                this.showScript(source, beginLine, node, this.dc);
                this.waitForCommands();
                this.currentLine = beginLine;
                return;
            }
            if (this.hasToStop(source, node, beginLine, endLine)) {
                this.c_depth = this.dc.getCallDepth();
                this.e_depth = this.dc.getEvalDepth();
                this.showScript(source, beginLine, node, this.dc);
                this.waitForCommands();
                this.currentLine = beginLine;
            }
        } else if (eventType == 1) {
            Throwable t = (Throwable)event.getArg();
            if (t instanceof PnutsException) {
                PnutsException pe = (PnutsException)t;
                Object source = pe.getScriptSource();
                int beginLine = pe.getLine();
                this.showScript(source, beginLine, null, this.dc);
            }
            this.initialized = false;
        }
    }

    boolean checkBreakPoint(Vector lines, SimpleNode node, int begin, int end) {
        if (node != null && node.id == 77) {
            return false;
        }
        Enumeration e = lines.elements();
        while (e.hasMoreElements()) {
            int bp = (Integer)e.nextElement();
            if (bp < begin || bp > end) continue;
            return true;
        }
        return false;
    }

    boolean hasToStop(Object source, SimpleNode node, int beginLine, int endLine) {
        Vector lines;
        int d1;
        if (source instanceof Runtime) {
            return false;
        }
        if (source == null && node != null && this.command != 5) {
            return true;
        }
        if (this.command == 1) {
            this.currentLine = beginLine;
            this.command = 0;
            return true;
        }
        if (this.command == 2) {
            if (--this.n_steps < 1) {
                return true;
            }
        } else if (this.command == 4) {
            d1 = this.dc.getEvalDepth();
            int d2 = this.dc.getCallDepth();
            if (this.e_depth >= d1 && this.c_depth >= d2 && (this.currentSource != source || this.currentLine != beginLine) && --this.n_nexts < 1) {
                return true;
            }
        } else if (this.command == 3) {
            d1 = this.dc.getEvalDepth();
            int d2 = this.dc.getCallDepth();
            if (this.e_depth > d1 || this.e_depth >= d1 && this.c_depth > d2) {
                return true;
            }
        }
        if ((lines = this.getBreakPoints(source)) != null && this.checkBreakPoint(lines, node, beginLine, endLine)) {
            this.currentLine = beginLine;
            return true;
        }
        return false;
    }

    synchronized void waitForCommands() {
        this.command = 0;
        try {
            while (this.command == 0) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.quit) {
            Runtime.escape(null);
        }
    }

    protected void showScript(Object source, int line, SimpleNode node, Context context) {
        if (!this.quit && this.view != null) {
            this.view.update(source, line, node, context);
        }
        this.currentSource = source;
    }
}

